/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.bnf.Bnf;
import org.h2.bnf.Rule;
import org.h2.bnf.Sentence;

public class RuleList
implements Rule {
    private boolean or;
    private ArrayList list = new ArrayList();
    private boolean mapSet;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.or) {
            stringBuffer.append("{");
            for (int i = 0; i < this.list.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append(this.list.get(i).toString());
            }
            stringBuffer.append("}");
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.list.get(i).toString());
            }
        }
        return stringBuffer.toString();
    }

    RuleList(Rule rule, Rule rule2, boolean bl) {
        if (rule instanceof RuleList && ((RuleList)rule).or == bl) {
            this.list.addAll(((RuleList)rule).list);
        } else {
            this.list.add(rule);
        }
        if (rule2 instanceof RuleList && ((RuleList)rule2).or == bl) {
            this.list.addAll(((RuleList)rule2).list);
        } else {
            this.list.add(rule2);
        }
        if (!bl) {
            // empty if block
        }
        this.or = bl;
    }

    public String random(Bnf bnf, int n) {
        if (this.or) {
            if (n > 10) {
                if (n > 1000) {
                    throw new Error();
                }
                return this.get(0).random(bnf, n);
            }
            int n2 = bnf.getRandom().nextInt(this.list.size());
            return this.get(n2).random(bnf, n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.list.size(); ++i) {
            stringBuffer.append(this.get(i).random(bnf, n + 1));
        }
        return stringBuffer.toString();
    }

    private Rule get(int n) {
        return (Rule)this.list.get(n);
    }

    public String name() {
        return null;
    }

    public Rule last() {
        return this.get(this.list.size() - 1);
    }

    public void setLinks(HashMap hashMap) {
        if (!this.mapSet) {
            for (int i = 0; i < this.list.size(); ++i) {
                this.get(i).setLinks(hashMap);
            }
            this.mapSet = true;
        }
    }

    public boolean matchRemove(Sentence sentence) {
        String string = sentence.query;
        if (string.length() == 0) {
            return false;
        }
        if (this.or) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.get(i).matchRemove(sentence)) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Rule rule = this.get(i);
            if (rule.matchRemove(sentence)) continue;
            return false;
        }
        return true;
    }

    public void addNextTokenList(Sentence sentence) {
        String string = sentence.query;
        if (this.or) {
            for (int i = 0; i < this.list.size(); ++i) {
                sentence.setQuery(string);
                Rule rule = this.get(i);
                rule.addNextTokenList(sentence);
            }
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                Rule rule = this.get(i);
                rule.addNextTokenList(sentence);
                if (rule.matchRemove(sentence)) {
                    continue;
                }
                break;
            }
        }
        sentence.setQuery(string);
    }
}

