/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.AggregateData;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Aggregate
extends Expression {
    public static final int COUNT_ALL = 0;
    public static final int COUNT = 1;
    public static final int SUM = 2;
    public static final int MIN = 3;
    public static final int MAX = 4;
    public static final int AVG = 5;
    public static final int GROUP_CONCAT = 6;
    public static final int STDDEV_POP = 7;
    public static final int STDDEV_SAMP = 8;
    public static final int VAR_POP = 9;
    public static final int VAR_SAMP = 10;
    public static final int SOME = 11;
    public static final int EVERY = 12;
    public static final int SELECTIVITY = 13;
    private final Database database;
    private final int type;
    private final Select select;
    private final boolean distinct;
    private Expression on;
    private Expression separator;
    private ObjectArray orderList;
    private SortOrder sort;
    private int dataType;
    private int scale;
    private long precision;
    private int displaySize;
    private static final HashMap AGGREGATES = new HashMap();

    public Aggregate(Database database, int n, Expression expression, Select select, boolean bl) {
        this.database = database;
        this.type = n;
        this.on = expression;
        this.select = select;
        this.distinct = bl;
    }

    private static void addAggregate(String string, int n) {
        AGGREGATES.put(string, ObjectUtils.getInteger(n));
    }

    public static int getAggregateType(String string) {
        Integer n = (Integer)AGGREGATES.get(string);
        return n == null ? -1 : n;
    }

    public void setOrder(ObjectArray objectArray) {
        this.orderList = objectArray;
    }

    public void setSeparator(Expression expression) {
        this.separator = expression;
    }

    private SortOrder initOrder(Session session) throws SQLException {
        int[] nArray = new int[this.orderList.size()];
        int[] nArray2 = new int[this.orderList.size()];
        for (int i = 0; i < this.orderList.size(); ++i) {
            int n;
            SelectOrderBy selectOrderBy = (SelectOrderBy)this.orderList.get(i);
            nArray[i] = i + 1;
            nArray2[i] = n = selectOrderBy.descending ? 1 : 0;
        }
        return new SortOrder(session.getDatabase(), nArray, nArray2);
    }

    public void updateAggregate(Session session) throws SQLException {
        Value value;
        HashMap hashMap = this.select.getCurrentGroup();
        if (hashMap == null) {
            return;
        }
        AggregateData aggregateData = (AggregateData)hashMap.get(this);
        if (aggregateData == null) {
            aggregateData = new AggregateData(this.type);
            hashMap.put(this, aggregateData);
        }
        Value value2 = value = this.on == null ? null : this.on.getValue(session);
        if (this.type == 6 && value != ValueNull.INSTANCE) {
            value = value.convertTo(13);
            if (this.orderList != null) {
                Value[] valueArray = new Value[1 + this.orderList.size()];
                valueArray[0] = value;
                for (int i = 0; i < this.orderList.size(); ++i) {
                    SelectOrderBy selectOrderBy = (SelectOrderBy)this.orderList.get(i);
                    valueArray[i + 1] = selectOrderBy.expression.getValue(session);
                }
                value = ValueArray.get(valueArray);
            }
        }
        aggregateData.add(this.database, this.distinct, value);
    }

    public Value getValue(Session session) throws SQLException {
        if (this.select.isQuickAggregateQuery()) {
            switch (this.type) {
                case 0: {
                    Table table = this.select.getTopTableFilter().getTable();
                    return ValueLong.get(table.getRowCount(session));
                }
                case 3: 
                case 4: {
                    Cursor cursor;
                    SearchRow searchRow;
                    boolean bl = this.type == 3;
                    Index index = this.getColumnIndex(bl);
                    int n = index.getIndexColumns()[0].sortType;
                    if ((n & 1) != 0) {
                        bl = !bl;
                    }
                    Value value = (searchRow = (cursor = index.findFirstOrLast(session, bl)).getSearchRow()) == null ? ValueNull.INSTANCE : searchRow.getValue(index.getColumns()[0].getColumnId());
                    return value;
                }
            }
            throw Message.getInternalError("type=" + this.type);
        }
        HashMap hashMap = this.select.getCurrentGroup();
        if (hashMap == null) {
            throw Message.getSQLException(90054, this.getSQL());
        }
        AggregateData aggregateData = (AggregateData)hashMap.get(this);
        if (aggregateData == null) {
            aggregateData = new AggregateData(this.type);
        }
        Value value = aggregateData.getValue(this.database, this.distinct);
        if (this.type == 6) {
            ObjectArray objectArray = aggregateData.getList();
            if (objectArray == null || objectArray.size() == 0) {
                return ValueNull.INSTANCE;
            }
            if (this.orderList != null) {
                try {
                    objectArray.sort(new Comparator(){

                        public int compare(Object object, Object object2) {
                            try {
                                Value[] valueArray = ((ValueArray)object).getList();
                                Value[] valueArray2 = ((ValueArray)object2).getList();
                                return Aggregate.this.sort.compare(valueArray, valueArray2);
                            }
                            catch (SQLException sQLException) {
                                throw Message.convertToInternal(sQLException);
                            }
                        }
                    });
                }
                catch (Error error) {
                    throw Message.convert(error);
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.separator == null ? "," : this.separator.getValue(session).getString();
            for (int i = 0; i < objectArray.size(); ++i) {
                Value value2 = (Value)objectArray.get(i);
                String string2 = value2.getType() == 17 ? ((ValueArray)value2).getList()[0].getString() : value2.convertTo(13).getString();
                if (string2 == null) continue;
                if (i > 0 && string != null) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(string2);
            }
            value = ValueString.get(stringBuffer.toString());
        }
        return value;
    }

    public int getType() {
        return this.dataType;
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        if (this.on != null) {
            this.on.mapColumns(columnResolver, n);
        }
        if (this.orderList != null) {
            for (int i = 0; i < this.orderList.size(); ++i) {
                SelectOrderBy selectOrderBy = (SelectOrderBy)this.orderList.get(i);
                selectOrderBy.expression.mapColumns(columnResolver, n);
            }
        }
        if (this.separator != null) {
            this.separator.mapColumns(columnResolver, n);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        if (this.on != null) {
            this.on = this.on.optimize(session);
            this.dataType = this.on.getType();
            this.scale = this.on.getScale();
            this.precision = this.on.getPrecision();
            this.displaySize = this.on.getDisplaySize();
        }
        if (this.orderList != null) {
            for (int i = 0; i < this.orderList.size(); ++i) {
                SelectOrderBy selectOrderBy = (SelectOrderBy)this.orderList.get(i);
                selectOrderBy.expression = selectOrderBy.expression.optimize(session);
            }
            this.sort = this.initOrder(session);
        }
        if (this.separator != null) {
            this.separator = this.separator.optimize(session);
        }
        switch (this.type) {
            case 6: {
                this.dataType = 13;
                this.scale = 0;
                this.precision = Integer.MAX_VALUE;
                this.displaySize = Integer.MAX_VALUE;
                break;
            }
            case 0: 
            case 1: {
                this.dataType = 5;
                this.scale = 0;
                this.precision = 19L;
                this.displaySize = 20;
                break;
            }
            case 13: {
                this.dataType = 4;
                this.scale = 0;
                this.precision = 10L;
                this.displaySize = 11;
                break;
            }
            case 2: 
            case 5: {
                if (DataType.supportsAdd(this.dataType)) break;
                throw Message.getSQLException(90015, this.getSQL());
            }
            case 3: 
            case 4: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.dataType = 7;
                this.precision = 17L;
                this.displaySize = 24;
                this.scale = 0;
                break;
            }
            case 11: 
            case 12: {
                this.dataType = 1;
                this.precision = 1L;
                this.displaySize = 5;
                this.scale = 0;
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.on != null) {
            this.on.setEvaluatable(tableFilter, bl);
        }
        if (this.orderList != null) {
            for (int i = 0; i < this.orderList.size(); ++i) {
                SelectOrderBy selectOrderBy = (SelectOrderBy)this.orderList.get(i);
                selectOrderBy.expression.setEvaluatable(tableFilter, bl);
            }
        }
        if (this.separator != null) {
            this.separator.setEvaluatable(tableFilter, bl);
        }
    }

    public int getScale() {
        return this.scale;
    }

    public long getPrecision() {
        return this.precision;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public String getSQL() {
        String string;
        switch (this.type) {
            case 6: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("GROUP_CONCAT(");
                stringBuffer.append(this.on.getSQL());
                if (this.orderList != null) {
                    stringBuffer.append(" ORDER BY ");
                    for (int i = 0; i < this.orderList.size(); ++i) {
                        SelectOrderBy selectOrderBy = (SelectOrderBy)this.orderList.get(i);
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(selectOrderBy.expression.getSQL());
                        if (!selectOrderBy.descending) continue;
                        stringBuffer.append(" DESC");
                    }
                }
                if (this.separator != null) {
                    stringBuffer.append(" SEPARATOR ");
                    stringBuffer.append(this.separator.getSQL());
                }
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
            case 0: {
                return "COUNT(*)";
            }
            case 1: {
                string = "COUNT";
                break;
            }
            case 13: {
                string = "SELECTIVITY";
                break;
            }
            case 2: {
                string = "SUM";
                break;
            }
            case 3: {
                string = "MIN";
                break;
            }
            case 4: {
                string = "MAX";
                break;
            }
            case 5: {
                string = "AVG";
                break;
            }
            case 7: {
                string = "STDDEV_POP";
                break;
            }
            case 8: {
                string = "STDDEV_SAMP";
                break;
            }
            case 9: {
                string = "VAR_POP";
                break;
            }
            case 10: {
                string = "VAR_SAMP";
                break;
            }
            case 12: {
                string = "EVERY";
                break;
            }
            case 11: {
                string = "SOME";
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        if (this.distinct) {
            return string + "(DISTINCT " + this.on.getSQL() + ")";
        }
        return string + StringUtils.enclose(this.on.getSQL());
    }

    public int getAggregateType() {
        return this.type;
    }

    private Index getColumnIndex(boolean bl) {
        if (this.on instanceof ExpressionColumn) {
            ExpressionColumn expressionColumn = (ExpressionColumn)this.on;
            Column column = expressionColumn.getColumn();
            TableFilter tableFilter = expressionColumn.getTableFilter();
            if (tableFilter != null) {
                Table table = tableFilter.getTable();
                Index index = table.getIndexForColumn(column, bl);
                return index;
            }
        }
        return null;
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (expressionVisitor.type == 1) {
            switch (this.type) {
                case 0: {
                    return expressionVisitor.table.canGetRowCount();
                }
                case 3: 
                case 4: {
                    if (!SysProperties.OPTIMIZE_MIN_MAX) {
                        return false;
                    }
                    boolean bl = this.type == 3;
                    Index index = this.getColumnIndex(bl);
                    return index != null;
                }
            }
            return false;
        }
        if (this.on != null && !this.on.isEverything(expressionVisitor)) {
            return false;
        }
        if (this.separator != null && !this.separator.isEverything(expressionVisitor)) {
            return false;
        }
        for (int i = 0; this.orderList != null && i < this.orderList.size(); ++i) {
            SelectOrderBy selectOrderBy = (SelectOrderBy)this.orderList.get(i);
            if (selectOrderBy.expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    public int getCost() {
        return this.on == null ? 1 : this.on.getCost() + 1;
    }

    static {
        Aggregate.addAggregate("COUNT", 1);
        Aggregate.addAggregate("SUM", 2);
        Aggregate.addAggregate("MIN", 3);
        Aggregate.addAggregate("MAX", 4);
        Aggregate.addAggregate("AVG", 5);
        Aggregate.addAggregate("GROUP_CONCAT", 6);
        Aggregate.addAggregate("STDDEV_SAMP", 8);
        Aggregate.addAggregate("STDDEV", 8);
        Aggregate.addAggregate("STDDEV_POP", 7);
        Aggregate.addAggregate("STDDEVP", 7);
        Aggregate.addAggregate("VAR_POP", 9);
        Aggregate.addAggregate("VARP", 9);
        Aggregate.addAggregate("VAR_SAMP", 10);
        Aggregate.addAggregate("VAR", 10);
        Aggregate.addAggregate("VARIANCE", 10);
        Aggregate.addAggregate("SOME", 11);
        Aggregate.addAggregate("EVERY", 12);
        Aggregate.addAggregate("SELECTIVITY", 13);
    }
}

