/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.sql.SQLException;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;
import org.h2.value.DataType;
import org.h2.value.Value;

public class TriggerObject
extends SchemaObjectBase {
    public static final int DEFAULT_QUEUE_SIZE = 1024;
    private boolean before;
    private int typeMask;
    private boolean rowBased;
    private int queueSize = 1024;
    private boolean noWait;
    private Table table;
    private String triggerClassName;
    private Trigger triggerCallback;

    public TriggerObject(Schema schema, int n, String string, Table table) {
        this.initSchemaObjectBase(schema, n, string, "trigger");
        this.table = table;
        this.setTemporary(table.getTemporary());
    }

    public void setBefore(boolean bl) {
        this.before = bl;
    }

    private synchronized void load(Session session) throws SQLException {
        if (this.triggerCallback != null) {
            return;
        }
        try {
            JdbcConnection jdbcConnection = session.createConnection(false);
            Object t = session.getDatabase().loadUserClass(this.triggerClassName).newInstance();
            this.triggerCallback = (Trigger)t;
            this.triggerCallback.init(jdbcConnection, this.getSchema().getName(), this.getName(), this.table.getName(), this.before, this.typeMask);
        }
        catch (Throwable throwable) {
            throw Message.getSQLException(90043, new String[]{this.getName(), this.triggerClassName, throwable.toString()}, throwable);
        }
    }

    public void setTriggerClassName(Session session, String string, boolean bl) throws SQLException {
        block2: {
            this.triggerClassName = string;
            try {
                this.load(session);
            }
            catch (SQLException sQLException) {
                if (bl) break block2;
                throw sQLException;
            }
        }
    }

    public void fire(Session session, boolean bl) throws SQLException {
        if (this.rowBased || this.before != bl) {
            return;
        }
        this.load(session);
        JdbcConnection jdbcConnection = session.createConnection(false);
        boolean bl2 = session.setCommitOrRollbackDisabled(true);
        try {
            this.triggerCallback.fire(jdbcConnection, null, null);
        }
        catch (Throwable throwable) {
            throw Message.getSQLException(90044, new String[]{this.getName(), this.triggerClassName, throwable.toString()}, throwable);
        }
        finally {
            session.setCommitOrRollbackDisabled(bl2);
        }
    }

    private Object[] convertToObjectList(Row row) throws SQLException {
        if (row == null) {
            return null;
        }
        int n = row.getColumnCount();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = row.getValue(i).getObject();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRow(Session session, Row row, Row row2, boolean bl) throws SQLException {
        Object[] objectArray;
        if (!this.rowBased || this.before != bl) {
            return;
        }
        this.load(session);
        boolean bl2 = false;
        if ((this.typeMask & 1) != 0 && row == null && row2 != null) {
            bl2 = true;
        }
        if ((this.typeMask & 2) != 0 && row != null && row2 != null) {
            bl2 = true;
        }
        if ((this.typeMask & 4) != 0 && row != null && row2 == null) {
            bl2 = true;
        }
        if (!bl2) {
            return;
        }
        Object[] objectArray2 = this.convertToObjectList(row);
        Object[] objectArray3 = this.convertToObjectList(row2);
        if (this.before && objectArray3 != null) {
            objectArray = new Object[objectArray3.length];
            for (int i = 0; i < objectArray3.length; ++i) {
                objectArray[i] = objectArray3[i];
            }
        } else {
            objectArray = null;
        }
        JdbcConnection jdbcConnection = session.createConnection(false);
        boolean bl3 = session.getAutoCommit();
        boolean bl4 = session.setCommitOrRollbackDisabled(true);
        try {
            session.setAutoCommit(false);
            this.triggerCallback.fire(jdbcConnection, objectArray2, objectArray3);
            if (objectArray != null) {
                for (int i = 0; i < objectArray3.length; ++i) {
                    Object object = objectArray3[i];
                    if (object == objectArray[i]) continue;
                    Value value = DataType.convertToValue(session, object, -1);
                    row2.setValue(i, value);
                }
            }
        }
        finally {
            session.setCommitOrRollbackDisabled(bl4);
            session.setAutoCommit(bl3);
        }
    }

    public void setTypeMask(int n) {
        this.typeMask = n;
    }

    public void setRowBased(boolean bl) {
        this.rowBased = bl;
    }

    public void setQueueSize(int n) {
        this.queueSize = n;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setNoWait(boolean bl) {
        this.noWait = bl;
    }

    public boolean getNoWait() {
        return this.noWait;
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQLForCopy(Table table, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE FORCE TRIGGER ");
        stringBuffer.append(string);
        if (this.before) {
            stringBuffer.append(" BEFORE ");
        } else {
            stringBuffer.append(" AFTER ");
        }
        stringBuffer.append(this.getTypeNameList());
        stringBuffer.append(" ON ");
        stringBuffer.append(table.getSQL());
        if (this.rowBased) {
            stringBuffer.append(" FOR EACH ROW");
        }
        if (this.noWait) {
            stringBuffer.append(" NOWAIT");
        } else {
            stringBuffer.append(" QUEUE ");
            stringBuffer.append(this.queueSize);
        }
        stringBuffer.append(" CALL ");
        stringBuffer.append(Parser.quoteIdentifier(this.triggerClassName));
        return stringBuffer.toString();
    }

    public String getTypeNameList() {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.typeMask & 1) != 0) {
            stringBuffer.append("INSERT");
        }
        if ((this.typeMask & 2) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("UPDATE");
        }
        if ((this.typeMask & 4) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("DELETE");
        }
        return stringBuffer.toString();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public int getType() {
        return 4;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeTrigger(session, this);
        this.database.removeMeta(session, this.getId());
        this.table = null;
        this.triggerClassName = null;
        this.triggerCallback = null;
        this.invalidate();
    }

    public void checkRename() {
    }

    public Table getTable() {
        return this.table;
    }

    public boolean getBefore() {
        return this.before;
    }

    public String getTriggerClassName() {
        return this.triggerClassName;
    }
}

