/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.ddf.EscherBlipRecord;

public class HSSFPictureData {
    public static final short MSOBI_WMF = 8544;
    public static final short MSOBI_EMF = 15680;
    public static final short MSOBI_PICT = 21536;
    public static final short MSOBI_PNG = 28160;
    public static final short MSOBI_JPEG = 18080;
    public static final short MSOBI_DIB = 31360;
    public static final short FORMAT_MASK = -16;
    private EscherBlipRecord blip;

    HSSFPictureData(EscherBlipRecord blip) {
        this.blip = blip;
    }

    public byte[] getData() {
        return this.blip.getPicturedata();
    }

    public String suggestFileExtension() {
        switch (this.blip.getOptions() & 0xFFFFFFF0) {
            case 8544: {
                return "wmf";
            }
            case 15680: {
                return "emf";
            }
            case 21536: {
                return "pict";
            }
            case 28160: {
                return "png";
            }
            case 18080: {
                return "jpeg";
            }
            case 31360: {
                return "dib";
            }
        }
        return "";
    }
}

