/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.util.StringUtils;

public class Comment
extends DbObjectBase {
    private final int objectType;
    private final String objectName;
    private String commentText;

    public Comment(Database database, int n, DbObject dbObject) {
        this.initDbObjectBase(database, n, Comment.getKey(dbObject), "database");
        this.objectType = dbObject.getType();
        this.objectName = dbObject.getSQL();
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw Message.getInternalError();
    }

    private static String getTypeName(int n) {
        switch (n) {
            case 11: {
                return "CONSTANT";
            }
            case 5: {
                return "CONSTRAINT";
            }
            case 9: {
                return "ALIAS";
            }
            case 1: {
                return "INDEX";
            }
            case 7: {
                return "ROLE";
            }
            case 10: {
                return "SCHEMA";
            }
            case 3: {
                return "SEQUENCE";
            }
            case 0: {
                return "TABLE";
            }
            case 4: {
                return "TRIGGER";
            }
            case 2: {
                return "USER";
            }
            case 12: {
                return "DOMAIN";
            }
        }
        return "type" + n;
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("COMMENT ON ");
        stringBuffer.append(Comment.getTypeName(this.objectType));
        stringBuffer.append(' ');
        stringBuffer.append(this.objectName);
        stringBuffer.append(" IS ");
        if (this.commentText == null) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(StringUtils.quoteStringSQL(this.commentText));
        }
        return stringBuffer.toString();
    }

    public int getType() {
        return 13;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.database.removeMeta(session, this.getId());
    }

    public void checkRename() throws SQLException {
        throw Message.getInternalError();
    }

    public static String getKey(DbObject dbObject) {
        return Comment.getTypeName(dbObject.getType()) + " " + dbObject.getSQL();
    }

    public void setCommentText(String string) {
        this.commentText = string;
    }
}

