/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.message.Message;
import org.h2.message.TraceObject;

public class JdbcParameterMetaData
extends TraceObject
implements ParameterMetaData {
    private JdbcPreparedStatement prep;
    private int paramCount;
    static /* synthetic */ Class class$java$lang$String;

    public int getParameterCount() throws SQLException {
        try {
            this.debugCodeCall("getParameterCount");
            this.checkClosed();
            return this.paramCount;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getParameterMode(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterMode", n);
            this.checkParameterIndex(n);
            return 1;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getParameterType(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterType", n);
            this.checkParameterIndex(n);
            return 12;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getPrecision(int n) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", n);
            this.checkParameterIndex(n);
            return 0;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getScale(int n) throws SQLException {
        try {
            this.debugCodeCall("getScale", n);
            this.checkParameterIndex(n);
            return 0;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int isNullable(int n) throws SQLException {
        try {
            this.debugCodeCall("isNullable", n);
            this.checkParameterIndex(n);
            return 2;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean isSigned(int n) throws SQLException {
        try {
            this.debugCodeCall("isSigned", n);
            this.checkParameterIndex(n);
            return true;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public String getParameterClassName(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterClassName", n);
            this.checkParameterIndex(n);
            return (class$java$lang$String == null ? (class$java$lang$String = JdbcParameterMetaData.class$("java.lang.String")) : class$java$lang$String).getName();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public String getParameterTypeName(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterTypeName", n);
            this.checkParameterIndex(n);
            return "VARCHAR";
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    JdbcParameterMetaData(SessionInterface sessionInterface, JdbcPreparedStatement jdbcPreparedStatement, CommandInterface commandInterface, int n) {
        this.setTrace(sessionInterface.getTrace(), 11, n);
        this.prep = jdbcPreparedStatement;
        this.paramCount = commandInterface.getParameters().size();
    }

    void checkParameterIndex(int n) throws SQLException {
        this.checkClosed();
        if (n < 1 || n > this.paramCount) {
            throw Message.getInvalidValueException("" + n, "param");
        }
    }

    void checkClosed() throws SQLException {
        this.prep.checkClosed();
    }

    public String toString() {
        return this.getTraceObjectName() + ": parameterCount=" + this.paramCount;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

