/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.h2.Driver;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.TcpServerThread;
import org.h2.tools.Server;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;

public class TcpServer
implements Service {
    public static final int DEFAULT_PORT = 9092;
    private static final int SHUTDOWN_NORMAL = 0;
    private static final int SHUTDOWN_FORCE = 1;
    private int port;
    private boolean trace;
    private boolean ssl;
    private boolean stop;
    private ServerSocket serverSocket;
    private Set running = Collections.synchronizedSet(new HashSet());
    private String baseDir;
    private String url;
    private boolean allowOthers;
    private boolean ifExists;
    private Connection managementDb;
    private PreparedStatement managementDbAdd;
    private PreparedStatement managementDbRemove;
    private String managementPassword = "";
    private static final Map SERVERS = Collections.synchronizedMap(new HashMap());
    private Thread listenerThread;
    private int nextThreadId;
    static /* synthetic */ Class class$org$h2$server$TcpServer;

    public static String getManagementDbName(int n) {
        return "mem:management_db_" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initManagementDb() throws SQLException {
        Connection connection;
        Properties properties = new Properties();
        properties.setProperty("user", "sa");
        properties.setProperty("password", this.managementPassword);
        this.managementDb = connection = Driver.load().connect("jdbc:h2:" + TcpServer.getManagementDbName(this.port), properties);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute("CREATE ALIAS IF NOT EXISTS STOP_SERVER FOR \"" + (class$org$h2$server$TcpServer == null ? (class$org$h2$server$TcpServer = TcpServer.class$("org.h2.server.TcpServer")) : class$org$h2$server$TcpServer).getName() + ".stopServer\"");
            statement.execute("CREATE TABLE IF NOT EXISTS SESSIONS(ID INT PRIMARY KEY, URL VARCHAR, USER VARCHAR, CONNECTED TIMESTAMP)");
            this.managementDbAdd = connection.prepareStatement("INSERT INTO SESSIONS VALUES(?, ?, ?, NOW())");
            this.managementDbRemove = connection.prepareStatement("DELETE FROM SESSIONS WHERE ID=?");
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
        SERVERS.put("" + this.port, this);
    }

    public static int[] getAllServerPorts() {
        Object[] objectArray = SERVERS.keySet().toArray();
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = Integer.parseInt(objectArray[i].toString());
        }
        return nArray;
    }

    synchronized void addConnection(int n, String string, String string2) {
        try {
            this.managementDbAdd.setInt(1, n);
            this.managementDbAdd.setString(2, string);
            this.managementDbAdd.setString(3, string2);
            this.managementDbAdd.execute();
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
    }

    synchronized void removeConnection(int n) {
        try {
            this.managementDbRemove.setInt(1, n);
            this.managementDbRemove.execute();
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
    }

    private synchronized void stopManagementDb() {
        if (this.managementDb != null) {
            try {
                this.managementDb.close();
            }
            catch (SQLException sQLException) {
                TraceSystem.traceThrowable(sQLException);
            }
            this.managementDb = null;
        }
    }

    public void init(String[] stringArray) throws Exception {
        this.port = 9092;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("-trace".equals(string)) {
                this.trace = true;
                continue;
            }
            if ("-log".equals(string) && SysProperties.OLD_COMMAND_LINE_OPTIONS) {
                this.trace = Server.readArgBoolean(stringArray, i) == 1;
                ++i;
                continue;
            }
            if ("-tcpSSL".equals(string)) {
                if (Server.readArgBoolean(stringArray, i) != 0) {
                    this.ssl = Server.readArgBoolean(stringArray, i) == 1;
                    ++i;
                    continue;
                }
                this.ssl = true;
                continue;
            }
            if ("-tcpPort".equals(string)) {
                this.port = MathUtils.decodeInt(stringArray[++i]);
                continue;
            }
            if ("-tcpPassword".equals(string)) {
                this.managementPassword = stringArray[++i];
                continue;
            }
            if ("-baseDir".equals(string)) {
                this.baseDir = stringArray[++i];
                continue;
            }
            if ("-tcpAllowOthers".equals(string)) {
                if (Server.readArgBoolean(stringArray, i) != 0) {
                    this.allowOthers = Server.readArgBoolean(stringArray, i) == 1;
                    ++i;
                    continue;
                }
                this.allowOthers = true;
                continue;
            }
            if (!"-ifExists".equals(string)) continue;
            if (Server.readArgBoolean(stringArray, i) != 0) {
                this.ifExists = Server.readArgBoolean(stringArray, i) == 1;
                ++i;
                continue;
            }
            this.ifExists = true;
        }
        Driver.load();
        this.url = (this.ssl ? "ssl" : "tcp") + "://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    public String getURL() {
        return this.url;
    }

    boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        return NetUtils.isLoopbackAddress(socket);
    }

    public synchronized void start() throws SQLException {
        this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
        this.initManagementDb();
    }

    public void listen() {
        block3: {
            this.listenerThread = Thread.currentThread();
            String string = this.listenerThread.getName();
            try {
                while (!this.stop) {
                    Socket socket = this.serverSocket.accept();
                    TcpServerThread tcpServerThread = new TcpServerThread(socket, this, this.nextThreadId++);
                    this.running.add(tcpServerThread);
                    Thread thread = new Thread(tcpServerThread);
                    thread.setName(string + " thread");
                    tcpServerThread.setThread(thread);
                    thread.start();
                }
                this.serverSocket = NetUtils.closeSilently(this.serverSocket);
            }
            catch (Exception exception) {
                if (this.stop) break block3;
                TraceSystem.traceThrowable(exception);
            }
        }
        this.stopManagementDb();
    }

    public synchronized boolean isRunning(boolean bl) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.port, this.ssl);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.traceError(exception);
            }
            return false;
        }
    }

    public void stop() {
        SERVERS.remove("" + this.port);
        if (!this.stop) {
            this.stopManagementDb();
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    TraceSystem.traceThrowable(iOException);
                }
                this.serverSocket = null;
            }
            if (this.listenerThread != null) {
                try {
                    this.listenerThread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    TraceSystem.traceThrowable(interruptedException);
                }
            }
        }
        ArrayList arrayList = new ArrayList(this.running);
        for (int i = 0; i < arrayList.size(); ++i) {
            TcpServerThread tcpServerThread = (TcpServerThread)arrayList.get(i);
            if (tcpServerThread == null) continue;
            tcpServerThread.close();
            try {
                tcpServerThread.getThread().join(100L);
                continue;
            }
            catch (Exception exception) {
                TraceSystem.traceThrowable(exception);
            }
        }
    }

    public static void stopServer(int n, String string, int n2) {
        TcpServer tcpServer = (TcpServer)SERVERS.get("" + n);
        if (tcpServer == null) {
            return;
        }
        if (!tcpServer.managementPassword.equals(string)) {
            return;
        }
        if (n2 == 0) {
            tcpServer.stopManagementDb();
            tcpServer.stop = true;
            try {
                Socket socket = NetUtils.createLoopbackSocket(n, false);
                socket.close();
            }
            catch (Exception exception) {}
        } else if (n2 == 1) {
            tcpServer.stop();
        }
    }

    void remove(TcpServerThread tcpServerThread) {
        this.running.remove(tcpServerThread);
    }

    String getBaseDir() {
        return this.baseDir;
    }

    void trace(String string) {
        if (this.trace) {
            System.out.println(string);
        }
    }

    void traceError(Throwable throwable) {
        if (this.trace) {
            throwable.printStackTrace();
        }
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    public String getType() {
        return "TCP";
    }

    public String getName() {
        return "H2 TCP Server";
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown(String string, String string2, boolean bl) throws SQLException {
        String string3;
        int n = 9092;
        int n2 = string.indexOf(58, "jdbc:h2:".length());
        if (n2 >= 0) {
            string3 = string.substring(n2 + 1);
            if ((n2 = string3.indexOf(47)) >= 0) {
                string3 = string3.substring(0, n2);
            }
            n = MathUtils.decodeInt(string3);
        }
        string3 = TcpServer.getManagementDbName(n);
        try {
            Driver.load();
        }
        catch (Throwable throwable) {
            throw Message.convert(throwable);
        }
        for (int i = 0; i < 2; ++i) {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            try {
                block12: {
                    connection = DriverManager.getConnection("jdbc:h2:" + string + "/" + string3, "sa", string2);
                    preparedStatement = connection.prepareStatement("CALL STOP_SERVER(?, ?, ?)");
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, string2);
                    preparedStatement.setInt(3, bl ? 1 : 0);
                    try {
                        preparedStatement.execute();
                    }
                    catch (SQLException sQLException) {
                        if (bl) break block12;
                        throw sQLException;
                    }
                }
                JdbcUtils.closeSilently(preparedStatement);
            }
            catch (SQLException sQLException) {
                if (i != 1) continue;
                throw sQLException;
            }
            finally {
                JdbcUtils.closeSilently(preparedStatement);
                JdbcUtils.closeSilently(connection);
            }
            JdbcUtils.closeSilently(connection);
            break;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

