/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

public class BitField {
    private long[] data = new long[10];
    private static final int ADDRESS_BITS = 6;
    private static final int BITS = 64;
    private static final int ADDRESS_MASK = 63;

    public int getLastSetBit() {
        for (int i = (this.data.length << 6) - 1; i >= 0; --i) {
            if (!this.get(i)) continue;
            return i;
        }
        return -1;
    }

    public int nextSetBit(int n) {
        int n2 = this.data.length;
        int n3 = this.data.length << 6;
        for (int i = n >> 6; i < n2; ++i) {
            if (this.data[i] == 0L) continue;
            for (int j = Math.max(n, i << 6); j < n3; ++j) {
                if (!this.get(j)) continue;
                return j;
            }
        }
        return -1;
    }

    public int nextClearBit(int n) {
        int n2 = this.data.length;
        for (int i = n >> 6; i < n2; ++i) {
            if (this.data[i] == -1L) continue;
            int n3 = Math.max(n, i << 6);
            while (this.get(n3)) {
                ++n3;
            }
            return n3;
        }
        return n;
    }

    public long getLong(int n) {
        int n2 = this.getAddress(n);
        if (n2 >= this.data.length) {
            return 0L;
        }
        return this.data[n2];
    }

    public boolean get(int n) {
        int n2 = this.getAddress(n);
        if (n2 >= this.data.length) {
            return false;
        }
        return (this.data[n2] & this.getBitMask(n)) != 0L;
    }

    public void set(int n) {
        int n2 = this.getAddress(n);
        this.checkCapacity(n2);
        int n3 = n2;
        this.data[n3] = this.data[n3] | this.getBitMask(n);
    }

    public void clear(int n) {
        int n2 = this.getAddress(n);
        if (n2 >= this.data.length) {
            return;
        }
        int n3 = n2;
        this.data[n3] = this.data[n3] & (this.getBitMask(n) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private int getAddress(int n) {
        return n >> 6;
    }

    private long getBitMask(int n) {
        return 1L << (n & 0x3F);
    }

    private void checkCapacity(int n) {
        while (n >= this.data.length) {
            int n2 = this.data.length == 0 ? 1 : this.data.length * 2;
            long[] lArray = new long[n2];
            System.arraycopy(this.data, 0, lArray, 0, this.data.length);
            this.data = lArray;
        }
    }

    public void setRange(int n, int n2, boolean bl) {
        int n3 = n + n2;
        while (n < n3) {
            this.set(n, bl);
            ++n;
        }
    }

    private void set(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }
}

