/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.mux;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Address;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class ServiceInfo
implements Externalizable,
Streamable {
    public static final byte STATE_REQ = 1;
    public static final byte STATE_RSP = 2;
    public static final byte SERVICE_UP = 3;
    public static final byte SERVICE_DOWN = 4;
    public static final byte LIST_SERVICES_RSP = 5;
    byte type = 0;
    String service = null;
    Address host = null;
    byte[] state = null;

    public ServiceInfo() {
    }

    public ServiceInfo(byte type, String service, Address host, byte[] state) {
        this.type = type;
        this.service = service;
        this.host = host;
        this.state = state;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type);
        out.writeUTF(this.service);
        out.writeObject(this.host);
        if (this.state != null) {
            out.writeInt(this.state.length);
            out.write(this.state);
        } else {
            out.writeInt(0);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        this.service = in.readUTF();
        this.host = (Address)in.readObject();
        int len = in.readInt();
        if (len > 0) {
            this.state = new byte[len];
            in.readFully(this.state, 0, len);
        }
    }

    public long size() {
        long retval = 1L;
        ++retval;
        if (this.service != null) {
            retval += (long)(this.service.length() + 2);
        }
        retval += (long)Util.size(this.host);
        retval += 4L;
        if (this.state != null) {
            retval += (long)this.state.length;
        }
        return retval;
    }

    public void writeTo(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        Util.writeString(this.service, out);
        Util.writeAddress(this.host, out);
        if (this.state != null) {
            out.writeInt(this.state.length);
            out.write(this.state, 0, this.state.length);
        } else {
            out.writeInt(0);
        }
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        this.type = in.readByte();
        this.service = Util.readString(in);
        this.host = Util.readAddress(in);
        int len = in.readInt();
        if (len > 0) {
            this.state = new byte[len];
            in.readFully(this.state, 0, len);
        }
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "STATE_REQ";
            }
            case 2: {
                String tmp = "STATE_RSP (";
                tmp = this.state == null ? tmp + this.state : tmp + this.state.length;
                tmp = tmp + ")";
                return tmp;
            }
            case 3: {
                return "SERVICE_UP(" + this.service + "," + this.host + ")";
            }
            case 4: {
                return "SERVICE_DOWN(" + this.service + "," + this.host + ")";
            }
            case 5: {
                String services = null;
                try {
                    services = Util.objectFromByteBuffer(this.state).toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "LIST_SERVICES_RSP(" + services + ")";
            }
        }
        return "n/a";
    }

    public static String typeToString(int t) {
        switch (t) {
            case 1: {
                return "STATE_REQ";
            }
            case 2: {
                return "STATE_RSP";
            }
            case 3: {
                return "SERVICE_UP";
            }
            case 4: {
                return "SERVICE_DOWN";
            }
            case 5: {
                return "LIST_SERVICES_RSP";
            }
        }
        return "n/a";
    }
}

