/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.JChannelFactory;
import org.jgroups.Message;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class StreamingStateTransferTest
extends ChannelTestBase {
    public void setUp() throws Exception {
        super.setUp();
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    public boolean useBlocking() {
        return true;
    }

    public void testTransfer() {
        String[] channelNames = null;
        channelNames = StreamingStateTransferTest.isMuxChannelUsed() ? this.createMuxApplicationNames(1) : new String[]{"A", "B", "C", "D"};
        this.transferHelper(channelNames, false);
    }

    public void testRpcChannelTransfer() {
        if (!StreamingStateTransferTest.isMuxChannelUsed()) {
            String[] channelNames = new String[]{"A", "B", "C", "D"};
            this.transferHelper(channelNames, true);
        }
    }

    public void testMultipleServiceMuxChannel() {
        String[] channelNames = null;
        if (StreamingStateTransferTest.isMuxChannelUsed()) {
            channelNames = this.createMuxApplicationNames(2);
            this.transferHelper(channelNames, false);
        }
    }

    public void transferHelper(String[] channelNames, boolean useDispatcher) {
        this.transferHelper(channelNames, false, false, useDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferHelper(String[] channelNames, boolean crash, boolean largeTransfer, boolean useDispatcher) {
        int channelCount = channelNames.length;
        ArrayList<StreamingStateTransferApplication> channels = new ArrayList<StreamingStateTransferApplication>(channelCount);
        Semaphore semaphore = new Semaphore(channelCount);
        try {
            StreamingStateTransferTest.takeAllPermits(semaphore, channelCount);
            boolean crashed = false;
            for (int i = 0; i < channelCount; ++i) {
                StreamingStateTransferApplication channel = null;
                channel = StreamingStateTransferTest.isMuxChannelUsed() ? new StreamingStateTransferApplication(channelNames[i], this.muxFactory[i % this.getMuxFactoryCount()], semaphore, largeTransfer) : new StreamingStateTransferApplication(channelNames[i], semaphore, useDispatcher, largeTransfer);
                channels.add(channel);
                semaphore.release(1);
                channel.start();
                Util.sleep(2000L);
                if (!crash || crashed || i <= 2) continue;
                StreamingStateTransferApplication coord = (StreamingStateTransferApplication)channels.remove(0);
                coord.cleanup();
                crashed = true;
            }
            if (StreamingStateTransferTest.isMuxChannelUsed()) {
                StreamingStateTransferTest.blockUntilViewsReceived(channels, this.getMuxFactoryCount(), 60000L);
            } else {
                StreamingStateTransferTest.blockUntilViewsReceived(channels, 60000L);
            }
            StreamingStateTransferTest.acquireSemaphore(semaphore, 60000L, channelCount);
            int getStateInvokedCount = 0;
            int setStateInvokedCount = 0;
            int partialGetStateInvokedCount = 0;
            int partialSetStateInvokedCount = 0;
            Util.sleep(3000L);
            for (int i = 0; i < channels.size(); ++i) {
                StreamingStateTransferApplication current = (StreamingStateTransferApplication)channels.get(i);
                if (current.getStateInvoked) {
                    ++getStateInvokedCount;
                }
                if (current.setStateInvoked) {
                    ++setStateInvokedCount;
                }
                if (current.partialGetStateInvoked) {
                    ++partialGetStateInvokedCount;
                }
                if (current.partialSetStateInvoked) {
                    ++partialSetStateInvokedCount;
                }
                Map map = current.getMap();
                for (int j = 0; j < channels.size(); ++j) {
                    StreamingStateTransferApplication app = (StreamingStateTransferApplication)channels.get(j);
                    List l = (List)map.get(app.getLocalAddress());
                    int size = l != null ? l.size() : 0;
                    StreamingStateTransferTest.assertEquals((String)"Correct element count in map ", (int)25, (int)size);
                }
            }
            if (StreamingStateTransferTest.isMuxChannelUsed()) {
                int factor = channelCount / this.getMuxFactoryCount();
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of getState ", (int)(1 * factor), (int)getStateInvokedCount);
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of setState ", (int)(channelCount / factor - 1), (int)(setStateInvokedCount / factor));
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of partial getState ", (int)(1 * factor), (int)partialGetStateInvokedCount);
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of partial setState ", (int)(channelCount / factor - 1), (int)(partialSetStateInvokedCount / factor));
            } else {
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of getState ", (int)1, (int)getStateInvokedCount);
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of setState ", (int)(channelCount - 1), (int)setStateInvokedCount);
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of partial getState ", (int)1, (int)partialGetStateInvokedCount);
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of partial setState ", (int)(channelCount - 1), (int)partialSetStateInvokedCount);
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)ex);
        }
        finally {
            for (int i = 0; i < channels.size(); ++i) {
                StreamingStateTransferApplication app = (StreamingStateTransferApplication)channels.get(i);
                Util.sleep(500L);
                app.cleanup();
            }
        }
    }

    public static Test suite() {
        return new TestSuite(StreamingStateTransferTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{StreamingStateTransferTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    protected class StreamingStateTransferApplication
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        private final Map stateMap;
        public static final int COUNT = 25;
        boolean partialSetStateInvoked;
        boolean partialGetStateInvoked;
        boolean setStateInvoked;
        boolean getStateInvoked;
        boolean largeTransfer;

        public StreamingStateTransferApplication(String name, Semaphore s, boolean useDispatcher, boolean largeTransfer) throws Exception {
            super(name, new StreamingChannelTestFactory(), s, useDispatcher);
            this.stateMap = new HashMap();
            this.partialSetStateInvoked = false;
            this.partialGetStateInvoked = false;
            this.setStateInvoked = false;
            this.getStateInvoked = false;
            this.largeTransfer = false;
            this.largeTransfer = largeTransfer;
            this.channel.connect("test");
        }

        public StreamingStateTransferApplication(String name, JChannelFactory factory, Semaphore s, boolean largeTransfer) throws Exception {
            super(name, factory, s);
            this.stateMap = new HashMap();
            this.partialSetStateInvoked = false;
            this.partialGetStateInvoked = false;
            this.setStateInvoked = false;
            this.getStateInvoked = false;
            this.largeTransfer = false;
            this.largeTransfer = largeTransfer;
            this.channel.connect("test");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Message msg) {
            Address sender = msg.getSrc();
            Map map = this.stateMap;
            synchronized (map) {
                ArrayList<Object> list = (ArrayList<Object>)this.stateMap.get(sender);
                if (list == null) {
                    list = new ArrayList<Object>();
                    this.stateMap.put(sender, list);
                }
                list.add(msg.getObject());
            }
        }

        public Map getMap() {
            return this.stateMap;
        }

        public void useChannel() throws Exception {
            for (int i = 0; i < 25; ++i) {
                this.channel.send(null, null, new Integer(i));
            }
            this.channel.getState(null, 25000L);
            this.channel.getState(null, this.name, 25000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(OutputStream ostream) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            super.getState(ostream);
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(ostream);
                HashMap copy = null;
                Map map = this.stateMap;
                synchronized (map) {
                    copy = new HashMap(this.stateMap);
                }
                oos.writeObject(copy);
                oos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.getStateInvoked = true;
                Util.close(oos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState() {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            byte[] result = null;
            try {
                Map map = this.stateMap;
                synchronized (map) {
                    result = Util.objectToByteBuffer(this.stateMap);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.getStateInvoked = true;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] state) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            Map result = null;
            try {
                result = (Map)Util.objectFromByteBuffer(state);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.setStateInvoked = true;
            }
            Map map = this.stateMap;
            synchronized (map) {
                this.stateMap.clear();
                this.stateMap.putAll(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(InputStream istream) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            super.setState(istream);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(istream);
                Map map = (Map)ois.readObject();
                Map map2 = this.stateMap;
                synchronized (map2) {
                    this.stateMap.clear();
                    this.stateMap.putAll(map);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.setStateInvoked = true;
                Util.close(ois);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(String stateId, byte[] state) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            Object nameTransfer = null;
            try {
                nameTransfer = Util.objectFromByteBuffer(state);
                TestCase.assertEquals((String)"Got partial state requested ", (Object)nameTransfer, (Object)this.name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.partialSetStateInvoked = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState(String stateId) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            byte[] result = null;
            try {
                result = Util.objectToByteBuffer(stateId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.partialGetStateInvoked = true;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(String state_id, InputStream istream) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            super.setState(state_id, istream);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(istream);
                TestCase.assertEquals((String)"Got partial state requested ", (Object)ois.readObject(), (Object)this.name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.partialSetStateInvoked = true;
                Util.close(ois);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(String state_id, OutputStream ostream) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            super.getState(state_id, ostream);
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(ostream);
                oos.writeObject(state_id);
                oos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.partialGetStateInvoked = true;
                Util.close(oos);
            }
        }
    }

    protected class StreamingChannelTestFactory
    extends ChannelTestBase.DefaultChannelTestFactory {
        protected StreamingChannelTestFactory() {
        }

        public JChannel createChannel(Object id) throws Exception {
            return this.createChannel(ChannelTestBase.CHANNEL_CONFIG, true);
        }
    }
}

