/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.janino.Location;
import org.codehaus.janino.UnicodeUnescapeException;
import org.codehaus.janino.UnicodeUnescapeReader;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.LocatedException;
import org.codehaus.janino.util.TeeReader;

public class Scanner {
    public static final Integer MAGIC_INTEGER = new Integer(Integer.MIN_VALUE);
    public static final Long MAGIC_LONG = new Long(Long.MIN_VALUE);
    private static final boolean DEBUG = false;
    private String optionalFileName;
    private Reader in;
    private int nextChar = -1;
    private boolean crLfPending = false;
    private short nextCharLineNumber;
    private short nextCharColumnNumber;
    private Token nextToken;
    private Token nextButOneToken;
    private short tokenLineNumber;
    private short tokenColumnNumber;
    private String docComment = null;
    private static final Map JAVA_KEYWORDS = new HashMap();
    private static final Map JAVA_OPERATORS;
    private WarningHandler optionalWarningHandler = null;

    static {
        String[] stringArray = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
        int n = 0;
        while (n < stringArray.length) {
            JAVA_KEYWORDS.put(stringArray[n], stringArray[n]);
            ++n;
        }
        JAVA_OPERATORS = new HashMap();
        stringArray = new String[]{"(", ")", "{", "}", "[", "]", ";", ",", ".", "=", ">", "<", "!", "~", "?", ":", "==", "<=", ">=", "!=", "&&", "||", "++", "--", "+", "-", "*", "/", "&", "|", "^", "%", "<<", ">>", ">>>", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>="};
        n = 0;
        while (n < stringArray.length) {
            JAVA_OPERATORS.put(stringArray[n], stringArray[n]);
            ++n;
        }
    }

    public Scanner(File file) throws ScanException, IOException {
        this(file.getAbsolutePath(), new FileInputStream(file), null);
    }

    public Scanner(File file, String string) throws ScanException, IOException {
        this(file.getAbsolutePath(), new FileInputStream(file), string);
    }

    public Scanner(String string) throws ScanException, IOException {
        this(string, new FileInputStream(string));
    }

    public Scanner(String string, InputStream inputStream) throws ScanException, IOException {
        this(string, new InputStreamReader(inputStream), 1, 0);
    }

    public Scanner(String string, InputStream inputStream, String string2) throws ScanException, IOException {
        this(string, string2 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string2), 1, 0);
    }

    public Scanner(String string, Reader reader) throws ScanException, IOException {
        this(string, reader, 1, 0);
    }

    public Scanner(String string, Reader reader, short s, short s2) throws ScanException, IOException {
        if (string == null && Boolean.getBoolean("org.codehaus.janino.source_debugging.enable")) {
            String string2 = System.getProperty("org.codehaus.janino.source_debugging.dir");
            File file = string2 == null ? null : new File(string2);
            File file2 = File.createTempFile("janino", ".java", file);
            file2.deleteOnExit();
            reader = new TeeReader(reader, new FileWriter(file2), true);
            string = file2.getAbsolutePath();
        }
        this.optionalFileName = string;
        this.in = new UnicodeUnescapeReader(reader);
        this.nextCharLineNumber = s;
        this.nextCharColumnNumber = s2;
        this.readNextChar();
        this.nextToken = this.internalRead();
        this.nextButOneToken = null;
    }

    public Scanner(String string, String string2) throws ScanException, IOException {
        this(string, new FileInputStream(string), string2);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public String doc() {
        String string = this.docComment;
        this.docComment = null;
        return string;
    }

    private static void escapeCharacter(char c, StringBuffer stringBuffer) {
        int n = "\b\t\n\f\r\\".indexOf(c);
        if (n != -1) {
            stringBuffer.append('\\').append("btnfr\\".charAt(n));
        } else if (c >= ' ' && c < '\u00ff' && c != '\u007f') {
            stringBuffer.append(c);
        } else {
            stringBuffer.append("\\u");
            String string = Integer.toHexString(0xFFFF & c);
            int n2 = string.length();
            while (n2 < 4) {
                stringBuffer.append('0');
                ++n2;
            }
            stringBuffer.append(string);
        }
    }

    public String getFileName() {
        return this.optionalFileName;
    }

    /*
     * Unable to fully structure code
     */
    private Token internalRead() throws ScanException, IOException {
        block67: {
            if (this.docComment != null) {
                this.warning("MDC", "Misplaced doc comment", this.nextToken.getLocation());
                this.docComment = null;
            }
            var1_1 = 0;
            var2_2 = null;
            block13: while (true) {
                switch (var1_1) {
                    case 0: {
                        if (this.nextChar == -1) {
                            return new EOFToken();
                        }
                        if (!Character.isWhitespace((char)this.nextChar)) {
                            if (this.nextChar != 47) break block13;
                            var1_1 = 1;
                        }
                        ** GOTO lbl124
                    }
                    case 1: {
                        if (this.nextChar == -1) {
                            return new OperatorToken(null, "/");
                        }
                        if (this.nextChar == 61) {
                            this.readNextChar();
                            return new OperatorToken(null, "/=");
                        }
                        if (this.nextChar != 47) ** GOTO lbl24
                        var1_1 = 2;
                        ** GOTO lbl124
lbl24:
                        // 1 sources

                        if (this.nextChar != 42) ** GOTO lbl27
                        var1_1 = 3;
                        ** GOTO lbl124
lbl27:
                        // 1 sources

                        return new OperatorToken(null, "/");
                    }
                    case 2: {
                        if (this.nextChar == -1) {
                            return new EOFToken();
                        }
                        if (this.nextChar == 13 || this.nextChar == 10) {
                            var1_1 = 0;
                        }
                        ** GOTO lbl124
                    }
                    case 3: {
                        if (this.nextChar == -1) {
                            throw new ScanException("EOF in traditional comment");
                        }
                        var1_1 = this.nextChar == 42 ? 4 : 9;
                        ** GOTO lbl124
                    }
                    case 4: {
                        if (this.nextChar == -1) {
                            throw new ScanException("EOF in doc comment");
                        }
                        if (this.nextChar == 47) {
                            var1_1 = 0;
                        } else {
                            if (this.docComment != null) {
                                this.warning("MDC", "Multiple doc comments", new Location(this.optionalFileName, this.nextCharLineNumber, this.nextCharColumnNumber));
                            }
                            var2_2 = new StringBuffer();
                            var2_2.append((char)this.nextChar);
                            var1_1 = this.nextChar == 13 || this.nextChar == 10 ? 6 : (this.nextChar == 42 ? 8 : 5);
                        }
                        ** GOTO lbl124
                    }
                    case 5: {
                        if (this.nextChar == -1) {
                            throw new ScanException("EOF in doc comment");
                        }
                        if (this.nextChar == 42) {
                            var1_1 = 8;
                        } else if (this.nextChar == 13 || this.nextChar == 10) {
                            var2_2.append((char)this.nextChar);
                            var1_1 = 6;
                        } else {
                            var2_2.append((char)this.nextChar);
                        }
                        ** GOTO lbl124
                    }
                    case 6: {
                        if (this.nextChar == -1) {
                            throw new ScanException("EOF in doc comment");
                        }
                        if (this.nextChar == 42) {
                            var1_1 = 7;
                        } else if (this.nextChar == 13 || this.nextChar == 10) {
                            var2_2.append((char)this.nextChar);
                        } else if (this.nextChar != 32 && this.nextChar != 9) {
                            var2_2.append((char)this.nextChar);
                            var1_1 = 5;
                        }
                        ** GOTO lbl124
                    }
                    case 7: {
                        if (this.nextChar == -1) {
                            throw new ScanException("EOF in doc comment");
                        }
                        if (this.nextChar != 42) {
                            if (this.nextChar == 47) {
                                this.docComment = var2_2.toString();
                                var1_1 = 0;
                            } else {
                                var2_2.append((char)this.nextChar);
                                var1_1 = 5;
                            }
                        }
                        ** GOTO lbl124
                    }
                    case 8: {
                        if (this.nextChar == -1) {
                            throw new ScanException("EOF in doc comment");
                        }
                        if (this.nextChar == 47) {
                            this.docComment = var2_2.toString();
                            var1_1 = 0;
                        } else if (this.nextChar == 42) {
                            var2_2.append('*');
                        } else {
                            var2_2.append('*');
                            var2_2.append((char)this.nextChar);
                            var1_1 = 5;
                        }
                        ** GOTO lbl124
                    }
                    case 9: {
                        if (this.nextChar == -1) {
                            throw new ScanException("EOF in traditional comment");
                        }
                        if (this.nextChar == 42) {
                            var1_1 = 10;
                        }
                        ** GOTO lbl124
                    }
                    case 10: {
                        if (this.nextChar == -1) {
                            throw new ScanException("EOF in traditional comment");
                        }
                        if (this.nextChar != 47) ** GOTO lbl122
                        var1_1 = 0;
                        ** GOTO lbl124
lbl122:
                        // 1 sources

                        if (this.nextChar != 42) {
                            var1_1 = 9;
                        }
                    }
lbl124:
                    // 24 sources

                    default: {
                        this.readNextChar();
                        continue block13;
                    }
                }
                break;
            }
            this.tokenLineNumber = this.nextCharLineNumber;
            this.tokenColumnNumber = this.nextCharColumnNumber;
            if (Character.isJavaIdentifierStart((char)this.nextChar)) {
                var3_3 = new StringBuffer();
                var3_3.append((char)this.nextChar);
                while (true) {
                    this.readNextChar();
                    if (this.nextChar == -1 || !Character.isJavaIdentifierPart((char)this.nextChar)) break;
                    var3_3.append((char)this.nextChar);
                }
                var4_7 = var3_3.toString();
                if (var4_7.equals("true")) {
                    return new LiteralToken(Boolean.TRUE);
                }
                if (var4_7.equals("false")) {
                    return new LiteralToken(Boolean.FALSE);
                }
                if (var4_7.equals("null")) {
                    return new LiteralToken((Object)null);
                }
                var5_9 = (String)Scanner.JAVA_KEYWORDS.get(var4_7);
                if (var5_9 != null) {
                    return new KeywordToken(null, var5_9);
                }
                return new IdentifierToken(null, var4_7);
            }
            if (Character.isDigit((char)this.nextChar)) {
                return this.scanNumericLiteral(0);
            }
            if (this.nextChar == 46) {
                this.readNextChar();
                if (Character.isDigit((char)this.nextChar)) {
                    return this.scanNumericLiteral(2);
                }
                return new OperatorToken(null, ".");
            }
            if (this.nextChar != 34) break block67;
            var3_4 = new StringBuffer("");
            this.readNextChar();
            if (this.nextChar == -1) {
                throw new ScanException("EOF in string literal");
            }
            if (this.nextChar != 13 && this.nextChar != 10) ** GOTO lbl166
            throw new ScanException("Line break in string literal");
lbl-1000:
            // 1 sources

            {
                var3_4.append(this.unescapeCharacterLiteral());
lbl166:
                // 2 sources

                ** while (this.nextChar != 34)
            }
lbl167:
            // 1 sources

            this.readNextChar();
            return new LiteralToken(var3_4.toString());
        }
        if (this.nextChar == 39) {
            this.readNextChar();
            if (this.nextChar == 39) {
                throw new ScanException("Single quote must be backslash-escaped in character literal");
            }
            var3_5 = this.unescapeCharacterLiteral();
            if (this.nextChar != 39) {
                throw new ScanException("Closing single quote missing");
            }
            this.readNextChar();
            return new LiteralToken(new Character(var3_5));
        }
        var3_6 = (String)Scanner.JAVA_OPERATORS.get(new String(new char[]{(char)this.nextChar}));
        if (var3_6 != null) {
            while (true) {
                this.readNextChar();
                var4_8 = (String)Scanner.JAVA_OPERATORS.get(String.valueOf(var3_6) + (char)this.nextChar);
                if (var4_8 == null) {
                    return new OperatorToken(null, var3_6);
                }
                var3_6 = var4_8;
            }
        }
        throw new ScanException("Invalid character input \"" + (char)this.nextChar + "\" (character code " + this.nextChar + ")");
    }

    public static String literalValueToString(Object object) {
        if (object instanceof String) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"');
            String string = (String)object;
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\"') {
                    stringBuffer.append("\\\"");
                } else {
                    Scanner.escapeCharacter(c, stringBuffer);
                }
                ++n;
            }
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            if (c == '\'') {
                return "'\\''";
            }
            StringBuffer stringBuffer = new StringBuffer("'");
            Scanner.escapeCharacter(c, stringBuffer);
            return stringBuffer.append('\'').toString();
        }
        if (object instanceof Integer) {
            if (object == MAGIC_INTEGER) {
                return "2147483648";
            }
            int n = (Integer)object;
            return n < 0 ? "0x" + Integer.toHexString(n) : Integer.toString(n);
        }
        if (object instanceof Long) {
            if (object == MAGIC_LONG) {
                return "9223372036854775808L";
            }
            long l = (Long)object;
            return l < 0L ? "0x" + Long.toHexString(l) + 'L' : String.valueOf(Long.toString(l)) + 'L';
        }
        if (object instanceof Float) {
            return String.valueOf(object.toString()) + 'F';
        }
        if (object instanceof Double) {
            return String.valueOf(object.toString()) + 'D';
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object == null) {
            return "null";
        }
        throw new RuntimeException("Unexpected value type \"" + object.getClass().getName() + "\"");
    }

    public Location location() {
        return this.nextToken.getLocation();
    }

    public Token peek() {
        return this.nextToken;
    }

    public Token peekNextButOne() throws ScanException, IOException {
        if (this.nextButOneToken == null) {
            this.nextButOneToken = this.internalRead();
        }
        return this.nextButOneToken;
    }

    public Token read() throws ScanException, IOException {
        Token token = this.nextToken;
        if (this.nextButOneToken != null) {
            this.nextToken = this.nextButOneToken;
            this.nextButOneToken = null;
        } else {
            this.nextToken = this.internalRead();
        }
        return token;
    }

    private void readNextChar() throws IOException, ScanException {
        try {
            this.nextChar = this.in.read();
        }
        catch (UnicodeUnescapeException unicodeUnescapeException) {
            throw new ScanException(unicodeUnescapeException.getMessage(), (Throwable)unicodeUnescapeException);
        }
        if (this.nextChar == 13) {
            this.nextCharLineNumber = (short)(this.nextCharLineNumber + 1);
            this.nextCharColumnNumber = 0;
            this.crLfPending = true;
        } else if (this.nextChar == 10) {
            if (this.crLfPending) {
                this.crLfPending = false;
            } else {
                this.nextCharLineNumber = (short)(this.nextCharLineNumber + 1);
                this.nextCharColumnNumber = 0;
            }
        } else {
            this.nextCharColumnNumber = (short)(this.nextCharColumnNumber + 1);
        }
    }

    private Token scanNumericLiteral(int n) throws ScanException, IOException {
        StringBuffer stringBuffer = n == 2 ? new StringBuffer("0.") : new StringBuffer();
        int n2 = n;
        while (true) {
            switch (n2) {
                case 0: {
                    if (this.nextChar == 48) {
                        n2 = 6;
                        break;
                    }
                    stringBuffer.append((char)this.nextChar);
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (Character.isDigit((char)this.nextChar)) {
                        stringBuffer.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(stringBuffer.toString(), 10);
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(stringBuffer.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(stringBuffer.toString());
                    }
                    if (this.nextChar == 46) {
                        stringBuffer.append('.');
                        n2 = 2;
                        break;
                    }
                    if (this.nextChar == 69 || this.nextChar == 101) {
                        stringBuffer.append('E');
                        n2 = 3;
                        break;
                    }
                    return this.stringToIntegerLiteralToken(stringBuffer.toString(), 10);
                }
                case 2: {
                    if (Character.isDigit((char)this.nextChar)) {
                        stringBuffer.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 101 || this.nextChar == 69) {
                        stringBuffer.append('E');
                        n2 = 3;
                        break;
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(stringBuffer.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(stringBuffer.toString());
                    }
                    return this.stringToDoubleLiteralToken(stringBuffer.toString());
                }
                case 3: {
                    if (Character.isDigit((char)this.nextChar)) {
                        stringBuffer.append((char)this.nextChar);
                        n2 = 5;
                        break;
                    }
                    if (this.nextChar == 45 || this.nextChar == 43) {
                        stringBuffer.append((char)this.nextChar);
                        n2 = 4;
                        break;
                    }
                    throw new ScanException("Exponent missing after \"E\"");
                }
                case 4: {
                    if (Character.isDigit((char)this.nextChar)) {
                        stringBuffer.append((char)this.nextChar);
                        n2 = 5;
                        break;
                    }
                    throw new ScanException("Exponent missing after \"E\" and sign");
                }
                case 5: {
                    if (Character.isDigit((char)this.nextChar)) {
                        stringBuffer.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(stringBuffer.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(stringBuffer.toString());
                    }
                    return this.stringToDoubleLiteralToken(stringBuffer.toString());
                }
                case 6: {
                    if ("01234567".indexOf(this.nextChar) != -1) {
                        stringBuffer.append((char)this.nextChar);
                        n2 = 7;
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken("0", 10);
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken("0");
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken("0");
                    }
                    if (this.nextChar == 46) {
                        stringBuffer.append("0.");
                        n2 = 2;
                        break;
                    }
                    if (this.nextChar == 69 || this.nextChar == 101) {
                        stringBuffer.append('E');
                        n2 = 3;
                        break;
                    }
                    if (this.nextChar == 120 || this.nextChar == 88) {
                        n2 = 8;
                        break;
                    }
                    return this.stringToIntegerLiteralToken("0", 10);
                }
                case 7: {
                    if ("01234567".indexOf(this.nextChar) != -1) {
                        stringBuffer.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(stringBuffer.toString(), 8);
                    }
                    return this.stringToIntegerLiteralToken(stringBuffer.toString(), 8);
                }
                case 8: {
                    if (Character.digit((char)this.nextChar, 16) != -1) {
                        stringBuffer.append((char)this.nextChar);
                        n2 = 9;
                        break;
                    }
                    throw new ScanException("Hex digit expected after \"0x\"");
                }
                case 9: {
                    if (Character.digit((char)this.nextChar, 16) != -1) {
                        stringBuffer.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(stringBuffer.toString(), 16);
                    }
                    return this.stringToIntegerLiteralToken(stringBuffer.toString(), 16);
                }
            }
            this.readNextChar();
        }
    }

    public void setWarningHandler(WarningHandler warningHandler) {
        this.optionalWarningHandler = warningHandler;
    }

    private LiteralToken stringToDoubleLiteralToken(String string) throws ScanException {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("SNO: parsing double literal \"" + string + "\" throws a \"NumberFormatException\"");
        }
        if (Double.isInfinite(d)) {
            throw new ScanException("Value of double literal \"" + string + "\" is out of range");
        }
        if (Double.isNaN(d)) {
            throw new RuntimeException("SNO: parsing double literal \"" + string + "\" results is NaN");
        }
        if (d == 0.0) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if ("123456789".indexOf(c) != -1) {
                    throw new ScanException("Literal \"" + string + "\" is too small to be represented as a double");
                }
                if ("0.".indexOf(c) == -1) break;
                ++n;
            }
        }
        return new LiteralToken(new Double(d));
    }

    private LiteralToken stringToFloatLiteralToken(String string) throws ScanException {
        float f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("SNO: parsing float literal \"" + string + "\" throws a \"NumberFormatException\"");
        }
        if (Float.isInfinite(f)) {
            throw new ScanException("Value of float literal \"" + string + "\" is out of range");
        }
        if (Float.isNaN(f)) {
            throw new RuntimeException("SNO: parsing float literal \"" + string + "\" results is NaN");
        }
        if (f == 0.0f) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if ("123456789".indexOf(c) != -1) {
                    throw new ScanException("Literal \"" + string + "\" is too small to be represented as a float");
                }
                if ("0.".indexOf(c) == -1) break;
                ++n;
            }
        }
        return new LiteralToken(new Float(f));
    }

    private LiteralToken stringToIntegerLiteralToken(String string, int n) throws ScanException {
        int n2;
        switch (n) {
            case 10: {
                if (string.equals("2147483648")) {
                    return new LiteralToken(MAGIC_INTEGER);
                }
                try {
                    n2 = Integer.parseInt(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ScanException("Value of decimal integer literal \"" + string + "\" is out of range");
                }
            }
            case 8: {
                n2 = 0;
                int n3 = 0;
                while (n3 < string.length()) {
                    if ((n2 & 0xE0000000) != 0) {
                        throw new ScanException("Value of octal integer literal \"" + string + "\" is out of range");
                    }
                    n2 = (n2 << 3) + Character.digit(string.charAt(n3), 8);
                    ++n3;
                }
                break;
            }
            case 16: {
                n2 = 0;
                int n4 = 0;
                while (n4 < string.length()) {
                    if ((n2 & 0xF0000000) != 0) {
                        throw new ScanException("Value of hexadecimal integer literal \"" + string + "\" is out of range");
                    }
                    n2 = (n2 << 4) + Character.digit(string.charAt(n4), 16);
                    ++n4;
                }
                break;
            }
            default: {
                throw new RuntimeException("Illegal radix " + n);
            }
        }
        return new LiteralToken(new Integer(n2));
    }

    private LiteralToken stringToLongLiteralToken(String string, int n) throws ScanException {
        long l;
        switch (n) {
            case 10: {
                if (string.equals("9223372036854775808")) {
                    return new LiteralToken(MAGIC_LONG);
                }
                try {
                    l = Long.parseLong(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ScanException("Value of decimal long literal \"" + string + "\" is out of range");
                }
            }
            case 8: {
                l = 0L;
                int n2 = 0;
                while (n2 < string.length()) {
                    if ((l & 0xE000000000000000L) != 0L) {
                        throw new ScanException("Value of octal long literal \"" + string + "\" is out of range");
                    }
                    l = (l << 3) + (long)Character.digit(string.charAt(n2), 8);
                    ++n2;
                }
                break;
            }
            case 16: {
                l = 0L;
                int n3 = 0;
                while (n3 < string.length()) {
                    if ((l & 0xF000000000000000L) != 0L) {
                        throw new ScanException("Value of hexadecimal long literal \"" + string + "\" is out of range");
                    }
                    l = (l << 4) + (long)Character.digit(string.charAt(n3), 16);
                    ++n3;
                }
                break;
            }
            default: {
                throw new RuntimeException("Illegal radix " + n);
            }
        }
        return new LiteralToken(new Long(l));
    }

    private char unescapeCharacterLiteral() throws ScanException, IOException {
        if (this.nextChar == -1) {
            throw new ScanException("EOF in character literal");
        }
        if (this.nextChar == 13 || this.nextChar == 10) {
            throw new ScanException("Line break in literal not allowed");
        }
        if (this.nextChar != 92) {
            char c = (char)this.nextChar;
            this.readNextChar();
            return c;
        }
        this.readNextChar();
        int n = "btnfr".indexOf(this.nextChar);
        if (n != -1) {
            char c = "\b\t\n\f\r".charAt(n);
            this.readNextChar();
            return c;
        }
        n = "01234567".indexOf(this.nextChar);
        if (n != -1) {
            int n2 = n;
            this.readNextChar();
            n = "01234567".indexOf(this.nextChar);
            if (n == -1) {
                return (char)n2;
            }
            n2 = 8 * n2 + n;
            this.readNextChar();
            n = "01234567".indexOf(this.nextChar);
            if (n == -1) {
                return (char)n2;
            }
            if ((n2 = 8 * n2 + n) > 255) {
                throw new ScanException("Invalid octal escape");
            }
            this.readNextChar();
            return (char)n2;
        }
        char c = (char)this.nextChar;
        this.readNextChar();
        return c;
    }

    private void warning(String string, String string2, Location location) {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(string, string2, location);
        }
    }

    public abstract class Token {
        private String optionalFileName;
        private short lineNumber;
        private short columnNumber;
        private Location location = null;

        private Token() {
            this.optionalFileName = Scanner.this.optionalFileName;
            this.lineNumber = Scanner.this.tokenLineNumber;
            this.columnNumber = Scanner.this.tokenColumnNumber;
        }

        public String getIdentifier() throws ScanException {
            throw new ScanException("Not an identifier token");
        }

        public String getKeyword() throws ScanException {
            throw new ScanException("Not a keyword token");
        }

        public Object getLiteralValue() throws ScanException {
            throw new ScanException("Not a literal token");
        }

        public Location getLocation() {
            if (this.location == null) {
                this.location = new Location(this.optionalFileName, this.lineNumber, this.columnNumber);
            }
            return this.location;
        }

        public String getOperator() throws ScanException {
            throw new ScanException("Not an operator token");
        }

        public boolean isEOF() {
            return false;
        }

        public boolean isIdentifier() {
            return false;
        }

        public boolean isIdentifier(String string) {
            return false;
        }

        public boolean isKeyword() {
            return false;
        }

        public boolean isKeyword(String string) {
            return false;
        }

        public boolean isKeyword(String[] stringArray) {
            return false;
        }

        public boolean isLiteral() {
            return false;
        }

        public boolean isOperator() {
            return false;
        }

        public boolean isOperator(String string) {
            return false;
        }

        public boolean isOperator(String[] stringArray) {
            return false;
        }
    }

    public class KeywordToken
    extends Token {
        private final String keyword;

        private KeywordToken(String string) {
            class Org_codehaus_janino_Scanner$1 {
                /* synthetic */ Org_codehaus_janino_Scanner$1() {
                }
            }
            this.keyword = string;
        }

        /* synthetic */ KeywordToken(1 var2_2, String string) {
            this(string);
        }

        public String getKeyword() {
            return this.keyword;
        }

        public boolean isKeyword() {
            return true;
        }

        public boolean isKeyword(String string) {
            return this.keyword == string;
        }

        public boolean isKeyword(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.keyword == stringArray[n]) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public String toString() {
            return this.keyword;
        }
    }

    public class IdentifierToken
    extends Token {
        private final String identifier;

        private IdentifierToken(String string) {
            this.identifier = string;
        }

        /* synthetic */ IdentifierToken(1 var2_2, String string) {
            this(string);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean isIdentifier() {
            return true;
        }

        public boolean isIdentifier(String string) {
            return this.identifier.equals(string);
        }

        public String toString() {
            return this.identifier;
        }
    }

    public final class LiteralToken
    extends Token {
        private final Object value;

        public LiteralToken(Object object) {
            this.value = object;
        }

        public Object getLiteralValue() {
            return this.value;
        }

        public final boolean isLiteral() {
            return true;
        }

        public String toString() {
            return Scanner.literalValueToString(this.value);
        }
    }

    public class OperatorToken
    extends Token {
        private final String operator;

        private OperatorToken(String string) {
            this.operator = string;
        }

        /* synthetic */ OperatorToken(1 var2_2, String string) {
            this(string);
        }

        public String getOperator() {
            return this.operator;
        }

        public boolean isOperator() {
            return true;
        }

        public boolean isOperator(String string) {
            return this.operator == string;
        }

        public boolean isOperator(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.operator == stringArray[n]) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public String toString() {
            return this.operator;
        }
    }

    public class EOFToken
    extends Token {
        public EOFToken() {
        }

        public boolean isEOF() {
            return true;
        }

        public String toString() {
            return "End-Of-File";
        }
    }

    public class ScanException
    extends LocatedException {
        public ScanException(String string) {
            super(string, new Location(Scanner.this.optionalFileName, Scanner.this.nextCharLineNumber, Scanner.this.nextCharColumnNumber));
        }

        public ScanException(String string, Throwable throwable) {
            super(string, new Location(Scanner.this.optionalFileName, Scanner.this.nextCharLineNumber, Scanner.this.nextCharColumnNumber), throwable);
        }
    }
}

