/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodFilter;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.expression.spel.support.ReflectiveMethodExecutor;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveMethodResolver
implements MethodResolver {
    private static Method[] NO_METHODS = new Method[0];
    private Map<Class<?>, MethodFilter> filters = null;

    @Override
    public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        try {
            MethodFilter filter;
            TypeConverter typeConverter = context.getTypeConverter();
            Class<?> type = targetObject instanceof Class ? (Class<?>)targetObject : targetObject.getClass();
            Method[] methods = type.getMethods();
            MethodFilter methodFilter = filter = this.filters != null ? this.filters.get(type) : null;
            if (filter != null) {
                ArrayList<Method> methodsForFiltering = new ArrayList<Method>();
                Method[] methodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    methodsForFiltering.add(method);
                    ++n2;
                }
                List<Method> methodsFiltered = filter.filter(methodsForFiltering);
                methods = CollectionUtils.isEmpty(methodsFiltered) ? NO_METHODS : methodsFiltered.toArray(new Method[methodsFiltered.size()]);
            }
            Arrays.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method m1, Method m2) {
                    int m1pl = m1.getParameterTypes().length;
                    int m2pl = m2.getParameterTypes().length;
                    return new Integer(m1pl).compareTo(m2pl);
                }
            });
            Method closeMatch = null;
            int[] argsToConvert = null;
            Method matchRequiringConversion = null;
            boolean multipleOptions = false;
            Method[] methodArray = methods;
            int n = methods.length;
            int n3 = 0;
            while (n3 < n) {
                Method method = methodArray[n3];
                if (!method.isBridge() && method.getName().equals(name)) {
                    Class<?>[] paramTypes = method.getParameterTypes();
                    ArrayList<TypeDescriptor> paramDescriptors = new ArrayList<TypeDescriptor>(paramTypes.length);
                    int i = 0;
                    while (i < paramTypes.length) {
                        paramDescriptors.add(new TypeDescriptor(new MethodParameter(method, i)));
                        ++i;
                    }
                    ReflectionHelper.ArgumentsMatchInfo matchInfo = null;
                    if (method.isVarArgs() && argumentTypes.size() >= paramTypes.length - 1) {
                        matchInfo = ReflectionHelper.compareArgumentsVarargs(paramDescriptors, argumentTypes, typeConverter);
                    } else if (paramTypes.length == argumentTypes.size()) {
                        matchInfo = ReflectionHelper.compareArguments(paramDescriptors, argumentTypes, typeConverter);
                    }
                    if (matchInfo != null) {
                        if (matchInfo.kind == ReflectionHelper.ArgsMatchKind.EXACT) {
                            return new ReflectiveMethodExecutor(method, null);
                        }
                        if (matchInfo.kind == ReflectionHelper.ArgsMatchKind.CLOSE) {
                            closeMatch = method;
                        } else if (matchInfo.kind == ReflectionHelper.ArgsMatchKind.REQUIRES_CONVERSION) {
                            if (matchRequiringConversion != null) {
                                multipleOptions = true;
                            }
                            argsToConvert = matchInfo.argsRequiringConversion;
                            matchRequiringConversion = method;
                        }
                    }
                }
                ++n3;
            }
            if (closeMatch != null) {
                return new ReflectiveMethodExecutor(closeMatch, null);
            }
            if (matchRequiringConversion != null) {
                if (multipleOptions) {
                    throw new SpelEvaluationException(SpelMessage.MULTIPLE_POSSIBLE_METHODS, name);
                }
                return new ReflectiveMethodExecutor(matchRequiringConversion, argsToConvert);
            }
            return null;
        }
        catch (EvaluationException ex) {
            throw new AccessException("Failed to resolve method", ex);
        }
    }

    public void registerMethodFilter(Class<?> type, MethodFilter filter) {
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        if (filter == null) {
            this.filters.remove(type);
        } else {
            this.filters.put(type, filter);
        }
    }
}

