/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.util.Util;

public class PullPushShunTest
extends TestCase
implements MessageListener,
MembershipListener {
    private JChannel channel;
    PullPushAdapter adapter;

    public static Test suite() {
        return new TestSuite(PullPushShunTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)PullPushShunTest.suite());
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testShunningandReconnect() throws Exception {
        this.channel = new JChannel();
        this.channel.setOpt(5, Boolean.TRUE);
        this.channel.connect("PullPushTestShun");
        this.adapter = new PullPushAdapter(this.channel, this, this);
        PullPushShunTest.assertEquals((int)1, (int)this.channel.getView().getMembers().size());
        Address old_local_addr = this.channel.getLocalAddress();
        PullPushShunTest.assertNotNull((Object)old_local_addr);
        Util.sleep(1000L);
        System.out.println("shunning channel");
        this.shun();
        Util.sleep(5000L);
        Address new_local_addr = this.channel.getLocalAddress();
        PullPushShunTest.assertNotNull((Object)new_local_addr);
        PullPushShunTest.assertFalse((boolean)old_local_addr.equals(new_local_addr));
        this.channel.close();
    }

    private void shun() {
        this.channel.up(new Event(46));
    }

    public void receive(Message msg) {
        System.out.println("-- received " + msg);
    }

    public byte[] getState() {
        return new byte[0];
    }

    public void setState(byte[] state) {
    }

    public void viewAccepted(View new_view) {
        System.out.println("-- view: " + new_view);
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public void channelConnected(Channel channel) {
        System.out.println("-- channelConnected()");
    }

    public void channelDisconnected(Channel channel) {
        System.out.println("-- channelDisconnected()");
    }

    public void channelClosed(Channel channel) {
        System.out.println("-- channelClosed()");
    }

    public void channelShunned() {
        System.out.println("-- channelShunned()");
    }

    public void channelReconnected(Address addr) {
        System.out.println("-- channelReconnected(" + addr + ")");
    }
}

