/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.MenuComponent;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import java.util.Random;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;

public class DrawRepl
implements MouseMotionListener,
WindowListener,
ActionListener,
Runnable {
    private Graphics graphics = null;
    private Frame mainFrame = null;
    private Panel panel = null;
    private Panel sub_panel = null;
    private final byte[] buf = new byte[128];
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private DataOutputStream outstream;
    private ByteArrayInputStream inp;
    private DataInputStream instream;
    private int x;
    private int y;
    private final Hashtable colors = new Hashtable();
    private final Random random = new Random(System.currentTimeMillis());
    private int col_val = 1;
    private Color current_color = Color.red;
    private Button clear_button;
    private Button leave_button;
    private final String groupname = "DrawReplGroup";
    private final Font default_font = new Font("Helvetica", 0, 12);
    private EventQueue event_queue = null;
    private Thread mythread = null;
    private RpcDispatcher dispatcher;
    private Channel channel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$AWTEvent;

    public DrawRepl() {
        this.colors.put(new Integer(1), Color.white);
        this.colors.put(new Integer(2), Color.black);
        this.colors.put(new Integer(3), Color.red);
        this.colors.put(new Integer(4), Color.orange);
        this.colors.put(new Integer(5), Color.green);
        this.colors.put(new Integer(6), Color.magenta);
        this.colors.put(new Integer(7), Color.cyan);
        this.colors.put(new Integer(8), Color.blue);
        this.mythread = new Thread(this);
        try {
            this.channel = new JChannel();
            this.dispatcher = new RpcDispatcher(this.channel, null, null, this);
            this.channel.connect("DrawReplGroup");
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        DrawRepl draw = new DrawRepl();
        draw.go();
    }

    private Color SelectColor() {
        this.col_val = Math.abs(this.random.nextInt()) % 8 + 1;
        Color ret = (Color)this.colors.get(new Integer(this.col_val));
        if (ret == null) {
            ret = Color.red;
        }
        return ret;
    }

    AWTEvent copyEvent(Component src, AWTEvent evt) {
        if (evt instanceof MouseEvent) {
            MouseEvent mev = (MouseEvent)evt;
            return new MouseEvent(src, evt.getID(), mev.getWhen(), mev.getModifiers(), mev.getX(), mev.getY(), mev.getClickCount(), mev.isPopupTrigger());
        }
        if (evt instanceof KeyEvent) {
            KeyEvent kev = (KeyEvent)evt;
            return new KeyEvent(src, evt.getID(), kev.getWhen(), kev.getModifiers(), kev.getKeyCode(), kev.getKeyChar());
        }
        if (evt instanceof ActionEvent) {
            return new ActionEvent(src, evt.getID(), ((ActionEvent)evt).getActionCommand(), ((ActionEvent)evt).getModifiers());
        }
        if (evt instanceof PaintEvent) {
            return new PaintEvent(src, evt.getID(), ((PaintEvent)evt).getUpdateRect());
        }
        if (evt instanceof FocusEvent) {
            return new FocusEvent(src, evt.getID(), ((FocusEvent)evt).isTemporary());
        }
        if (evt instanceof ComponentEvent) {
            return new ComponentEvent(src, evt.getID());
        }
        return null;
    }

    void dispatch(Object src, AWTEvent evt) {
        if (src instanceof Component) {
            ((Component)src).dispatchEvent(evt);
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(evt);
        } else {
            System.err.println("++++++++++");
        }
    }

    public Component findComponent(Container parent, String comp_name) {
        Component retval = null;
        if (comp_name != null && comp_name.equals(parent.getName())) {
            return parent;
        }
        int ncomponents = parent.getComponentCount();
        Component[] components = parent.getComponents();
        for (int i = ncomponents - 1; i >= 0; --i) {
            Component comp = components[i];
            if (comp == null) continue;
            if (comp instanceof Container) {
                retval = this.findComponent((Container)comp, comp_name);
                if (retval == null) continue;
                return retval;
            }
            if (!comp_name.equals(comp.getName())) continue;
            return comp;
        }
        return retval;
    }

    public void processEvent(String comp_name, AWTEvent evt) {
        AWTEvent copy_evt = null;
        Component src = this.findComponent(this.mainFrame, comp_name);
        if (src == null) {
            System.err.println("processEvent(): src is null");
            return;
        }
        System.out.println("Received " + evt.getClass().getName());
        copy_evt = this.copyEvent(src, evt);
        if (copy_evt == null) {
            System.err.println("copy_evt is NULL");
            return;
        }
        this.dispatch(src, copy_evt);
    }

    void processLocally(AWTEvent evt) {
        this.dispatch(evt.getSource(), evt);
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    void var1_1;
                    String comp_name;
                    AWTEvent evt;
                    Object obj;
                    if ((obj = (evt = this.event_queue.getNextEvent()).getSource()) == null) {
                        System.err.println("src is NULL");
                        continue;
                    }
                    if (obj instanceof Component) {
                        comp_name = ((Component)obj).getName();
                    } else if (obj instanceof MenuComponent) {
                        comp_name = ((MenuComponent)obj).getName();
                    } else {
                        System.err.println("src is of type " + obj.getClass().getName());
                        continue;
                    }
                    if (evt instanceof FocusEvent || evt instanceof PaintEvent) {
                        System.out.println(evt.getClass().getName() + " not copied");
                        this.processLocally(evt);
                        continue;
                    }
                    System.out.println("MCasting " + evt.getClass().getName() + " event...");
                    MethodCall call = new MethodCall("processEvent", new Object[]{var1_1, evt}, new String[]{(class$java$lang$String == null ? DrawRepl.class$("java.lang.String") : class$java$lang$String).getName(), (class$java$awt$AWTEvent == null ? DrawRepl.class$("java.awt.AWTEvent") : class$java$awt$AWTEvent).getName()});
                    this.dispatcher.callRemoteMethods(null, call, 6, 0L);
                }
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }

    public void go() {
        this.mainFrame = new Frame();
        this.panel = new Panel();
        this.sub_panel = new Panel();
        this.event_queue = this.mainFrame.getToolkit().getSystemEventQueue();
        this.mythread.start();
        this.mainFrame.setSize(200, 200);
        this.mainFrame.add("Center", this.panel);
        this.clear_button = new Button("Clear");
        this.clear_button.setFont(this.default_font);
        this.clear_button.addActionListener(this);
        this.leave_button = new Button("Exit");
        this.leave_button.setFont(this.default_font);
        this.leave_button.addActionListener(this);
        this.sub_panel.add("South", this.clear_button);
        this.sub_panel.add("South", this.leave_button);
        this.mainFrame.add("South", this.sub_panel);
        this.mainFrame.addWindowListener(this);
        this.panel.addMouseMotionListener(this);
        this.mainFrame.setVisible(true);
        this.graphics = this.panel.getGraphics();
        this.current_color = this.SelectColor();
        if (this.current_color == null) {
            this.current_color = Color.red;
        }
        this.graphics.setColor(this.current_color);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
        this.graphics.fillOval(this.x, this.y, 10, 10);
    }

    public void clearPanel() {
        System.out.println("CLEAR");
        Rectangle bounds = this.panel.getBounds();
        this.graphics.clearRect(0, 0, bounds.width, bounds.height);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Clear".equals(command)) {
            this.clearPanel();
        } else if ("Exit".equals(command)) {
            this.mainFrame.setVisible(false);
            System.exit(0);
        } else {
            System.out.println("Unknown action");
        }
    }
}

