/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;

public class SHUFFLE
extends Protocol
implements Runnable {
    String name = "SHUFFLE";
    final List messages = Collections.synchronizedList(new ArrayList());
    Thread messagesHandler;

    public String getName() {
        return this.name;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("name");
        if (str != null) {
            this.name = str;
            props.remove("name");
        }
        if (props.size() > 0) {
            System.err.println("DUMMY.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                this.messages.add(msg);
                return;
            }
        }
        this.passUp(evt);
    }

    public void start() throws Exception {
        this.messagesHandler = new Thread((Runnable)this, "MessagesHandler");
        this.messagesHandler.setDaemon(true);
        this.messagesHandler.start();
    }

    public void stop() {
        Thread tmp = this.messagesHandler;
        this.messagesHandler = null;
        try {
            tmp.join();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void run() {
        Message msg;
        while (this.messagesHandler != null) {
            if (this.messages.size() > 0) {
                msg = (Message)this.messages.remove(this.rnd(this.messages.size()));
                this.passUp(new Event(1, msg));
            }
            if (this.messages.size() >= 5) continue;
            try {
                Thread.sleep(300L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Iterator iter = this.messages.iterator();
        while (iter.hasNext()) {
            msg = (Message)iter.next();
            this.passUp(new Event(1, msg));
        }
    }

    int rnd(int n) {
        return (int)(Math.random() * (double)n);
    }
}

