/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.ConnectionTable;
import org.jgroups.protocols.TcpHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;

public class TCP
extends Protocol
implements ConnectionTable.Receiver {
    private ConnectionTable ct = null;
    protected Address local_addr = null;
    private String group_addr = null;
    private InetAddress bind_addr = null;
    private InetAddress external_addr = null;
    private int start_port = 7800;
    private int end_port = 0;
    private final Vector members = new Vector(11);
    private long reaper_interval = 0L;
    private long conn_expire_time = 0L;
    boolean loopback = false;
    byte[] additional_data = null;
    final BoundedList suspected_mbrs = new BoundedList(20);
    boolean skip_suspected_members = true;
    int recv_buf_size = 150000;
    int send_buf_size = 150000;
    int sock_conn_timeout = 2000;
    static final String name = "TCP";
    static final String IGNORE_BIND_ADDRESS_PROPERTY = "ignore.bind.address";

    public String toString() {
        return "Protocol TCP(local address: " + this.local_addr + ')';
    }

    public String getName() {
        return name;
    }

    protected final Vector getMembers() {
        return this.members;
    }

    public void startUpHandler() {
    }

    public void start() throws Exception {
        this.ct = this.getConnectionTable(this.reaper_interval, this.conn_expire_time, this.bind_addr, this.external_addr, this.start_port, this.end_port);
        this.ct.setReceiveBufferSize(this.recv_buf_size);
        this.ct.setSendBufferSize(this.send_buf_size);
        this.ct.setSocketConnectionTimeout(this.sock_conn_timeout);
        this.local_addr = this.ct.getLocalAddress();
        if (this.additional_data != null && this.local_addr instanceof IpAddress) {
            ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
        }
        this.passUp(new Event(8, this.local_addr));
    }

    protected ConnectionTable getConnectionTable(long reaperInterval, long connExpireTime, InetAddress bindAddress, InetAddress externalAddress, int startPort, int endPort) throws Exception {
        ConnectionTable cTable = null;
        if (reaperInterval == 0L && connExpireTime == 0L) {
            cTable = new ConnectionTable(this, bindAddress, externalAddress, startPort, endPort);
        } else {
            if (reaperInterval == 0L) {
                reaperInterval = 5000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("reaper_interval was 0, set it to " + reaperInterval));
                }
            }
            if (connExpireTime == 0L) {
                connExpireTime = 300000L;
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("conn_expire_time was 0, set it to " + connExpireTime));
                }
            }
            cTable = new ConnectionTable(this, bindAddress, externalAddress, startPort, endPort, reaperInterval, connExpireTime);
        }
        return cTable;
    }

    public void stop() {
        this.ct.stop();
    }

    public void down(Event evt) {
        if (evt.getType() != 1) {
            this.handleDownEvent(evt);
            return;
        }
        Message msg = (Message)evt.getArg();
        if (this.group_addr != null) {
            msg.putHeader(name, new TcpHeader(this.group_addr));
        }
        Address dest_addr = msg.getDest();
        if (this.observer != null) {
            this.observer.passDown(evt);
        }
        if (dest_addr == null) {
            if (this.group_addr == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"dest address of message is null, and sending to default address fails as group_addr is null, too ! Discarding message.");
                }
                return;
            }
            this.sendMulticastMessage(msg);
        } else {
            this.sendUnicastMessage(msg);
        }
    }

    public void receive(Message msg) {
        TcpHeader hdr = null;
        Event evt = new Event(1, msg);
        if (this.observer != null) {
            this.observer.up(evt, this.up_queue.size());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("received msg " + msg));
        }
        if ((hdr = (TcpHeader)msg.removeHeader(name)) != null) {
            String ch_name = null;
            if (hdr.group_addr != null) {
                ch_name = hdr.group_addr;
            }
            if (ch_name != null && !this.group_addr.equals(ch_name) && !ch_name.equals("DIAG_GROUP-BELA-322649")) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("discarded message from different group (" + ch_name + "). Sender was " + msg.getSrc()));
                }
                return;
            }
        }
        this.passUp(evt);
    }

    public boolean setProperties(Properties props) {
        String tmp = null;
        super.setProperties(props);
        String str = props.getProperty("start_port");
        if (str != null) {
            this.start_port = Integer.parseInt(str);
            props.remove("start_port");
        }
        if ((str = props.getProperty("end_port")) != null) {
            this.end_port = Integer.parseInt(str);
            props.remove("end_port");
        }
        try {
            tmp = System.getProperty("bind.address");
            if (Boolean.getBoolean(IGNORE_BIND_ADDRESS_PROPERTY)) {
                tmp = null;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        str = tmp != null ? tmp : props.getProperty("bind_addr");
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)("(bind_addr): host " + str + " not known"));
                }
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = props.getProperty("external_addr")) != null) {
            try {
                this.external_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)("(external_addr): host " + str + " not known"));
                }
                return false;
            }
            props.remove("external_addr");
        }
        if ((str = props.getProperty("reaper_interval")) != null) {
            this.reaper_interval = Long.parseLong(str);
            props.remove("reaper_interval");
        }
        if ((str = props.getProperty("conn_expire_time")) != null) {
            this.conn_expire_time = Long.parseLong(str);
            props.remove("conn_expire_time");
        }
        if ((str = props.getProperty("sock_conn_timeout")) != null) {
            this.sock_conn_timeout = Integer.parseInt(str);
            props.remove("sock_conn_timeout");
        }
        if ((str = props.getProperty("recv_buf_size")) != null) {
            this.recv_buf_size = Integer.parseInt(str);
            props.remove("recv_buf_size");
        }
        if ((str = props.getProperty("send_buf_size")) != null) {
            this.send_buf_size = Integer.parseInt(str);
            props.remove("send_buf_size");
        }
        if ((str = props.getProperty("loopback")) != null) {
            this.loopback = Boolean.valueOf(str);
            props.remove("loopback");
        }
        if ((str = props.getProperty("skip_suspected_members")) != null) {
            this.skip_suspected_members = Boolean.valueOf(str);
            props.remove("skip_suspected_members");
        }
        if (props.size() > 0) {
            System.err.println("TCP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    private void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    private void sendUnicastMessage(Message msg) {
        block10: {
            IpAddress dest = (IpAddress)msg.getDest();
            if (!(dest instanceof IpAddress)) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"destination address is not of type IpAddress !");
                }
                return;
            }
            this.setSourceAddress(msg);
            if (this.loopback && this.local_addr != null && dest != null && dest.equals(this.local_addr)) {
                Message copy = msg.copy();
                Header hdr = copy.getHeader(name);
                if (hdr != null && hdr instanceof TcpHeader) {
                    copy.removeHeader(name);
                }
                copy.setSrc(this.local_addr);
                copy.setDest(this.local_addr);
                Event evt = new Event(1, copy);
                if (this.observer != null) {
                    this.observer.up(evt, this.up_queue.size());
                }
                this.passUp(evt);
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("dest=" + msg.getDest() + ", hdrs:\n" + msg.printObjectHeaders()));
            }
            try {
                if (this.skip_suspected_members && this.suspected_mbrs.contains(dest)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("will not send unicast message to " + dest + " as it is currently suspected"));
                    }
                    return;
                }
                this.ct.send(msg);
            }
            catch (SocketException e) {
                if (!this.members.contains(dest) || this.suspected_mbrs.contains(dest)) break block10;
                this.suspected_mbrs.add(dest);
                this.passUp(new Event(9, dest));
            }
        }
    }

    protected void sendMulticastMessage(Message msg) {
        Vector mbrs = (Vector)this.members.clone();
        for (int i = 0; i < mbrs.size(); ++i) {
            Address dest = (Address)mbrs.elementAt(i);
            msg.setDest(dest);
            this.sendUnicastMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                this.suspected_mbrs.removeAll();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.clear();
                    this.members.addAll(((View)evt.getArg()).getMembers());
                    break;
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                this.passUp(new Event(5));
                break;
            }
            case 56: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
            }
        }
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("additional_data")) {
            this.additional_data = (byte[])map.get("additional_data");
        }
    }
}

