/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.stack.Interval;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class Retransmitter {
    private static final long SEC = 1000L;
    private static long[] RETRANSMIT_TIMEOUTS = new long[]{2000L, 3000L, 5000L, 8000L};
    private static final long SUSPEND_TIMEOUT = 2000L;
    private Address sender = null;
    private final LinkedList msgs = new LinkedList();
    private RetransmitCommand cmd = null;
    private boolean retransmitter_owned;
    private TimeScheduler retransmitter = null;
    protected static final Log log = LogFactory.getLog((Class)Retransmitter.class);

    public Retransmitter(Address sender, RetransmitCommand cmd, TimeScheduler sched) {
        this.init(sender, cmd, sched, false);
    }

    public Retransmitter(Address sender, RetransmitCommand cmd) {
        this.init(sender, cmd, new TimeScheduler(2000L), true);
    }

    public void setRetransmitTimeouts(long[] timeouts) {
        if (timeouts != null) {
            RETRANSMIT_TIMEOUTS = timeouts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long first_seqno, long last_seqno) {
        if (first_seqno > last_seqno) {
            long tmp = first_seqno;
            first_seqno = last_seqno;
            last_seqno = tmp;
        }
        LinkedList linkedList = this.msgs;
        synchronized (linkedList) {
            Entry e = new Entry(first_seqno, last_seqno, RETRANSMIT_TIMEOUTS);
            this.msgs.add(e);
            this.retransmitter.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long seqno) {
        LinkedList linkedList = this.msgs;
        synchronized (linkedList) {
            ListIterator it = this.msgs.listIterator();
            while (it.hasNext()) {
                Entry e;
                Entry entry = e = (Entry)it.next();
                synchronized (entry) {
                    if (seqno < e.low || seqno > e.high) {
                        continue;
                    }
                    e.remove(seqno);
                    if (e.low > e.high) {
                        e.cancel();
                        it.remove();
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        LinkedList linkedList = this.msgs;
        synchronized (linkedList) {
            ListIterator it = this.msgs.listIterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                entry.cancel();
            }
            this.msgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LinkedList linkedList = this.msgs;
        synchronized (linkedList) {
            block8: {
                if (this.retransmitter_owned) {
                    try {
                        this.retransmitter.stop();
                    }
                    catch (InterruptedException ex) {
                        if (!log.isErrorEnabled()) break block8;
                        log.error((Object)Util.printStackTrace(ex));
                    }
                } else {
                    ListIterator it = this.msgs.listIterator();
                    while (it.hasNext()) {
                        Entry entry = (Entry)it.next();
                        entry.cancel();
                    }
                }
            }
            this.msgs.clear();
        }
    }

    public String toString() {
        return this.msgs.size() + " messages to retransmit: (" + this.msgs.toString() + ')';
    }

    private void init(Address sender, RetransmitCommand cmd, TimeScheduler sched, boolean sched_owned) {
        this.sender = sender;
        this.cmd = cmd;
        this.retransmitter_owned = sched_owned;
        this.retransmitter = sched;
    }

    public static void main(String[] args) {
        try {
            IpAddress sender = new IpAddress("localhost", 5555);
            Retransmitter xmitter = new Retransmitter(sender, new MyXmitter());
            xmitter.setRetransmitTimeouts(new long[]{1000L, 2000L, 4000L, 8000L});
            xmitter.add(1L, 10L);
            xmitter.remove(1L);
            xmitter.remove(2L);
            xmitter.remove(4L);
            Util.sleep(3000L);
            xmitter.remove(3L);
            Util.sleep(1000L);
            xmitter.remove(10L);
            xmitter.remove(8L);
            xmitter.remove(6L);
            xmitter.remove(7L);
            xmitter.remove(9L);
            xmitter.remove(5L);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void sleep(long timeout) {
        Util.sleep(timeout);
    }

    static class MyXmitter
    implements RetransmitCommand {
        MyXmitter() {
        }

        public void retransmit(long first_seqno, long last_seqno, Address sender) {
            System.out.println("-- " + new Date() + ": retransmit(" + first_seqno + ", " + last_seqno + ", " + sender + ')');
        }
    }

    private class Entry
    extends Task {
        public long low;
        public long high;
        public final List list;

        public Entry(long low, long high, long[] intervals) {
            super(intervals);
            this.low = low;
            this.high = high;
            this.list = new ArrayList();
            this.list.add(new long[]{low, high});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(long seqno) {
            long[] bounds = null;
            Entry entry = this;
            synchronized (entry) {
                int i;
                for (i = 0; i < this.list.size() && (seqno < (bounds = (long[])this.list.get(i))[0] || seqno > bounds[1]); ++i) {
                }
                if (i == this.list.size()) {
                    return;
                }
                if (seqno == bounds[0]) {
                    if (bounds[0] == bounds[1]) {
                        this.list.remove(i);
                    } else {
                        bounds[0] = bounds[0] + 1L;
                    }
                    if (i == 0) {
                        this.low = this.list.size() == 0 ? this.high + 1L : ((long[])this.list.get(i))[0];
                    }
                } else if (seqno == bounds[1]) {
                    bounds[1] = bounds[1] - 1L;
                    if (i == this.list.size() - 1) {
                        this.high = ((long[])this.list.get(i))[1];
                    }
                } else {
                    long[] newBounds = new long[]{seqno + 1L, bounds[1]};
                    bounds[1] = seqno - 1L;
                    this.list.add(i + 1, newBounds);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Entry entry = this;
            synchronized (entry) {
                for (int i = 0; i < this.list.size(); ++i) {
                    long[] bounds = (long[])this.list.get(i);
                    Retransmitter.this.cmd.retransmit(bounds[0], bounds[1], Retransmitter.this.sender);
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.low == this.high) {
                sb.append(this.low);
            } else {
                sb.append(this.low).append(':').append(this.high);
            }
            return sb.toString();
        }
    }

    private static abstract class Task
    implements TimeScheduler.Task {
        private final Interval intervals;
        private boolean cancelled;

        protected Task(long[] intervals) {
            this.intervals = new Interval(intervals);
            this.cancelled = false;
        }

        public long nextInterval() {
            return this.intervals.next();
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, long var3, Address var5);
    }
}

