/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.blocks.MethodCall;
import org.jgroups.stack.MessageProtocol;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcProtocol
extends MessageProtocol {
    public String getName() {
        return "RpcProtocol";
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, Class[] types, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, String[] signature, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout) {
        byte[] buf = null;
        Message msg = null;
        try {
            buf = Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception=" + e));
            }
            return null;
        }
        msg = new Message(null, null, buf);
        return this.castMessage(dests, msg, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, int mode, long timeout) throws TimeoutException, SuspectedException {
        return this.callRemoteMethod(dest, method_name, new Object[0], new Class[0], mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, Class[] types, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, String[] signature, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, MethodCall method_call, int mode, long timeout) throws TimeoutException, SuspectedException {
        byte[] buf = null;
        Message msg = null;
        try {
            buf = Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception=" + e));
            }
            return null;
        }
        msg = new Message(dest, null, buf);
        return this.sendMessage(msg, mode, timeout);
    }

    public Object handle(Message req) {
        Object body = null;
        if (req == null || req.getLength() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"message or message buffer is null");
            }
            return null;
        }
        try {
            body = req.getObject();
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception=" + e));
            }
            return e;
        }
        if (body == null || !(body instanceof MethodCall)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"message does not contain a MethodCall object");
            }
            return null;
        }
        MethodCall method_call = (MethodCall)body;
        try {
            return method_call.invoke(this);
        }
        catch (Throwable x) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)Util.getStackTrace(x));
            }
            return x;
        }
    }

    public boolean handleUpEvent(Event evt) {
        return true;
    }

    public boolean handleDownEvent(Event evt) {
        return true;
    }
}

