/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.JChannel;

public class GossipClientTest
extends TestCase {
    public void testConnectDisconnectSequence() {
        String props = "TCP(start_port=7800;bind_addr=localhost;loopback=true):TCPGOSSIP(timeout=3000;initial_hosts=localhost[7500]num_initial_members=1):FD(timeout=2000;max_tries=4):VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):pbcast.NAKACK(gc_lag=100;retransmit_timeout=600,1200,2400,4800):pbcast.GMS(print_local_addr=true;join_timeout=5000;join_retry_timeout=2000;shun=true)";
        try {
            JChannel jChannel = new JChannel(props);
            jChannel.setOpt(3, Boolean.FALSE);
            jChannel.setOpt(1, Boolean.TRUE);
            jChannel.connect("testGroup");
            GossipClientTest.assertTrue((boolean)jChannel.isConnected());
            GossipClientTest.assertTrue((boolean)jChannel.isOpen());
            System.out.println(jChannel.printProtocolSpec(true));
            jChannel.close();
            GossipClientTest.assertFalse((boolean)jChannel.isConnected());
            GossipClientTest.assertFalse((boolean)jChannel.isOpen());
        }
        catch (Exception e) {
            System.out.println("Error channel " + e);
            GossipClientTest.fail((String)e.toString());
        }
        System.out.println("done");
    }

    public static Test suite() {
        TestSuite s = new TestSuite(GossipClientTest.class);
        return s;
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{GossipClientTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

