/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adaptudp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.adaptudp.ReceiverThread;
import org.jgroups.tests.adaptudp.Request;
import org.jgroups.tests.adaptudp.SenderThread;
import org.jgroups.tests.adaptudp.Test;
import org.jgroups.util.Util;

public class UdpTester {
    private boolean sender;
    private int num_msgs;
    private int msg_size;
    private int num_senders;
    private long log_interval = 1000L;
    MulticastSocket recv_sock;
    DatagramSocket send_sock;
    int num_members;
    IpAddress local_addr;
    MyReceiver receiver = null;
    List members = new ArrayList();

    public UdpTester(MulticastSocket recv_sock, DatagramSocket send_sock, boolean snd, int num_msgs, int msg_size, int num_members, int ns, long log_interval) {
        this.sender = snd;
        this.num_msgs = num_msgs;
        this.msg_size = msg_size;
        this.num_senders = ns;
        this.num_members = num_members;
        this.log_interval = log_interval;
        this.recv_sock = recv_sock;
        this.send_sock = send_sock;
        this.local_addr = new IpAddress(send_sock.getLocalAddress(), send_sock.getLocalPort());
    }

    public void initialize() throws Exception {
        this.waitUntilAllMembersHaveJoined();
        Util.sleep(1000L);
        new ReceiverThread(this.recv_sock, this.num_msgs, this.msg_size, this.num_senders, this.log_interval).start();
        if (this.sender) {
            new SenderThread(this.send_sock, this.num_msgs, this.msg_size, this.log_interval).start();
        }
    }

    void waitUntilAllMembersHaveJoined() throws Exception {
        this.discoverExistingMembers();
    }

    private void discoverExistingMembers() throws Exception {
        this.receiver = new MyReceiver();
        this.members.clear();
        this.receiver.start();
        this.receiver.discoverExistingMembers();
        this.receiver.sendMyAddress();
        this.receiver.waitUntilAllMembersHaveJoined();
    }

    class MyReceiver
    extends Thread {
        boolean running = true;

        MyReceiver() {
        }

        public void run() {
            byte[] buf = new byte[65000];
            DatagramPacket p = new DatagramPacket(buf, buf.length);
            boolean running = true;
            block7: while (running) {
                try {
                    UdpTester.this.recv_sock.receive(p);
                    ByteArrayInputStream input = new ByteArrayInputStream(p.getData(), 0, p.getLength());
                    ObjectInputStream in = new ObjectInputStream(input);
                    Request req = (Request)in.readObject();
                    switch (req.type) {
                        case 1: {
                            ByteArrayOutputStream output = new ByteArrayOutputStream();
                            ObjectOutputStream out = new ObjectOutputStream(output);
                            Request rsp = new Request(2, UdpTester.this.local_addr);
                            out.writeObject(rsp);
                            output.flush();
                            byte[] tmp = output.toByteArray();
                            DatagramPacket rsp_p = new DatagramPacket(tmp, tmp.length, InetAddress.getByName(Test.mcast_addr), Test.mcast_port);
                            UdpTester.this.send_sock.send(rsp_p);
                            continue block7;
                        }
                        case 2: {
                            IpAddress new_mbr = (IpAddress)req.arg;
                            if (UdpTester.this.members.contains(new_mbr)) continue block7;
                            UdpTester.this.members.add(new_mbr);
                            System.out.println("-- discovered " + new_mbr);
                            if (UdpTester.this.members.size() < UdpTester.this.num_members) continue block7;
                            System.out.println("-- all members have joined (" + UdpTester.this.members + ')');
                            running = false;
                            continue block7;
                        }
                    }
                    System.err.println("don't recognize request with type=" + req.type);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }

        public void discoverExistingMembers() throws Exception {
            Request req = new Request(1, null);
            byte[] b = Util.objectToByteBuffer(req);
            DatagramPacket p = new DatagramPacket(b, b.length, InetAddress.getByName(Test.mcast_addr), Test.mcast_port);
            UdpTester.this.send_sock.send(p);
        }

        public void sendMyAddress() throws Exception {
            Request req = new Request(2, UdpTester.this.local_addr);
            byte[] b = Util.objectToByteBuffer(req);
            DatagramPacket p = new DatagramPacket(b, b.length, InetAddress.getByName(Test.mcast_addr), Test.mcast_port);
            UdpTester.this.send_sock.send(p);
        }

        public void waitUntilAllMembersHaveJoined() throws InterruptedException {
            if (UdpTester.this.members.size() < UdpTester.this.num_members && UdpTester.this.receiver.isAlive()) {
                UdpTester.this.receiver.join();
            }
        }
    }
}

