/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.Properties;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Dynamic;

public class NextMemberBuddyLocatorConfig
extends BuddyReplicationConfig.BuddyLocatorConfig {
    private static final long serialVersionUID = 2443438867383733851L;
    @Dynamic
    private int numBuddies = 1;
    @Dynamic
    private boolean ignoreColocatedBuddies = true;

    public NextMemberBuddyLocatorConfig() {
        this.setBuddyLocatorClass(NextMemberBuddyLocator.class.getName());
    }

    NextMemberBuddyLocatorConfig(BuddyReplicationConfig.BuddyLocatorConfig base) {
        this();
        this.setBuddyLocatorProperties(base.getBuddyLocatorProperties());
    }

    public String getBuddyLocatorClass() {
        return NextMemberBuddyLocator.class.getName();
    }

    public void setBuddyLocatorClass(String buddyLocatorClass) {
    }

    public boolean isIgnoreColocatedBuddies() {
        return this.ignoreColocatedBuddies;
    }

    public void setIgnoreColocatedBuddies(boolean ignoreColocatedBuddies) {
        this.testImmutability("ignoreColocatedBuddies");
        this.ignoreColocatedBuddies = ignoreColocatedBuddies;
    }

    public int getNumBuddies() {
        return this.numBuddies;
    }

    public void setNumBuddies(int numBuddies) {
        this.testImmutability("numBuddies");
        this.numBuddies = numBuddies;
    }

    public void setBuddyLocatorProperties(Properties props) {
        super.setBuddyLocatorProperties(props);
        if (props != null) {
            String numBuddiesStr = props.getProperty("numBuddies");
            String ignoreColocatedBuddiesStr = props.getProperty("ignoreColocatedBuddies");
            if (numBuddiesStr != null) {
                this.numBuddies = Integer.parseInt(numBuddiesStr);
            }
            if (ignoreColocatedBuddiesStr != null) {
                this.ignoreColocatedBuddies = Boolean.valueOf(ignoreColocatedBuddiesStr);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NextMemberBuddyLocatorConfig) {
            NextMemberBuddyLocatorConfig other = (NextMemberBuddyLocatorConfig)obj;
            return other.ignoreColocatedBuddies == this.ignoreColocatedBuddies && other.numBuddies == this.numBuddies;
        }
        return false;
    }

    public int hashCode() {
        int result = 13;
        result = 23 * result + (this.ignoreColocatedBuddies ? 0 : 1);
        result = 23 * result + this.numBuddies;
        return result;
    }

    public NextMemberBuddyLocatorConfig clone() throws CloneNotSupportedException {
        return (NextMemberBuddyLocatorConfig)super.clone();
    }
}

