/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.remote;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.commands.ReplicableCommand;
import org.jgroups.Address;

public class AnnounceBuddyPoolNameCommand
implements ReplicableCommand {
    public static final int METHOD_ID = 28;
    private static final Log log = LogFactory.getLog(AnnounceBuddyPoolNameCommand.class);
    private BuddyManager buddyManager;
    private Address address;
    private String buddyPoolName;

    public AnnounceBuddyPoolNameCommand() {
    }

    public AnnounceBuddyPoolNameCommand(Address address, String buddyPoolName) {
        this.address = address;
        this.buddyPoolName = buddyPoolName;
    }

    public void initialize(BuddyManager buddyManager) {
        this.buddyManager = buddyManager;
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.buddyManager != null) {
            this.buddyManager.handlePoolNameBroadcast(this.address, this.buddyPoolName);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Received annouceBuddyPoolName call from [" + this.address + "] but buddy replication is not enabled on this node!"));
        }
        return null;
    }

    public int getCommandId() {
        return 28;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getBuddyPoolName() {
        return this.buddyPoolName;
    }

    public Object[] getParameters() {
        return new Object[]{this.address, this.buddyPoolName};
    }

    public void setParameters(int commandId, Object[] args) {
        this.address = (Address)args[0];
        this.buddyPoolName = (String)args[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnounceBuddyPoolNameCommand that = (AnnounceBuddyPoolNameCommand)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        return !(this.buddyPoolName != null ? !this.buddyPoolName.equals(that.buddyPoolName) : that.buddyPoolName != null);
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (this.buddyPoolName != null ? this.buddyPoolName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AnnounceBuddyPoolNameCommand{buddyManager=" + this.buddyManager + ", address=" + this.address + ", buddyPoolName='" + this.buddyPoolName + '\'' + '}';
    }
}

