/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.config.PluggableConfigurationComponent;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.SingletonStoreCacheLoader;
import org.jboss.cache.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheLoaderConfig
extends ConfigurationComponent {
    private static final long serialVersionUID = 2210349340378984424L;
    private boolean passivation;
    private String preload;
    private List<IndividualCacheLoaderConfig> cacheLoaderConfigs = new ArrayList<IndividualCacheLoaderConfig>();
    private boolean shared;

    public String getPreload() {
        return this.preload;
    }

    public void setPreload(String preload) {
        this.testImmutability("preload");
        this.preload = preload;
    }

    public void setPassivation(boolean passivation) {
        this.testImmutability("passivation");
        this.passivation = passivation;
    }

    public boolean isPassivation() {
        return this.passivation;
    }

    public void addIndividualCacheLoaderConfig(IndividualCacheLoaderConfig clc) {
        this.testImmutability("cacheLoaderConfigs");
        this.cacheLoaderConfigs.add(clc);
        this.addChildConfig(clc);
    }

    public List<IndividualCacheLoaderConfig> getIndividualCacheLoaderConfigs() {
        return this.cacheLoaderConfigs;
    }

    public void setIndividualCacheLoaderConfigs(List<IndividualCacheLoaderConfig> configs) {
        this.testImmutability("cacheLoaderConfigs");
        this.replaceChildConfigs(this.cacheLoaderConfigs, configs);
        this.cacheLoaderConfigs = configs == null ? new ArrayList() : configs;
    }

    public IndividualCacheLoaderConfig getFirstCacheLoaderConfig() {
        if (this.cacheLoaderConfigs.size() == 0) {
            return null;
        }
        return this.cacheLoaderConfigs.get(0);
    }

    public boolean useChainingCacheLoader() {
        return !this.isPassivation() && this.cacheLoaderConfigs.size() > 1;
    }

    public String toString() {
        return "CacheLoaderConfig{" + "shared=" + this.shared + ", passivation=" + this.passivation + ", preload='" + this.preload + '\'' + ", cacheLoaderConfigs.size()=" + this.cacheLoaderConfigs.size() + '}';
    }

    public void setShared(boolean shared) {
        this.testImmutability("shared");
        this.shared = shared;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CacheLoaderConfig) {
            CacheLoaderConfig other = (CacheLoaderConfig)obj;
            return this.passivation == other.passivation && this.shared == other.shared && Util.safeEquals(this.preload, other.preload) && Util.safeEquals(this.cacheLoaderConfigs, other.cacheLoaderConfigs);
        }
        return false;
    }

    public int hashCode() {
        int result = 19;
        result = 51 * result + (this.passivation ? 0 : 1);
        result = 51 * result + (this.shared ? 0 : 1);
        result = 51 * result + (this.preload == null ? 0 : this.preload.hashCode());
        result = 51 * result + (this.cacheLoaderConfigs == null ? 0 : ((Object)this.cacheLoaderConfigs).hashCode());
        return result;
    }

    @Override
    public CacheLoaderConfig clone() throws CloneNotSupportedException {
        CacheLoaderConfig clone = (CacheLoaderConfig)super.clone();
        if (this.cacheLoaderConfigs != null) {
            ArrayList<IndividualCacheLoaderConfig> clcs = new ArrayList<IndividualCacheLoaderConfig>(this.cacheLoaderConfigs.size());
            for (IndividualCacheLoaderConfig clc : this.cacheLoaderConfigs) {
                clcs.add(clc.clone());
            }
            clone.setIndividualCacheLoaderConfigs(clcs);
        }
        return clone;
    }

    public boolean isFetchPersistentState() {
        for (IndividualCacheLoaderConfig iclc : this.cacheLoaderConfigs) {
            if (!iclc.isFetchPersistentState()) continue;
            return true;
        }
        return false;
    }

    public static class IndividualCacheLoaderConfig
    extends PluggableConfigurationComponent {
        private static final long serialVersionUID = -2282396799100828593L;
        private boolean async;
        private boolean ignoreModifications;
        private boolean fetchPersistentState;
        private boolean purgeOnStartup;
        private SingletonStoreConfig singletonStoreConfig;
        private transient CacheLoader cacheLoader;

        protected void populateFromBaseConfig(IndividualCacheLoaderConfig base) {
            if (base != null) {
                this.setAsync(base.isAsync());
                this.setIgnoreModifications(base.isIgnoreModifications());
                this.setFetchPersistentState(base.isFetchPersistentState());
                this.setSingletonStoreConfig(base.getSingletonStoreConfig());
                this.setPurgeOnStartup(base.isPurgeOnStartup());
                this.setProperties(base.getProperties());
            }
        }

        public boolean isPurgeOnStartup() {
            return this.purgeOnStartup;
        }

        public boolean isFetchPersistentState() {
            return this.fetchPersistentState;
        }

        public void setFetchPersistentState(boolean fetchPersistentState) {
            this.testImmutability("fetchPersistentState");
            this.fetchPersistentState = fetchPersistentState;
        }

        public void setAsync(boolean async) {
            this.testImmutability("async");
            this.async = async;
        }

        public boolean isAsync() {
            return this.async;
        }

        public void setIgnoreModifications(boolean ignoreModifications) {
            this.testImmutability("ignoreModifications");
            this.ignoreModifications = ignoreModifications;
        }

        public boolean isIgnoreModifications() {
            return this.ignoreModifications;
        }

        public void setPurgeOnStartup(boolean purgeOnStartup) {
            this.testImmutability("purgeOnStartup");
            this.purgeOnStartup = purgeOnStartup;
        }

        public SingletonStoreConfig getSingletonStoreConfig() {
            return this.singletonStoreConfig;
        }

        public void setSingletonStoreConfig(SingletonStoreConfig singletonStoreConfig) {
            this.testImmutability("singletonStoreConfig");
            this.replaceChildConfig(this.singletonStoreConfig, singletonStoreConfig);
            this.singletonStoreConfig = singletonStoreConfig;
        }

        public CacheLoader getCacheLoader() {
            return this.cacheLoader;
        }

        public void setCacheLoader(CacheLoader cacheLoader) {
            this.cacheLoader = cacheLoader;
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                IndividualCacheLoaderConfig i = (IndividualCacheLoaderConfig)obj;
                return this.equalsExcludingProperties(i);
            }
            return false;
        }

        protected boolean equalsExcludingProperties(Object obj) {
            if (!(obj instanceof IndividualCacheLoaderConfig)) {
                return false;
            }
            IndividualCacheLoaderConfig other = (IndividualCacheLoaderConfig)obj;
            return Util.safeEquals(this.className, other.className) && this.async == other.async && this.ignoreModifications == other.ignoreModifications && this.fetchPersistentState == other.fetchPersistentState && Util.safeEquals(this.singletonStoreConfig, other.singletonStoreConfig);
        }

        public int hashCode() {
            return 31 * this.hashCodeExcludingProperties() + (this.properties == null ? 0 : this.properties.hashCode());
        }

        protected int hashCodeExcludingProperties() {
            int result = 17;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.async ? 0 : 1);
            result = 31 * result + (this.ignoreModifications ? 0 : 1);
            result = 31 * result + (this.fetchPersistentState ? 0 : 1);
            result = 31 * result + (this.singletonStoreConfig == null ? 0 : this.singletonStoreConfig.hashCode());
            result = 31 * result + (this.purgeOnStartup ? 0 : 1);
            return result;
        }

        public String toString() {
            return "IndividualCacheLoaderConfig{" + "className='" + this.className + '\'' + ", async=" + this.async + ", ignoreModifications=" + this.ignoreModifications + ", fetchPersistentState=" + this.fetchPersistentState + ", properties=" + this.properties + ", purgeOnStartup=" + this.purgeOnStartup + "}," + "SingletonStoreConfig{" + this.singletonStoreConfig + '}';
        }

        public IndividualCacheLoaderConfig clone() throws CloneNotSupportedException {
            IndividualCacheLoaderConfig clone = (IndividualCacheLoaderConfig)super.clone();
            if (this.singletonStoreConfig != null) {
                clone.setSingletonStoreConfig(this.singletonStoreConfig.clone());
            }
            clone.cacheLoader = this.cacheLoader;
            return clone;
        }

        public static class SingletonStoreConfig
        extends PluggableConfigurationComponent {
            private static final long serialVersionUID = 824251894176131850L;
            private boolean singletonStoreEnabled;

            public SingletonStoreConfig() {
                this.className = SingletonStoreCacheLoader.class.getName();
            }

            public boolean isSingletonStoreEnabled() {
                return this.singletonStoreEnabled;
            }

            public void setSingletonStoreEnabled(boolean singletonStoreEnabled) {
                this.testImmutability("singletonStoreEnabled");
                this.singletonStoreEnabled = singletonStoreEnabled;
            }

            public String getSingletonStoreClass() {
                return this.className;
            }

            public void setSingletonStoreClass(String className) {
                this.setClassName(className);
            }

            public Properties getSingletonStoreproperties() {
                return this.properties;
            }

            public void setSingletonStoreproperties(Properties properties) {
                this.setProperties(properties);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (super.equals(obj)) {
                    SingletonStoreConfig other = (SingletonStoreConfig)obj;
                    return this.singletonStoreEnabled == other.singletonStoreEnabled;
                }
                return false;
            }

            public int hashCode() {
                int result = 19;
                result = 41 * result + super.hashCode();
                result = 41 * result + (this.singletonStoreEnabled ? 0 : 1);
                return result;
            }

            public String toString() {
                return super.toString() + " enabled=" + this.singletonStoreEnabled + " class=" + this.className + " properties=" + this.properties;
            }

            public SingletonStoreConfig clone() throws CloneNotSupportedException {
                return (SingletonStoreConfig)super.clone();
            }
        }
    }
}

