/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.TimeUnit;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;
import org.jboss.cache.eviction.LRUAlgorithm;

public class LRUAlgorithmConfig
extends EvictionAlgorithmConfigBase {
    private static final long serialVersionUID = -3426716488271559729L;
    @Dynamic
    private long timeToLive = -1L;
    @Dynamic
    private long maxAge = -1L;

    public LRUAlgorithmConfig() {
        this.evictionAlgorithmClassName = LRUAlgorithm.class.getName();
        this.setTimeToLive(-1L);
        this.setMaxAge(-1L);
    }

    public LRUAlgorithmConfig(long timeToLive, long maxAge) {
        this();
        this.timeToLive = timeToLive;
        this.maxAge = maxAge;
    }

    public LRUAlgorithmConfig(long timeToLive, long maxAge, int maxNodes) {
        this(timeToLive, maxAge);
        this.maxNodes = maxNodes;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.testImmutability("timeToLive");
        this.timeToLive = timeToLive;
    }

    public void setTimeToLive(long timeToLive, TimeUnit timeUnit) {
        this.testImmutability("timeToLive");
        this.timeToLive = timeUnit.toMillis(timeToLive);
    }

    @Deprecated
    public void setTimeToLiveSeconds(long time) {
        this.setTimeToLive(time, TimeUnit.SECONDS);
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.testImmutability("maxAge");
        this.maxAge = maxAge;
    }

    public void setMaxAge(long maxAge, TimeUnit timeUnit) {
        this.testImmutability("maxAge");
        this.maxAge = timeUnit.toMillis(maxAge);
    }

    public void validate() throws ConfigurationException {
        super.validate();
        if (this.timeToLive < -1L) {
            this.timeToLive = -1L;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "algorithmClassName=" + this.evictionAlgorithmClassName + ", timeToLive=" + this.timeToLive + ", maxAge=" + this.maxAge + ", minTTL=" + this.minTimeToLive + ", maxNodes=" + this.maxNodes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LRUAlgorithmConfig)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LRUAlgorithmConfig that = (LRUAlgorithmConfig)o;
        if (this.maxAge != that.maxAge) {
            return false;
        }
        return this.timeToLive == that.timeToLive;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.timeToLive ^ this.timeToLive >>> 32);
        result = 31 * result + (int)(this.maxAge ^ this.maxAge >>> 32);
        return result;
    }

    public void reset() {
        super.reset();
        this.setTimeToLive(-1L);
        this.setMaxAge(-1L);
        this.evictionAlgorithmClassName = LRUAlgorithm.class.getName();
    }

    public LRUAlgorithmConfig clone() throws CloneNotSupportedException {
        return (LRUAlgorithmConfig)super.clone();
    }
}

