/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionListEntry;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.EvictionQueueList;
import org.jboss.cache.eviction.NodeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MRUQueue
implements EvictionQueue {
    Map<Fqn, EvictionListEntry> nodeMap = new HashMap<Fqn, EvictionListEntry>();
    EvictionQueueList list = new EvictionQueueList();
    private int numElements = 0;

    protected MRUQueue() {
    }

    protected void moveToTopOfStack(Fqn fqn) {
        EvictionListEntry le = this.nodeMap.remove(fqn);
        if (le != null) {
            this.list.remove(le);
            this.list.addToTop(le);
            this.nodeMap.put(le.node.getFqn(), le);
        }
    }

    @Override
    public NodeEntry getFirstNodeEntry() {
        try {
            return this.list.getFirst().node;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public NodeEntry getNodeEntry(Fqn fqn) {
        EvictionListEntry le = this.nodeMap.get(fqn);
        if (le != null) {
            return le.node;
        }
        return null;
    }

    @Override
    public NodeEntry getNodeEntry(String fqn) {
        return this.getNodeEntry(Fqn.fromString(fqn));
    }

    @Override
    public boolean containsNodeEntry(NodeEntry entry) {
        return this.nodeMap.containsKey(entry.getFqn());
    }

    @Override
    public void removeNodeEntry(NodeEntry entry) {
        EvictionListEntry le = this.nodeMap.remove(entry.getFqn());
        if (le != null) {
            this.list.remove(le);
            this.numElements -= le.node.getNumberOfElements();
        }
    }

    @Override
    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            entry.queue = this;
            EvictionListEntry le = new EvictionListEntry(entry);
            this.list.addToBottom(le);
            this.nodeMap.put(entry.getFqn(), le);
            this.numElements += entry.getNumberOfElements();
        }
    }

    @Override
    public int getNumberOfNodes() {
        return this.list.size();
    }

    @Override
    public int getNumberOfElements() {
        return this.numElements;
    }

    @Override
    public void modifyElementCount(int difference) {
        this.numElements += difference;
    }

    @Override
    public void clear() {
        this.nodeMap.clear();
        this.list.clear();
        this.numElements = 0;
    }

    @Override
    public Iterator<NodeEntry> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        return this.list.toString();
    }
}

