/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.collection.CollectionLoader;
import org.hibernate.loader.collection.OneToManyJoinWalker;
import org.hibernate.persister.collection.QueryableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneToManyLoader
extends CollectionLoader {
    private static final Logger log = LoggerFactory.getLogger((Class)OneToManyLoader.class);

    public OneToManyLoader(QueryableCollection oneToManyPersister, SessionFactoryImplementor session, Map enabledFilters) throws MappingException {
        this(oneToManyPersister, 1, session, enabledFilters);
    }

    public OneToManyLoader(QueryableCollection oneToManyPersister, int batchSize, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        this(oneToManyPersister, batchSize, null, factory, enabledFilters);
    }

    public OneToManyLoader(QueryableCollection oneToManyPersister, int batchSize, String subquery, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        super(oneToManyPersister, factory, enabledFilters);
        OneToManyJoinWalker walker = new OneToManyJoinWalker(oneToManyPersister, batchSize, subquery, factory, enabledFilters);
        this.initFromWalker(walker);
        this.postInstantiate();
        log.debug("Static select for one-to-many " + oneToManyPersister.getRole() + ": " + this.getSQLString());
    }
}

