/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.SpecialOneToOneType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class OneToOne
extends ToOne {
    private boolean constrained;
    private ForeignKeyDirection foreignKeyType;
    private KeyValue identifier;
    private String propertyName;
    private String entityName;

    public OneToOne(Table table, PersistentClass owner) throws MappingException {
        super(table);
        this.identifier = owner.getKey();
        this.entityName = owner.getEntityName();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName == null ? null : propertyName.intern();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String propertyName) {
        this.entityName = this.entityName == null ? null : this.entityName.intern();
    }

    public Type getType() throws MappingException {
        if (this.getColumnIterator().hasNext()) {
            return new SpecialOneToOneType(this.getReferencedEntityName(), this.foreignKeyType, this.referencedPropertyName, this.isLazy(), this.isUnwrapProxy(), this.entityName, this.propertyName);
        }
        return TypeFactory.oneToOne(this.getReferencedEntityName(), this.foreignKeyType, this.referencedPropertyName, this.isLazy(), this.isUnwrapProxy(), this.isEmbedded(), this.entityName, this.propertyName);
    }

    public void createForeignKey() throws MappingException {
        if (this.constrained && this.referencedPropertyName == null) {
            this.createForeignKeyOfEntity(((EntityType)this.getType()).getAssociatedEntityName());
        }
    }

    public List getConstraintColumns() {
        ArrayList list = new ArrayList();
        Iterator iter = this.identifier.getColumnIterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public ForeignKeyDirection getForeignKeyType() {
        return this.foreignKeyType;
    }

    public KeyValue getIdentifier() {
        return this.identifier;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public void setForeignKeyType(ForeignKeyDirection foreignKeyType) {
        this.foreignKeyType = foreignKeyType;
    }

    public void setIdentifier(KeyValue identifier) {
        this.identifier = identifier;
    }

    public boolean isNullable() {
        return !this.constrained;
    }

    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }
}

