/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.collections.map.ReferenceMap;

public class SoftLimitMRUCache
implements Serializable {
    public static final int DEFAULT_STRONG_REF_COUNT = 128;
    private final int strongReferenceCount;
    private transient ReferenceMap softReferenceCache = new ReferenceMap(1, 1);
    private transient LRUMap strongReferenceCache;

    public SoftLimitMRUCache() {
        this(128);
    }

    public SoftLimitMRUCache(int strongRefCount) {
        this.strongReferenceCount = strongRefCount;
        this.init();
    }

    public synchronized Object get(Object key) {
        Object result = this.softReferenceCache.get(key);
        if (result != null) {
            this.strongReferenceCache.put(key, result);
        }
        return result;
    }

    public synchronized Object put(Object key, Object value) {
        this.softReferenceCache.put(key, value);
        return this.strongReferenceCache.put(key, value);
    }

    public synchronized int size() {
        return this.strongReferenceCache.size();
    }

    public synchronized int softSize() {
        return this.softReferenceCache.size();
    }

    private void init() {
        this.strongReferenceCache = new LRUMap(this.strongReferenceCount);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public synchronized void clear() {
        this.strongReferenceCache.clear();
        this.softReferenceCache.clear();
    }
}

