/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.webdav.lib.WebdavResource;
import org.jboss.net.protocol.URLLister;
import org.jboss.net.protocol.URLListerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavURLLister
extends URLListerBase {
    @Override
    public Collection listMembers(URL baseUrl, URLLister.URLFilter filter) throws IOException {
        return this.listMembers(baseUrl, filter, false);
    }

    @Override
    public Collection<URL> listMembers(URL baseUrl, URLLister.URLFilter filter, boolean scanNonDottedSubDirs) throws IOException {
        WebdavResource resource = null;
        try {
            resource = new WebdavResource(baseUrl.toString());
            WebdavResource[] resources = resource.listWebdavResources();
            ArrayList<URL> urls = new ArrayList<URL>(resources.length);
            for (int i = 0; i < resources.length; ++i) {
                WebdavResource member = resources[i];
                HttpURL httpURL = member.getHttpURL();
                if (!filter.accept(baseUrl, httpURL.getName())) continue;
                String uri = httpURL.getURI();
                if (member.isCollection()) {
                    if (!uri.endsWith("/")) {
                        uri = uri + "/";
                    }
                    String path = httpURL.getPath();
                    if (scanNonDottedSubDirs && DavURLLister.getFilePartFromUrl(path).indexOf(".") == -1) {
                        URL subUrl = new URL(uri);
                        urls.addAll(this.listMembers(subUrl, filter, scanNonDottedSubDirs));
                        continue;
                    }
                    urls.add(new URL(uri));
                    continue;
                }
                urls.add(new URL(uri));
            }
            ArrayList<URL> arrayList = urls;
            return arrayList;
        }
        catch (HttpException e) {
            throw new IOException(e.getMessage());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            if (resource != null) {
                resource.close();
            }
        }
    }

    protected static final String getFilePartFromUrl(String name) {
        int length = name.length();
        if (name.charAt(length - 1) == '/') {
            int start = name.lastIndexOf("/", length - 2);
            return name.substring(start, length - 2);
        }
        int start = name.lastIndexOf("/");
        return name.substring(start);
    }
}

