/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.Serializable;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.EventMessage;
import net.sf.ehcache.distribution.RMISynchronousCacheReplicator;

public class RMIAsynchronousCacheReplicator
extends RMISynchronousCacheReplicator {
    private static final Logger LOG = Logger.getLogger(RMIAsynchronousCacheReplicator.class.getName());
    protected Thread replicationThread = new ReplicationThread();
    protected int asynchronousReplicationInterval;
    protected final List replicationQueue = new LinkedList();

    public RMIAsynchronousCacheReplicator(boolean replicatePuts, boolean replicatePutsViaCopy, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals, int asynchronousReplicationInterval) {
        super(replicatePuts, replicatePutsViaCopy, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals);
        this.asynchronousReplicationInterval = asynchronousReplicationInterval;
        this.status = Status.STATUS_ALIVE;
        this.replicationThread.start();
    }

    private void replicationThreadMain() {
        while (true) {
            if (this.alive() && this.replicationQueue != null && this.replicationQueue.size() == 0) {
                try {
                    Thread.sleep(this.asynchronousReplicationInterval);
                }
                catch (InterruptedException e) {
                    LOG.log(Level.FINE, "Spool Thread interrupted.");
                    return;
                }
            }
            if (this.notAlive()) {
                return;
            }
            try {
                if (this.replicationQueue.size() == 0) continue;
                this.flushReplicationQueue();
                continue;
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Exception on flushing of replication queue: " + e.getMessage() + ". Continuing...", e);
                continue;
            }
            break;
        }
    }

    public final void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicatePuts) {
            return;
        }
        if (this.replicatePutsViaCopy) {
            if (!element.isSerializable()) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Object with key " + element.getObjectKey() + " is not Serializable and cannot be replicated.");
                }
                return;
            }
            this.addToReplicationQueue(new CacheEventMessage(0, cache, element, null));
        } else {
            if (!element.isKeySerializable()) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Object with key " + element.getObjectKey() + " does not have a Serializable key and cannot be replicated via invalidate.");
                }
                return;
            }
            this.addToReplicationQueue(new CacheEventMessage(1, cache, null, element.getKey()));
        }
    }

    public final void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateUpdates) {
            return;
        }
        if (this.replicateUpdatesViaCopy) {
            if (!element.isSerializable()) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Object with key " + element.getObjectKey() + " is not Serializable and cannot be updated via copy.");
                }
                return;
            }
            this.addToReplicationQueue(new CacheEventMessage(0, cache, element, null));
        } else {
            if (!element.isKeySerializable()) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Object with key " + element.getObjectKey() + " does not have a Serializable key and cannot be replicated via invalidate.");
                }
                return;
            }
            this.addToReplicationQueue(new CacheEventMessage(1, cache, null, element.getKey()));
        }
    }

    public final void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        if (!element.isKeySerializable()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Key " + element.getObjectKey() + " is not Serializable and cannot be replicated.");
            }
            return;
        }
        this.addToReplicationQueue(new CacheEventMessage(1, cache, null, element.getKey()));
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        this.addToReplicationQueue(new CacheEventMessage(3, cache, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToReplicationQueue(CacheEventMessage cacheEventMessage) {
        if (!this.replicationThread.isAlive()) {
            LOG.log(Level.SEVERE, "CacheEventMessages cannot be added to the replication queue because the replication thread has died.");
        } else {
            List list = this.replicationQueue;
            synchronized (list) {
                this.replicationQueue.add(cacheEventMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushReplicationQueue() {
        int eventMessagesNotResolved;
        ArrayList replicationQueueCopy;
        List list = this.replicationQueue;
        synchronized (list) {
            if (this.replicationQueue.size() == 0) {
                return;
            }
            replicationQueueCopy = new ArrayList(this.replicationQueue);
            this.replicationQueue.clear();
        }
        Ehcache cache = ((CacheEventMessage)replicationQueueCopy.get(0)).cache;
        List cachePeers = RMIAsynchronousCacheReplicator.listRemoteCachePeers(cache);
        List resolvedEventMessages = RMIAsynchronousCacheReplicator.extractAndResolveEventMessages(replicationQueueCopy);
        for (int j = 0; j < cachePeers.size(); ++j) {
            CachePeer cachePeer = (CachePeer)cachePeers.get(j);
            try {
                cachePeer.send(resolvedEventMessages);
                continue;
            }
            catch (UnmarshalException e) {
                String message = e.getMessage();
                if (message.indexOf("Read time out") != 0) {
                    LOG.log(Level.WARNING, "Unable to send message to remote peer due to socket read timeout. Consider increasing the socketTimeoutMillis setting in the cacheManagerPeerListenerFactory. Message was: " + e.getMessage());
                    continue;
                }
                LOG.log(Level.FINE, "Unable to send message to remote peer.  Message was: " + e.getMessage());
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Unable to send message to remote peer.  Message was: " + t.getMessage(), t);
            }
        }
        if (LOG.isLoggable(Level.WARNING) && (eventMessagesNotResolved = replicationQueueCopy.size() - resolvedEventMessages.size()) > 0) {
            LOG.log(Level.WARNING, eventMessagesNotResolved + " messages were discarded on replicate due to reclamation of " + "SoftReferences by the VM. Consider increasing the maximum heap size and/or setting the " + "starting heap size to a higher value.");
        }
    }

    private static List extractAndResolveEventMessages(List replicationQueueCopy) {
        ArrayList<EventMessage> list = new ArrayList<EventMessage>();
        for (int i = 0; i < replicationQueueCopy.size(); ++i) {
            EventMessage eventMessage = ((CacheEventMessage)replicationQueueCopy.get(i)).getEventMessage();
            if (eventMessage == null || !eventMessage.isValid()) continue;
            list.add(eventMessage);
        }
        return list;
    }

    public final void dispose() {
        this.status = Status.STATUS_SHUTDOWN;
        this.flushReplicationQueue();
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        return new RMIAsynchronousCacheReplicator(this.replicatePuts, this.replicatePutsViaCopy, this.replicateUpdates, this.replicateUpdatesViaCopy, this.replicateRemovals, this.asynchronousReplicationInterval);
    }

    private static class CacheEventMessage {
        private final Ehcache cache;
        private final EventMessage eventMessage;

        public CacheEventMessage(int event, Ehcache cache, Element element, Serializable key) {
            this.eventMessage = new EventMessage(event, key, element);
            this.cache = cache;
        }

        public final EventMessage getEventMessage() {
            return this.eventMessage;
        }
    }

    private final class ReplicationThread
    extends Thread {
        public ReplicationThread() {
            super("Replication Thread");
            this.setDaemon(true);
            this.setPriority(5);
        }

        public final void run() {
            RMIAsynchronousCacheReplicator.this.replicationThreadMain();
        }
    }
}

