/*
 * Decompiled with CFR 0.152.
 */
package org.drools.pmml.pmml_4_2.global;

import java.util.Collection;
import org.drools.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;

public class ConstrainedDataDictionaryTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = false;
    private static final String source = "org/drools/pmml/pmml_4_2/test_constr_data_dic.xml";
    private static final String packageName = "org.drools.pmml.pmml_4_2.test";

    @Before
    public void setUp() throws Exception {
        this.setKSession(this.getModelSession(source, false));
        this.setKbase(this.getKSession().getKieBase());
    }

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testContinuousDomainIntervals() throws Exception {
        FactType ivals = this.getKbase().getFactType(packageName, "Intervalled");
        Assert.assertNotNull((Object)ivals);
        Object data1 = ivals.newInstance();
        ivals.set(data1, "value", (Object)-0.4);
        Object data2 = ivals.newInstance();
        ivals.set(data2, "value", (Object)0.3);
        Object data3 = ivals.newInstance();
        ivals.set(data3, "value", (Object)1.6);
        Object data4 = ivals.newInstance();
        ivals.set(data4, "value", (Object)2.0);
        Object data5 = ivals.newInstance();
        ivals.set(data5, "value", (Object)3.0);
        Object data6 = ivals.newInstance();
        ivals.set(data6, "value", (Object)8.2);
        Object data7 = ivals.newInstance();
        ivals.set(data7, "value", (Object)12.4);
        Object data8 = ivals.newInstance();
        ivals.set(data8, "value", (Object)999.9);
        this.getKSession().insert(data1);
        this.getKSession().insert(data2);
        this.getKSession().insert(data3);
        this.getKSession().insert(data4);
        this.getKSession().insert(data5);
        this.getKSession().insert(data6);
        this.getKSession().insert(data7);
        this.getKSession().insert(data8);
        this.getKSession().fireAllRules();
        Assert.assertEquals((Object)false, (Object)ivals.get(data1, "valid"));
        Assert.assertEquals((Object)true, (Object)ivals.get(data2, "valid"));
        Assert.assertEquals((Object)false, (Object)ivals.get(data3, "valid"));
        Assert.assertEquals((Object)true, (Object)ivals.get(data4, "valid"));
        Assert.assertEquals((Object)false, (Object)ivals.get(data5, "valid"));
        Assert.assertEquals((Object)false, (Object)ivals.get(data6, "valid"));
        Assert.assertEquals((Object)true, (Object)ivals.get(data7, "valid"));
        Assert.assertEquals((Object)false, (Object)ivals.get(data8, "valid"));
        this.checkGeneratedRules();
    }

    @Test
    public void testProperties() throws Exception {
        this.getKSession().getEntryPoint("in_Vallued").insert((Object)1);
        this.getKSession().getEntryPoint("in_Intervalled").insert((Object)8.3);
        this.getKSession().getEntryPoint("in_Cat").insert((Object)"aa");
        this.getKSession().getEntryPoint("in_Sort").insert((Object)1);
        this.getKSession().fireAllRules();
        Collection fact1 = this.getKSession().getFactHandles((ObjectFilter)new ClassObjectFilter(this.getKbase().getFactType(packageName, "Vallued").getFactClass()));
        Assert.assertEquals((long)1L, (long)fact1.size());
        Collection fact2 = this.getKSession().getFactHandles((ObjectFilter)new ClassObjectFilter(this.getKbase().getFactType(packageName, "Intervalled").getFactClass()));
        Assert.assertEquals((long)1L, (long)fact2.size());
        Collection fact3 = this.getKSession().getFactHandles((ObjectFilter)new ClassObjectFilter(this.getKbase().getFactType(packageName, "Cat").getFactClass()));
        Assert.assertEquals((long)1L, (long)fact3.size());
        Collection fact4 = this.getKSession().getFactHandles((ObjectFilter)new ClassObjectFilter(this.getKbase().getFactType(packageName, "Sort").getFactClass()));
        Assert.assertEquals((long)1L, (long)fact4.size());
        this.checkGeneratedRules();
    }

    @Test
    public void testContinuousDomainValues() throws Exception {
        FactType vals = this.getKbase().getFactType(packageName, "Vallued");
        Assert.assertNotNull((Object)vals);
        Object data1 = vals.newInstance();
        vals.set(data1, "value", (Object)1);
        Object data2 = vals.newInstance();
        vals.set(data2, "value", (Object)2);
        Object data3 = vals.newInstance();
        vals.set(data3, "value", (Object)3);
        Object data0 = vals.newInstance();
        vals.set(data0, "value", (Object)0);
        Object data99 = vals.newInstance();
        vals.set(data99, "value", (Object)-1);
        this.getKSession().insert(data1);
        this.getKSession().insert(data2);
        this.getKSession().insert(data3);
        this.getKSession().insert(data0);
        this.getKSession().insert(data99);
        this.getKSession().fireAllRules();
        Assert.assertEquals((Object)true, (Object)vals.get(data1, "valid"));
        Assert.assertEquals((Object)false, (Object)vals.get(data1, "missing"));
        Assert.assertEquals((Object)true, (Object)vals.get(data2, "valid"));
        Assert.assertEquals((Object)false, (Object)vals.get(data2, "missing"));
        Assert.assertEquals((Object)false, (Object)vals.get(data3, "valid"));
        Assert.assertEquals((Object)false, (Object)vals.get(data3, "missing"));
        Assert.assertEquals((Object)false, (Object)vals.get(data0, "valid"));
        Assert.assertEquals((Object)true, (Object)vals.get(data0, "missing"));
        Assert.assertEquals((Object)false, (Object)vals.get(data99, "valid"));
        Assert.assertEquals((Object)false, (Object)vals.get(data99, "missing"));
        this.checkGeneratedRules();
    }

    @Test
    public void testContinuousDomainAsInsert() throws Exception {
        this.getKSession().getEntryPoint("in_Vallued").insert((Object)1);
        this.getKSession().getEntryPoint("in_Intervalled").insert((Object)8.3);
        this.getKSession().getEntryPoint("in_DefaultValid").insert((Object)1);
        this.getKSession().getEntryPoint("in_DefaultInvalid").insert((Object)1);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Vallued"), true, false, null, 1);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "Intervalled"), false, false, null, 8.3);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "DefaultValid"), true, false, null, 1);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "DefaultInvalid"), false, false, null, 1);
        this.checkGeneratedRules();
    }
}

