/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.util.Collection;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.reliability.core.StorageManagerFactory;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.ReliabilityTestBasics;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.Option;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.test.domain.Person;

@ExtendWith(value={BeforeAllMethodExtension.class})
class CachePersistenceTest
extends ReliabilityTestBasics {
    private static final String EMPTY_RULE = "global java.util.List results;\nrule R when\nthen\nend";

    CachePersistenceTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void removeAllSessionCaches_shouldRemoveAllSessionCachesEvenAfterFailover(PersistedSessionOption.PersistenceStrategy strategy) {
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 10);
        this.failover();
        Assertions.assertThat((Collection)StorageManagerFactory.get().getStorageManager().getStorageNames()).contains((Object[])new String[]{"session_0_epDEFAULT", "session_0_globals"});
        StorageManagerFactory.get().getStorageManager().removeAllSessionStorages();
        this.restoreSession(EMPTY_RULE, strategy, new Option[0]);
        Optional<Person> toshiya = this.getPersonByName("Toshiya");
        Assertions.assertThat(toshiya).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void ksessionDispose_shouldRemoveCache(PersistedSessionOption.PersistenceStrategy strategy) {
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        long sessionId = this.getSessionIdentifier();
        this.insertNonMatchingPerson("Toshiya", 10);
        this.disposeSession();
        Assertions.assertThat((Collection)StorageManagerFactory.get().getStorageManager().getStorageNames()).allMatch(name -> !name.startsWith("session_" + sessionId));
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void missingDispose_shouldNotReuseOrphanedCache(PersistedSessionOption.PersistenceStrategy strategy) {
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 10);
        this.failover();
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        Optional<Person> toshiya = this.getPersonByName("Toshiya");
        Assertions.assertThat(toshiya).isEmpty();
        this.failover();
        this.restoreSession(EMPTY_RULE, strategy, new Option[0]);
        toshiya = this.getPersonByName("Toshiya");
        Assertions.assertThat(toshiya).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnly"})
    void reliableSessionCounter_shouldNotHaveTheSameIdAsPreviousKsession(PersistedSessionOption.PersistenceStrategy strategy) {
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        long firstSessionId = this.getSessionIdentifier();
        this.failover();
        this.createSession(EMPTY_RULE, strategy, new Option[0]);
        long secondSessionId = this.getSessionIdentifier();
        Assertions.assertThat((long)secondSessionId).isNotEqualTo(firstSessionId);
    }
}

