/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.core.api.Assertions;
import org.drools.reliability.core.StorageManagerFactory;
import org.drools.reliability.core.TestableStorageManager;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.InfinispanStorageManager;
import org.drools.util.Config;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.extension.ExtendWith;

@DisabledIf(value="isRemote")
@ExtendWith(value={BeforeAllMethodExtension.class})
class EmbeddedStorageManagerTest {
    EmbeddedStorageManagerTest() {
    }

    @AfterEach
    public void tearDown() {
        ((TestableStorageManager)StorageManagerFactory.get().getStorageManager()).restart();
    }

    private static boolean isRemote() {
        return "REMOTE".equalsIgnoreCase(Config.getConfig((String)"drools.reliability.storage.infinispan.mode"));
    }

    @Test
    void removeAllSessionCaches_shouldLeaveNonSessionCache() {
        ((InfinispanStorageManager)StorageManagerFactory.get().getStorageManager()).setEmbeddedCacheManager((DefaultCacheManager)new FakeCacheManager());
        Assertions.assertThat((Collection)StorageManagerFactory.get().getStorageManager().getStorageNames()).containsExactlyInAnyOrder((Object[])new String[]{"session_0_epDefault", "session_1_epDefault", "METADATA_0"});
        StorageManagerFactory.get().getStorageManager().removeAllSessionStorages();
        Assertions.assertThat((Collection)StorageManagerFactory.get().getStorageManager().getStorageNames()).containsExactly((Object[])new String[]{"METADATA_0"});
    }

    @Test
    void removeCachesBySessionId_shouldRemoveSpecifiedCacheOnly() {
        ((InfinispanStorageManager)StorageManagerFactory.get().getStorageManager()).setEmbeddedCacheManager((DefaultCacheManager)new FakeCacheManager());
        Assertions.assertThat((Collection)StorageManagerFactory.get().getStorageManager().getStorageNames()).containsExactlyInAnyOrder((Object[])new String[]{"session_0_epDefault", "session_1_epDefault", "METADATA_0"});
        StorageManagerFactory.get().getStorageManager().removeStoragesBySessionId("1");
        Assertions.assertThat((Collection)StorageManagerFactory.get().getStorageManager().getStorageNames()).containsExactlyInAnyOrder((Object[])new String[]{"session_0_epDefault", "METADATA_0"});
    }

    static {
        System.setProperty("drools.reliability.storage.infinispan.allowedpackages", "org.test.domain");
    }

    public static class FakeCacheManager
    extends DefaultCacheManager {
        private Map<String, Object> cacheMap = new ConcurrentHashMap<String, Object>();

        public FakeCacheManager() {
            this.cacheMap.put("session_0_epDefault", new Object());
            this.cacheMap.put("session_1_epDefault", new Object());
            this.cacheMap.put("METADATA_0", new Object());
        }

        public Set<String> getCacheNames() {
            return this.cacheMap.keySet();
        }

        public boolean cacheExists(String cacheName) {
            return this.cacheMap.containsKey(cacheName);
        }

        public void removeCache(String cacheName) {
            this.cacheMap.remove(cacheName);
        }

        public void stop() {
        }
    }
}

