/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.base.facttemplates.Event;
import org.drools.core.base.accumulators.CollectListAccumulateFunction;
import org.drools.model.Argument;
import org.drools.model.ConstraintOperator;
import org.drools.model.DSL;
import org.drools.model.Declaration;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.Index;
import org.drools.model.Model;
import org.drools.model.PatternDSL;
import org.drools.model.Prototype;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeExpression;
import org.drools.model.PrototypeVariable;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.functions.Block2;
import org.drools.model.functions.Block3;
import org.drools.model.functions.Block4;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.impl.ModelImpl;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.drools.modelcompiler.facttemplate.FactFactory;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.ReliabilityTestBasics;
import org.drools.reliability.infinispan.util.PrototypeUtils;
import org.drools.reliability.infinispan.util.TimeAmount;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.Option;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.PersistedSessionOption;

@DisabledIf(value="isProtoStream")
@ExtendWith(value={BeforeAllMethodExtension.class})
class ReliabilityCepOnceAfterTest
extends ReliabilityTestBasics {
    public static final String KEYWORD = "once_after";
    public static final String RULE_NAME = "R";

    ReliabilityCepOnceAfterTest() {
    }

    private Model ruleModel() {
        Prototype controlPrototype = PrototypeUtils.getPrototype("DROOLS_SYNTHETIC_PROTOTYPE");
        PrototypeVariable controlVar1 = PrototypeDSL.variable((Prototype)controlPrototype, (String)"c1");
        PrototypeVariable controlVar2 = PrototypeDSL.variable((Prototype)controlPrototype, (String)"c2");
        PrototypeVariable controlVar3 = PrototypeDSL.variable((Prototype)controlPrototype, (String)"c3");
        Declaration resultsVar = DSL.declarationOf(List.class, (String)"results");
        Global global = DSL.globalOf(List.class, (String)"defaultpkg", (String)"results");
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(PatternDSL.rule((String)RULE_NAME).metadata("RULE_TYPE", (Object)KEYWORD).build(new RuleItemBuilder[]{PrototypeDSL.protoPattern((PrototypeVariable)controlVar1).expr("end_once_after", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)RULE_NAME), DSL.not((ViewItemBuilder)PrototypeDSL.protoPattern((PrototypeVariable)controlVar2).expr("start_once_after", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)RULE_NAME), (ViewItemBuilder[])new ViewItemBuilder[0]), DSL.accumulate((ViewItem)PrototypeDSL.protoPattern((PrototypeVariable)controlVar3).expr("drools_rule_name", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)RULE_NAME), (AccumulateFunction)DSL.accFunction(CollectListAccumulateFunction::new, (Argument)controlVar3).as((Variable)resultsVar), (AccumulateFunction[])new AccumulateFunction[0]), DSL.on((Variable)controlVar1, (Variable)resultsVar, (Variable)global).execute((Block4 & Serializable)(drools, controlFact, resultFactList, globalResults) -> {
            drools.delete(controlFact);
            PrototypeUtils.processResults(globalResults, resultFactList);
            resultFactList.forEach(arg_0 -> ((Drools)drools).delete(arg_0));
        })}));
        PrototypeVariable originalEventVariable = PrototypeDSL.variable((Prototype)PrototypeUtils.getPrototype("DROOLS_PROTOTYPE"), (String)"m");
        rules.add(PatternDSL.rule((String)"R_control").metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{ReliabilityCepOnceAfterTest.guardedPattern(originalEventVariable), DSL.not((ViewItemBuilder)ReliabilityCepOnceAfterTest.duplicateControlPattern(originalEventVariable), (ViewItemBuilder[])new ViewItemBuilder[0]), DSL.on((Variable)originalEventVariable).execute((Block2 & Serializable)(drools, event) -> {
            Event controlEvent = FactFactory.createMapBasedEvent((Prototype)controlPrototype);
            controlEvent.set("sensu.host", event.get("sensu.host"));
            controlEvent.set("sensu.process.type", event.get("sensu.process.type"));
            controlEvent.set("drools_rule_name", (Object)RULE_NAME);
            controlEvent.set("event", event);
            controlEvent.set("once_after_time_window", (Object)"10 minutes");
            controlEvent.set("events_in_window", (Object)1);
            drools.insert((Object)controlEvent);
            drools.delete(event);
        })}));
        TimeAmount timeAmount = TimeAmount.parseTimeAmount("10 minutes");
        rules.add(PatternDSL.rule((String)"R_start").metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{PrototypeDSL.protoPattern((PrototypeVariable)controlVar1).expr("drools_rule_name", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)RULE_NAME), DSL.not((ViewItemBuilder)PrototypeDSL.protoPattern((PrototypeVariable)controlVar2).expr("end_once_after", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)RULE_NAME), (ViewItemBuilder[])new ViewItemBuilder[0]), DSL.on((Variable)controlVar1).execute((Block2 & Serializable)(drools, c1) -> {
            Event startControlEvent = FactFactory.createMapBasedEvent((Prototype)controlPrototype).withExpiration((long)timeAmount.getAmount(), timeAmount.getTimeUnit());
            startControlEvent.set("start_once_after", (Object)RULE_NAME);
            drools.insert((Object)startControlEvent);
            Event endControlEvent = FactFactory.createMapBasedEvent((Prototype)controlPrototype);
            endControlEvent.set("end_once_after", (Object)RULE_NAME);
            drools.insert((Object)endControlEvent);
        })}));
        PrototypeDSL.PrototypePatternDef duplicateControlPattern = ReliabilityCepOnceAfterTest.duplicateControlPattern(originalEventVariable);
        rules.add(PatternDSL.rule((String)"R_cleanup_duplicate").metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{ReliabilityCepOnceAfterTest.guardedPattern(originalEventVariable), duplicateControlPattern, DSL.on((Variable)originalEventVariable, (Variable)duplicateControlPattern.getFirstVariable()).execute((Block3 & Serializable)(drools, event, control) -> {
            control.set("events_in_window", (Object)((Integer)control.get("events_in_window") + 1));
            drools.delete(event);
        })}));
        return new ModelImpl().withRules(rules).addGlobal(global);
    }

    private static PrototypeDSL.PrototypePatternDef guardedPattern(PrototypeVariable originalEventVariable) {
        return PrototypeDSL.protoPattern((PrototypeVariable)originalEventVariable).expr(PrototypeExpression.prototypeField((String)"sensu.process.type"), (ConstraintOperator)Index.ConstraintType.EQUAL, PrototypeExpression.fixedValue((Object)"alert"));
    }

    private static PrototypeDSL.PrototypePatternDef duplicateControlPattern(PrototypeVariable originalEventVariable) {
        return PrototypeDSL.protoPattern((PrototypeVariable)PrototypeDSL.variable((Prototype)PrototypeUtils.getPrototype("DROOLS_SYNTHETIC_PROTOTYPE"))).expr(PrototypeExpression.prototypeField((String)"sensu.host"), (ConstraintOperator)Index.ConstraintType.EQUAL, originalEventVariable, PrototypeExpression.prototypeField((String)"sensu.host")).expr(PrototypeExpression.prototypeField((String)"sensu.process.type"), (ConstraintOperator)Index.ConstraintType.EQUAL, originalEventVariable, PrototypeExpression.prototypeField((String)"sensu.process.type")).expr(PrototypeExpression.prototypeField((String)"drools_rule_name"), (ConstraintOperator)Index.ConstraintType.EQUAL, PrototypeExpression.fixedValue((Object)RULE_NAME));
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertFailoverAdvanceFire_shouldRecoverFromFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuEvent("host1", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertNonMatchingSensuEvent("host1", "info");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingSensuEvent("host2", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingSensuEvent("host1", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("once_after is 10 minutes window. The main rule should not be fired yet", new Object[0])).isEmpty();
        this.failover();
        this.restoreSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.advanceTimeAndFire(7L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("10 minutes window is over. The result should be collected", new Object[0])).hasSize(2);
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertAdvanceFailoverFire_shouldRecoverFromFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuEvent("host1", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertNonMatchingSensuEvent("host1", "info");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingSensuEvent("host2", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingSensuEvent("host1", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("once_after is 10 minutes window. The main rule should not be fired yet", new Object[0])).isEmpty();
        this.advanceTime(7L, TimeUnit.MINUTES);
        this.failover();
        this.restoreSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.getResults()).as("10 minutes window is over. The result should be collected", new Object[0])).hasSize(2);
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertAdvanceInsertFailoverFire_shouldRecoverFromFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuEvent("host1", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertNonMatchingSensuEvent("host1", "info");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingSensuEvent("host2", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("once_after is 10 minutes window. The main rule should not be fired yet", new Object[0])).isEmpty();
        this.advanceTime(8L, TimeUnit.MINUTES);
        this.insertMatchingSensuEvent("host3", "alert");
        this.insertMatchingSensuEvent("host4", "alert");
        this.insertMatchingSensuEvent("host5", "alert");
        this.insertMatchingSensuEvent("host6", "alert");
        this.failover();
        this.restoreSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.getResults()).as("2 is the normally expected result size, but in this edge case, 6 events are collected", new Object[0])).hasSize(6);
    }
}

