/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.drools.base.facttemplates.Event;
import org.drools.model.ConstraintOperator;
import org.drools.model.DSL;
import org.drools.model.DroolsEntryPoint;
import org.drools.model.Global;
import org.drools.model.Index;
import org.drools.model.Model;
import org.drools.model.PatternDSL;
import org.drools.model.Prototype;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeExpression;
import org.drools.model.PrototypeVariable;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.functions.Block3;
import org.drools.model.impl.ModelImpl;
import org.drools.model.view.ViewItemBuilder;
import org.drools.modelcompiler.facttemplate.FactFactory;
import org.drools.modelcompiler.facttemplate.HashMapEventImpl;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.ReliabilityTestBasics;
import org.drools.reliability.infinispan.util.PrototypeUtils;
import org.drools.reliability.infinispan.util.TimeAmount;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.Option;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.PersistedSessionOption;

@DisabledIf(value="isProtoStream")
@ExtendWith(value={BeforeAllMethodExtension.class})
class ReliabilityCepOnceWithinTest
extends ReliabilityTestBasics {
    public static final String KEYWORD = "once_within";
    public static final String RULE_NAME = "R";

    ReliabilityCepOnceWithinTest() {
    }

    private Model ruleModel() {
        Prototype controlPrototype = PrototypeUtils.getPrototype("DROOLS_SYNTHETIC_PROTOTYPE");
        Global global = DSL.globalOf(List.class, (String)"defaultpkg", (String)"results");
        ArrayList<Rule> rules = new ArrayList<Rule>();
        TimeAmount timeAmount = TimeAmount.parseTimeAmount("10 minutes");
        PrototypeVariable originalEventVariable = PrototypeDSL.variable((Prototype)PrototypeUtils.getPrototype("DROOLS_PROTOTYPE"), (String)"m");
        rules.add(PatternDSL.rule((String)RULE_NAME).metadata("RULE_TYPE", (Object)KEYWORD).build(new RuleItemBuilder[]{ReliabilityCepOnceWithinTest.guardedPattern(originalEventVariable), DSL.not((ViewItemBuilder)ReliabilityCepOnceWithinTest.duplicateControlPattern(originalEventVariable), (ViewItemBuilder[])new ViewItemBuilder[0]), DSL.on((Variable)originalEventVariable, (Variable)global).execute((Block3 & Serializable)(drools, event, globalResults) -> {
            Event controlEvent = FactFactory.createMapBasedEvent((Prototype)controlPrototype).withExpiration((long)timeAmount.getAmount(), timeAmount.getTimeUnit());
            controlEvent.set("sensu.host", event.get("sensu.host"));
            controlEvent.set("sensu.process.type", event.get("sensu.process.type"));
            controlEvent.set("drools_rule_name", (Object)RULE_NAME);
            drools.insert((Object)controlEvent);
            globalResults.add(event);
            drools.delete(event);
        })}));
        rules.add(PatternDSL.rule((String)"cleanup_R").metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{ReliabilityCepOnceWithinTest.guardedPattern(originalEventVariable), ReliabilityCepOnceWithinTest.duplicateControlPattern(originalEventVariable), DSL.on((Variable)originalEventVariable).execute(DroolsEntryPoint::delete)}));
        return new ModelImpl().withRules(rules).addGlobal(global);
    }

    private static PrototypeDSL.PrototypePatternDef guardedPattern(PrototypeVariable originalEventVariable) {
        return PrototypeDSL.protoPattern((PrototypeVariable)originalEventVariable).expr(PrototypeExpression.prototypeField((String)"sensu.process.type"), (ConstraintOperator)Index.ConstraintType.EQUAL, PrototypeExpression.fixedValue((Object)"alert"));
    }

    private static PrototypeDSL.PrototypePatternDef duplicateControlPattern(PrototypeVariable originalEventVariable) {
        return PrototypeDSL.protoPattern((PrototypeVariable)PrototypeDSL.variable((Prototype)PrototypeUtils.getPrototype("DROOLS_SYNTHETIC_PROTOTYPE"))).expr(PrototypeExpression.prototypeField((String)"sensu.host"), (ConstraintOperator)Index.ConstraintType.EQUAL, originalEventVariable, PrototypeExpression.prototypeField((String)"sensu.host")).expr(PrototypeExpression.prototypeField((String)"sensu.process.type"), (ConstraintOperator)Index.ConstraintType.EQUAL, originalEventVariable, PrototypeExpression.prototypeField((String)"sensu.process.type")).expr(PrototypeExpression.prototypeField((String)"drools_rule_name"), (ConstraintOperator)Index.ConstraintType.EQUAL, PrototypeExpression.fixedValue((Object)RULE_NAME));
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertFailoverExpireFire_shouldCollectEventAfterWindow(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuEvent("host1", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertNonMatchingSensuEvent("host1", "info");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingSensuEvent("host2", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingSensuEvent("host1", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("once_within is 10 minutes window. 2 events should be collected", new Object[0])).hasSize(2);
        this.failover();
        this.restoreSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuEvent("host1", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("once_within is 10 minutes window. 2 events should be collected", new Object[0])).hasSize(2);
        this.advanceTimeAndFire(10L, TimeUnit.MINUTES);
        this.insertMatchingSensuEvent("host1", "alert");
        this.fireAllRules();
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat(this.getResults()).as("after 10 minutes window. 3 events should be collected", new Object[0])).hasSize(3)).allMatch(event -> event instanceof HashMapEventImpl)).extracting(new Function[]{event -> ((HashMapEventImpl)event).get("sensu.host"), event -> ((HashMapEventImpl)event).get("sensu.process.type")}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"host1", "alert"}), Tuple.tuple((Object[])new Object[]{"host2", "alert"}), Tuple.tuple((Object[])new Object[]{"host1", "alert"})});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertExpireFailoverFire_shouldCollectEventAfterWindow(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuEvent("host1", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertNonMatchingSensuEvent("host1", "info");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingSensuEvent("host2", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingSensuEvent("host1", "alert");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("once_within is 10 minutes window. 2 events should be collected", new Object[0])).hasSize(2);
        this.advanceTime(10L, TimeUnit.MINUTES);
        this.failover();
        this.restoreSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuEvent("host1", "alert");
        this.fireAllRules();
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat(this.getResults()).as("after 10 minutes window. 3 events should be collected", new Object[0])).hasSize(3)).allMatch(event -> event instanceof HashMapEventImpl)).extracting(new Function[]{event -> ((HashMapEventImpl)event).get("sensu.host"), event -> ((HashMapEventImpl)event).get("sensu.process.type")}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"host1", "alert"}), Tuple.tuple((Object[])new Object[]{"host2", "alert"}), Tuple.tuple((Object[])new Object[]{"host1", "alert"})});
    }
}

