/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.ReliabilityTestBasics;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.Option;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.time.SessionPseudoClock;
import org.test.domain.StockTick;

@DisabledIf(value="isProtoStream")
@ExtendWith(value={BeforeAllMethodExtension.class})
class ReliabilityCepTest
extends ReliabilityTestBasics {
    private static final String CEP_RULE = "import " + StockTick.class.getCanonicalName() + ";global java.util.List results;rule R when\n    $a : StockTick( company == \"DROO\" )\n    $b : StockTick( company == \"ACME\", this after[5s,8s] $a )\nthen\n    results.add(\"fired\");\nend\n";

    ReliabilityCepTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertAdvanceInsertFailoverFire_shouldRecoverFromFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(CEP_RULE, persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        SessionPseudoClock clock = this.getSessionClock();
        this.insert(new StockTick("DROO"));
        clock.advanceTime(6L, TimeUnit.SECONDS);
        this.insert(new StockTick("ACME"));
        this.failover();
        this.restoreSession(CEP_RULE, persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        clock = this.getSessionClock();
        Assertions.assertThat((int)this.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"fired"});
        this.clearResults();
        clock.advanceTime(1L, TimeUnit.SECONDS);
        this.insert(new StockTick("ACME"));
        Assertions.assertThat((int)this.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"fired"});
        this.clearResults();
        clock.advanceTime(3L, TimeUnit.SECONDS);
        this.insert(new StockTick("ACME"));
        Assertions.assertThat((int)this.fireAllRules()).isZero();
        Assertions.assertThat(this.getResults()).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertAdvanceFailoverExpireFire_shouldExpireAfterFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(CEP_RULE, persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        SessionPseudoClock clock = this.getSessionClock();
        this.insert(new StockTick("DROO"));
        clock.advanceTime(6L, TimeUnit.SECONDS);
        this.insert(new StockTick("ACME"));
        this.failover();
        this.restoreSession(CEP_RULE, persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        clock = this.getSessionClock();
        clock.advanceTime(58L, TimeUnit.SECONDS);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.fireAllRules()).as("DROO is expired, but a match is available.", new Object[0])).isEqualTo(1);
        ((AbstractCollectionAssert)Assertions.assertThat(this.getFactHandles()).as("DROO should have expired because @Expires = 60s", new Object[0])).hasSize(1);
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertAdvanceFireFailoverExpire_shouldExpireAfterFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(CEP_RULE, persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        SessionPseudoClock clock = this.getSessionClock();
        this.insert(new StockTick("DROO"));
        clock.advanceTime(6L, TimeUnit.SECONDS);
        this.insert(new StockTick("ACME"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.fireAllRules()).as("DROO is expired, but a match is available.", new Object[0])).isEqualTo(1);
        this.failover();
        this.restoreSession(CEP_RULE, persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        clock = this.getSessionClock();
        clock.advanceTime(58L, TimeUnit.SECONDS);
        this.fireAllRules();
        ((AbstractCollectionAssert)Assertions.assertThat(this.getFactHandles()).as("DROO should have expired because @Expires = 60s", new Object[0])).hasSize(1);
    }
}

