/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.model.ConstraintOperator;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Index;
import org.drools.model.Model;
import org.drools.model.PatternDSL;
import org.drools.model.Prototype;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeVariable;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.functions.Block2;
import org.drools.model.impl.ModelImpl;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.ReliabilityTestBasics;
import org.drools.reliability.infinispan.util.PrototypeUtils;
import org.drools.reliability.infinispan.util.TimeAmount;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.Option;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.PersistedSessionOption;

@DisabledIf(value="isProtoStream")
@ExtendWith(value={BeforeAllMethodExtension.class})
class ReliabilityCepTimeWindowTest
extends ReliabilityTestBasics {
    public static final String RULE_NAME = "R";

    ReliabilityCepTimeWindowTest() {
    }

    private Model ruleModel() {
        Global global = DSL.globalOf(List.class, (String)"defaultpkg", (String)"results");
        ArrayList<Rule> rules = new ArrayList<Rule>();
        TimeAmount timeAmount = TimeAmount.parseTimeAmount("5 minutes");
        PrototypeVariable var0 = PrototypeDSL.variable((Prototype)PrototypeUtils.getPrototype("DROOLS_PROTOTYPE"), (String)"m_0");
        PrototypeVariable var1 = PrototypeDSL.variable((Prototype)PrototypeUtils.getPrototype("DROOLS_PROTOTYPE"), (String)"m_1");
        PrototypeVariable var2 = PrototypeDSL.variable((Prototype)PrototypeUtils.getPrototype("DROOLS_PROTOTYPE"), (String)"m_2");
        rules.add(PatternDSL.rule((String)RULE_NAME).build(new RuleItemBuilder[]{PrototypeDSL.protoPattern((PrototypeVariable)var0).expr("ping.timeout", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)true), PrototypeDSL.protoPattern((PrototypeVariable)var1).expr("sensu.process.status", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)"stopped").expr(DSL.after((long)(-timeAmount.getAmount()), (TimeUnit)timeAmount.getTimeUnit(), (long)timeAmount.getAmount(), (TimeUnit)timeAmount.getTimeUnit()), var0), PrototypeDSL.protoPattern((PrototypeVariable)var2).expr("sensu.storage.percent", (ConstraintOperator)Index.ConstraintType.GREATER_THAN, (Object)95).expr(DSL.after((long)(-timeAmount.getAmount()), (TimeUnit)timeAmount.getTimeUnit(), (long)timeAmount.getAmount(), (TimeUnit)timeAmount.getTimeUnit()), var0).expr(DSL.after((long)(-timeAmount.getAmount()), (TimeUnit)timeAmount.getTimeUnit(), (long)timeAmount.getAmount(), (TimeUnit)timeAmount.getTimeUnit()), var1), DSL.on((Variable)global).execute((Block2 & Serializable)(drools, globalResults) -> globalResults.add(RULE_NAME))}));
        return new ModelImpl().withRules(rules).addGlobal(global);
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertFailoverInsertFire_shouldFire(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuProcessStatusEvent("stopped");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingPingTimeoutEvent(true);
        this.advanceTimeAndFire(2L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("2 events. Not yet fired", new Object[0])).isEmpty();
        this.failover();
        this.restoreSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingSensuStoragePercentEvent(98);
        this.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.getResults()).as("all events are matched within +- 5 minutes each other. the rule should be fired", new Object[0])).hasSize(1);
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertExpireFailoverInsertFire_shouldNotFire(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuProcessStatusEvent("stopped");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingPingTimeoutEvent(true);
        this.advanceTimeAndFire(2L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("2 events. Not yet fired", new Object[0])).isEmpty();
        this.advanceTime(5L, TimeUnit.MINUTES);
        this.failover();
        this.restoreSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingSensuStoragePercentEvent(98);
        this.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.getResults()).as("all events aren't matched within +- 5 minutes each other. the rule should not be fired", new Object[0])).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertFailoverExpireInsertFire_shouldNotFire(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuProcessStatusEvent("stopped");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingPingTimeoutEvent(true);
        this.advanceTimeAndFire(2L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("2 events. Not yet fired", new Object[0])).isEmpty();
        this.failover();
        this.restoreSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.advanceTimeAndFire(5L, TimeUnit.MINUTES);
        this.insertMatchingSensuStoragePercentEvent(98);
        this.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.getResults()).as("all events aren't matched within +- 5 minutes each other. the rule should not be fired", new Object[0])).isEmpty();
    }
}

