/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.base.facttemplates.Event;
import org.drools.core.base.accumulators.CountAccumulateFunction;
import org.drools.model.ConstraintOperator;
import org.drools.model.DSL;
import org.drools.model.Declaration;
import org.drools.model.Global;
import org.drools.model.Index;
import org.drools.model.Model;
import org.drools.model.PatternDSL;
import org.drools.model.Prototype;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeExpression;
import org.drools.model.PrototypeVariable;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.functions.Block2;
import org.drools.model.functions.Block3;
import org.drools.model.functions.Block4;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.impl.ModelImpl;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.drools.modelcompiler.facttemplate.FactFactory;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.ReliabilityTestBasics;
import org.drools.reliability.infinispan.util.PrototypeUtils;
import org.drools.reliability.infinispan.util.TimeAmount;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.Option;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.runtime.rule.RuleContext;

@DisabledIf(value="isProtoStream")
@ExtendWith(value={BeforeAllMethodExtension.class})
class ReliabilityCepTimedOutTest
extends ReliabilityTestBasics {
    public static final String KEYWORD = "timed_out";
    public static final String RULE_NAME = "R";

    ReliabilityCepTimedOutTest() {
    }

    private Model ruleModel() {
        Prototype controlPrototype = PrototypeUtils.getPrototype("DROOLS_SYNTHETIC_PROTOTYPE");
        PrototypeVariable controlVar1 = PrototypeDSL.variable((Prototype)controlPrototype, (String)"c1");
        PrototypeVariable controlVar2 = PrototypeDSL.variable((Prototype)controlPrototype, (String)"c2");
        PrototypeVariable controlVar3 = PrototypeDSL.variable((Prototype)controlPrototype, (String)"c3");
        PrototypeVariable eventVar = PrototypeDSL.variable((Prototype)PrototypeUtils.getPrototype("DROOLS_PROTOTYPE"), (String)"e");
        Declaration resultCount = DSL.declarationOf(Long.class, (String)"count");
        Global global = DSL.globalOf(List.class, (String)"defaultpkg", (String)"results");
        ArrayList<Rule> rules = new ArrayList<Rule>();
        String startTag = "start_R";
        String endTag = "end_R";
        TimeAmount timeAmount = TimeAmount.parseTimeAmount("5 minutes");
        rules.add(PatternDSL.rule((String)RULE_NAME).metadata("RULE_TYPE", (Object)KEYWORD).build(new RuleItemBuilder[]{PrototypeDSL.protoPattern((PrototypeVariable)controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)startTag), DSL.not((ViewItemBuilder)PrototypeDSL.protoPattern((PrototypeVariable)controlVar2).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)endTag).expr(DSL.after((long)0L, (TimeUnit)timeAmount.getTimeUnit(), (long)timeAmount.getAmount(), (TimeUnit)timeAmount.getTimeUnit()), controlVar1), (ViewItemBuilder[])new ViewItemBuilder[0]), DSL.on((Variable)controlVar1, (Variable)global).execute((Block3 & Serializable)(drools, controlFact, globalResults) -> {
            globalResults.add(RULE_NAME);
            drools.delete(controlFact);
        })}));
        String rulePrefix = "R_";
        String subRuleName0 = rulePrefix + "0";
        PrototypeVariable patternVariable0 = PrototypeDSL.variable((Prototype)PrototypeUtils.getPrototype("DROOLS_PROTOTYPE"), (String)"m_0");
        rules.add(PatternDSL.rule((String)subRuleName0).metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{PrototypeDSL.protoPattern((PrototypeVariable)patternVariable0).expr("ping.timeout", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)true), DSL.not((ViewItemBuilder)PrototypeDSL.protoPattern((PrototypeVariable)controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)subRuleName0), (ViewItemBuilder[])new ViewItemBuilder[0]), DSL.on((Variable)patternVariable0).execute((Block2 & Serializable)(drools, t1) -> {
            Event controlEvent = FactFactory.createMapBasedEvent((Prototype)controlPrototype).withExpiration((long)timeAmount.getAmount(), timeAmount.getTimeUnit());
            controlEvent.set("rulename", (Object)subRuleName0);
            controlEvent.set("event", t1);
            controlEvent.set("binding", ((RuleContext)drools).getMatch().getDeclarationIds().get(0));
            drools.insert((Object)controlEvent);
        })}));
        String subRuleName1 = rulePrefix + "1";
        PrototypeVariable patternVariable1 = PrototypeDSL.variable((Prototype)PrototypeUtils.getPrototype("DROOLS_PROTOTYPE"), (String)"m_1");
        rules.add(PatternDSL.rule((String)subRuleName1).metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{PrototypeDSL.protoPattern((PrototypeVariable)patternVariable1).expr("sensu.process.status", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)"stopped"), DSL.not((ViewItemBuilder)PrototypeDSL.protoPattern((PrototypeVariable)controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)subRuleName1), (ViewItemBuilder[])new ViewItemBuilder[0]), DSL.on((Variable)patternVariable1).execute((Block2 & Serializable)(drools, t1) -> {
            Event controlEvent = FactFactory.createMapBasedEvent((Prototype)controlPrototype).withExpiration((long)timeAmount.getAmount(), timeAmount.getTimeUnit());
            controlEvent.set("rulename", (Object)subRuleName1);
            controlEvent.set("event", t1);
            controlEvent.set("binding", ((RuleContext)drools).getMatch().getDeclarationIds().get(0));
            drools.insert((Object)controlEvent);
        })}));
        String subRuleName2 = rulePrefix + "2";
        PrototypeVariable patternVariable2 = PrototypeDSL.variable((Prototype)PrototypeUtils.getPrototype("DROOLS_PROTOTYPE"), (String)"m_2");
        rules.add(PatternDSL.rule((String)subRuleName2).metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{PrototypeDSL.protoPattern((PrototypeVariable)patternVariable2).expr("sensu.storage.percent", (ConstraintOperator)Index.ConstraintType.GREATER_THAN, (Object)95), DSL.not((ViewItemBuilder)PrototypeDSL.protoPattern((PrototypeVariable)controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)subRuleName2), (ViewItemBuilder[])new ViewItemBuilder[0]), DSL.on((Variable)patternVariable2).execute((Block2 & Serializable)(drools, t1) -> {
            Event controlEvent = FactFactory.createMapBasedEvent((Prototype)controlPrototype).withExpiration((long)timeAmount.getAmount(), timeAmount.getTimeUnit());
            controlEvent.set("rulename", (Object)subRuleName2);
            controlEvent.set("event", t1);
            controlEvent.set("binding", ((RuleContext)drools).getMatch().getDeclarationIds().get(0));
            drools.insert((Object)controlEvent);
        })}));
        rules.add(PatternDSL.rule((String)startTag).metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{DSL.not((ViewItemBuilder)PrototypeDSL.protoPattern((PrototypeVariable)controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)startTag), (ViewItemBuilder[])new ViewItemBuilder[0]), PrototypeDSL.protoPattern((PrototypeVariable)controlVar2).expr((Predicate1 & Serializable)p -> ((String)p.get("rulename")).startsWith(rulePrefix)), DSL.on((Variable)controlVar2).execute((Block2 & Serializable)(drools, firstEvent) -> {
            Event controlEvent = FactFactory.createMapBasedEvent((Prototype)controlPrototype).withExpiration((long)timeAmount.getAmount(), timeAmount.getTimeUnit());
            controlEvent.set("rulename", (Object)startTag);
            controlEvent.set("event", firstEvent.get("event"));
            controlEvent.set("binding", firstEvent.get("binding"));
            drools.insert((Object)controlEvent);
        })}));
        rules.add(PatternDSL.rule((String)endTag).metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{PrototypeDSL.protoPattern((PrototypeVariable)controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)startTag), DSL.accumulate((ViewItem)PrototypeDSL.protoPattern((PrototypeVariable)controlVar2).expr((Predicate1 & Serializable)p -> ((String)p.get("rulename")).startsWith(rulePrefix)), (AccumulateFunction)DSL.accFunction(CountAccumulateFunction::new).as((Variable)resultCount), (AccumulateFunction[])new AccumulateFunction[0]), PatternDSL.pattern((Variable)resultCount).expr((Predicate1 & Serializable)count -> count == 3L), DSL.on((Variable)resultCount).execute((Block2 & Serializable)(drools, count) -> {
            Event controlEvent = FactFactory.createMapBasedEvent((Prototype)controlPrototype).withExpiration((long)timeAmount.getAmount(), timeAmount.getTimeUnit());
            controlEvent.set("rulename", (Object)endTag);
            drools.insert((Object)controlEvent);
        })}));
        rules.add(PatternDSL.rule((String)(rulePrefix + "cleanupEvents")).metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{PrototypeDSL.protoPattern((PrototypeVariable)controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)endTag), PrototypeDSL.protoPattern((PrototypeVariable)controlVar2).expr((Predicate1 & Serializable)p -> ((String)p.get("rulename")).startsWith(rulePrefix)), PrototypeDSL.protoPattern((PrototypeVariable)eventVar).expr(PrototypeExpression.thisPrototype(), (ConstraintOperator)Index.ConstraintType.EQUAL, controlVar2, PrototypeExpression.prototypeField((String)"event")), DSL.on((Variable)controlVar2, (Variable)eventVar).execute((Block3 & Serializable)(drools, c, e) -> {
            drools.delete(e);
            drools.delete(c);
        })}));
        rules.add(PatternDSL.rule((String)(rulePrefix + "cleanupEvents2")).metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{PrototypeDSL.protoPattern((PrototypeVariable)controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)startTag), DSL.not((ViewItemBuilder)PrototypeDSL.protoPattern((PrototypeVariable)controlVar2).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)endTag).expr(DSL.after((long)0L, (TimeUnit)timeAmount.getTimeUnit(), (long)timeAmount.getAmount(), (TimeUnit)timeAmount.getTimeUnit()), controlVar1), (ViewItemBuilder[])new ViewItemBuilder[0]), PrototypeDSL.protoPattern((PrototypeVariable)controlVar3).expr((Predicate1 & Serializable)p -> ((String)p.get("rulename")).startsWith(rulePrefix)), PrototypeDSL.protoPattern((PrototypeVariable)eventVar).expr(PrototypeExpression.thisPrototype(), (ConstraintOperator)Index.ConstraintType.EQUAL, controlVar3, PrototypeExpression.prototypeField((String)"event")), DSL.on((Variable)controlVar1, (Variable)controlVar3, (Variable)eventVar).execute((Block4 & Serializable)(drools, c1, c3, e) -> {
            drools.delete(e);
            drools.delete(c3);
            drools.delete(c1);
        })}));
        rules.add(PatternDSL.rule((String)(rulePrefix + "cleanupTerminal")).metadata("SYNTHETIC_RULE", (Object)true).build(new RuleItemBuilder[]{PrototypeDSL.protoPattern((PrototypeVariable)controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)startTag), PrototypeDSL.protoPattern((PrototypeVariable)controlVar2).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, (Object)endTag), DSL.on((Variable)controlVar1, (Variable)controlVar2).execute((Block3 & Serializable)(drools, c1, c2) -> {
            drools.delete(c1);
            drools.delete(c2);
        })}));
        return new ModelImpl().withRules(rules).addGlobal(global);
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertFailoverExpireFire_shouldFire(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuProcessStatusEvent("stopped");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingPingTimeoutEvent(true);
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("timeout is 5 minutes window. Not yet fired", new Object[0])).isEmpty();
        this.failover();
        this.restoreSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.advanceTimeAndFire(5L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("after 5 minutes window. the main rule is fired", new Object[0])).hasSize(1);
        ((AbstractCollectionAssert)Assertions.assertThat(this.getFactHandles()).as("All events should be cleaned up", new Object[0])).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertExpireFailoverFire_shouldFire(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.insertMatchingSensuProcessStatusEvent("stopped");
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.insertMatchingPingTimeoutEvent(true);
        this.advanceTimeAndFire(1L, TimeUnit.MINUTES);
        this.advanceTime(5L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(this.getResults()).as("5 minutes timeout is over. But not yet fired", new Object[0])).isEmpty();
        this.failover();
        this.restoreSession(this.ruleModel(), persistenceStrategy, safepointStrategy, new Option[]{EventProcessingOption.STREAM, ClockTypeOption.PSEUDO});
        this.fireAllRules();
        ((ListAssert)Assertions.assertThat(this.getResults()).as("after 5 minutes window. the main rule is fired", new Object[0])).hasSize(1);
        ((AbstractCollectionAssert)Assertions.assertThat(this.getFactHandles()).as("All events should be cleaned up", new Object[0])).isEmpty();
    }
}

