/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import org.assertj.core.api.Assertions;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.ReliabilityTestBasics;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.Option;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.runtime.rule.FactHandle;
import org.test.domain.Person;

@ExtendWith(value={BeforeAllMethodExtension.class})
class ReliabilityTest
extends ReliabilityTestBasics {
    private static final String BASIC_RULE = "import " + Person.class.getCanonicalName() + ";global java.util.List results;rule X when\n  $s: String()\n  $p: Person( getName().startsWith($s) )\nthen\n  results.add( $p.getName() );\nend";

    ReliabilityTest() {
    }

    @Test
    void createAndUseOfNonReliableSession_shouldWorkNormally() {
        this.createSession(BASIC_RULE, null, new Option[0]);
        this.insert("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.insertNonMatchingPerson("Toshiya", 35);
        this.insertMatchingPerson("Matching Person Two", 40);
        this.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person One", "Matching Person Two"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertFailoverInsertFire_shouldRecoverFromFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insert("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.failover();
        this.restoreSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 35);
        this.insertMatchingPerson("Matching Person Two", 40);
        this.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person One", "Matching Person Two"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void noFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insert("M");
        this.insertMatchingPerson("Matching Person One", 37);
        if (safepointStrategy == PersistedSessionOption.SafepointStrategy.EXPLICIT) {
            this.safepoint();
        }
        this.restoreSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 41);
        this.insertMatchingPerson("Matching Person Two", 40);
        this.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person One", "Matching Person Two"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertFireInsertFailoverInsertFire_shouldMatchFactInsertedBeforeFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insert("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.fireAllRules();
        this.insertMatchingPerson("Matching Person Two", 40);
        this.failover();
        this.restoreSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.clearResults();
        this.insertNonMatchingPerson("Toshiya", 35);
        this.insertMatchingPerson("Matching Person Three", 41);
        this.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person Two", "Matching Person Three"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithAllSafepoints"})
    void insertFireFailoverInsertFire_shouldNotRepeatFiredMatch(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insert("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.fireAllRules();
        this.failover();
        this.restoreSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 35);
        this.insertMatchingPerson("Matching Person Two", 40);
        this.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person One", "Matching Person Two"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void updateBeforeFailover_shouldRecoverFromFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insert("M");
        Person p1 = new Person("Mario", 49);
        FactHandle fh1 = this.insert(p1);
        Person p2 = new Person("Toshiya", 45);
        FactHandle fh2 = this.insert(p2);
        Assertions.assertThat((int)this.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Mario"});
        p1.setName("SuperMario");
        this.update(fh1, p1);
        p2.setName("MegaToshiya");
        this.update(fh2, p2);
        this.failover();
        this.restoreSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        Assertions.assertThat((int)this.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Mario", "MegaToshiya"});
        this.failover();
        this.restoreSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.clearResults();
        Assertions.assertThat((int)this.fireAllRules()).isZero();
        Assertions.assertThat(this.getResults()).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void deleteBeforeFailover_shouldRecoverFromFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        FactHandle fhString = this.insert("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.insertNonMatchingPerson("Toshiya", 35);
        Assertions.assertThat((int)this.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person One"});
        this.delete(fhString);
        this.failover();
        this.restoreSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.clearResults();
        this.insertMatchingPerson("Matching Person Two", 40);
        Assertions.assertThat((int)this.fireAllRules()).isZero();
        Assertions.assertThat(this.getResults()).isEmpty();
        this.insert("T");
        this.failover();
        this.restoreSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        Assertions.assertThat((int)this.fireAllRules()).isEqualTo(1);
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Toshiya"});
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void updateByObjectBeforeFailover_shouldMatchUpdatedFact(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insert("M");
        this.insertMatchingPerson("Mark", 37);
        FactHandle fhNicole = this.insertNonMatchingPerson("Nicole", 32);
        Assertions.assertThat((int)this.fireAllRules()).isEqualTo(1);
        this.updateWithMatchingPerson(fhNicole, new Person("Mary", 32));
        this.failover();
        KieSession session = this.restoreSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        Assertions.assertThat((int)this.fireAllRules()).isEqualTo(1);
        this.failover();
        Assertions.assertThat((int)session.fireAllRules()).isZero();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderFull"})
    void insertFailover_propListShouldNotBeEmpty(PersistedSessionOption.PersistenceStrategy strategy) {
        this.createSession(BASIC_RULE, strategy, new Option[0]);
        this.insert("M");
        this.insertMatchingPerson("Maria", 30);
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        Assertions.assertThat((int)this.fireAllRules()).isEqualTo(1);
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderFull"})
    void insertFireFailover_shouldNotRepeatFiredMatch(PersistedSessionOption.PersistenceStrategy strategy) {
        this.createSession(BASIC_RULE, strategy, new Option[0]);
        this.insert("M");
        this.insertMatchingPerson("Maria", 30);
        this.fireAllRules();
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        Assertions.assertThat((int)this.fireAllRules()).isZero();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderFull"})
    void insertUpdateFailover_shouldNotFiredMatch(PersistedSessionOption.PersistenceStrategy strategy) {
        this.createSession(BASIC_RULE, strategy, new Option[0]);
        this.insert("M");
        FactHandle fhMaria = this.insertMatchingPerson("Maria", 30);
        this.updateWithNonMatchingPerson(fhMaria, new Person("Nicole", 32));
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        Assertions.assertThat((int)this.fireAllRules()).isZero();
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderFull"})
    void insertNonMatching_Failover_UpdateWithMatching_ShouldFiredMatch(PersistedSessionOption.PersistenceStrategy strategy) {
        this.createSession(BASIC_RULE, strategy, new Option[0]);
        this.insert("N");
        FactHandle fhMaria = this.insertMatchingPerson("Maria", 30);
        this.failover();
        this.restoreSession(BASIC_RULE, strategy, new Option[0]);
        this.updateWithMatchingPerson(fhMaria, new Person("Nicole", 32));
        Assertions.assertThat((int)this.fireAllRules()).isEqualTo(1);
    }

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void multipleKieSessions_BasicTest(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        KieSession session1 = this.createSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        KieSession session2 = this.createSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insert(session1, "M");
        this.insert(session2, "N");
        this.insert(session1, new Person("Mike-session1", 27));
        this.insert(session2, new Person("Mary-session2", 34));
        Assertions.assertThat((int)this.fireAllRules(session1)).isEqualTo(1);
        Assertions.assertThat((int)this.fireAllRules(session2)).isEqualTo(0);
        this.failover();
        session1 = this.restoreSession(session1.getIdentifier(), BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        session2 = this.restoreSession(session2.getIdentifier(), BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.clearResults(session1);
        this.clearResults(session2);
        this.insert(session1, new Person("Michael-session1", 42));
        this.insert(session2, new Person("Nancy-session2", 25));
        Assertions.assertThat((int)this.fireAllRules(session1)).isEqualTo(1);
        Assertions.assertThat((int)this.fireAllRules(session2)).isEqualTo(1);
    }
}

