/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.drools.base.facttemplates.Event;
import org.drools.core.ClassObjectFilter;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.model.Model;
import org.drools.model.codegen.ExecutableModelProject;
import org.drools.modelcompiler.KieBaseBuilder;
import org.drools.reliability.core.ReliableKieSession;
import org.drools.reliability.core.ReliableRuntimeComponentFactoryImpl;
import org.drools.reliability.core.StorageManagerFactory;
import org.drools.reliability.core.TestableStorageManager;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.InfinispanStorageManager;
import org.drools.reliability.infinispan.util.PrototypeUtils;
import org.drools.util.Config;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.test.core.InfinispanContainer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.provider.Arguments;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.Option;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.utils.KieHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.test.domain.Person;

@ExtendWith(value={BeforeAllMethodExtension.class})
public abstract class ReliabilityTestBasics {
    public static final String RULE_TYPE_TAG = "RULE_TYPE";
    public static final String SYNTHETIC_RULE_TAG = "SYNTHETIC_RULE";
    private static final Logger LOG = LoggerFactory.getLogger(ReliabilityTestBasics.class);
    private InfinispanContainer container;
    protected final List<KieSession> sessions = new ArrayList<KieSession>();
    private long persistedSessionId = -1L;
    protected PersistedSessionOption.SafepointStrategy safepointStrategy;

    static Stream<PersistedSessionOption.PersistenceStrategy> strategyProvider() {
        return Stream.of(PersistedSessionOption.PersistenceStrategy.STORES_ONLY, PersistedSessionOption.PersistenceStrategy.FULL);
    }

    static Stream<Arguments> strategyProviderStoresOnly() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{PersistedSessionOption.PersistenceStrategy.STORES_ONLY, PersistedSessionOption.SafepointStrategy.ALWAYS}));
    }

    static Stream<Arguments> strategyProviderStoresOnlyWithExplicitSafepoints() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{PersistedSessionOption.PersistenceStrategy.STORES_ONLY, PersistedSessionOption.SafepointStrategy.ALWAYS}), Arguments.arguments((Object[])new Object[]{PersistedSessionOption.PersistenceStrategy.STORES_ONLY, PersistedSessionOption.SafepointStrategy.EXPLICIT}));
    }

    static Stream<Arguments> strategyProviderStoresOnlyWithAllSafepoints() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{PersistedSessionOption.PersistenceStrategy.STORES_ONLY, PersistedSessionOption.SafepointStrategy.ALWAYS}), Arguments.arguments((Object[])new Object[]{PersistedSessionOption.PersistenceStrategy.STORES_ONLY, PersistedSessionOption.SafepointStrategy.EXPLICIT}), Arguments.arguments((Object[])new Object[]{PersistedSessionOption.PersistenceStrategy.STORES_ONLY, PersistedSessionOption.SafepointStrategy.AFTER_FIRE}));
    }

    static boolean isProtoStream() {
        return "PROTOSTREAM".equalsIgnoreCase(Config.getConfig((String)"drools.reliability.storage.infinispan.marshaller"));
    }

    static Stream<PersistedSessionOption.PersistenceStrategy> strategyProviderFull() {
        return Stream.of(PersistedSessionOption.PersistenceStrategy.FULL);
    }

    @BeforeEach
    public void setUp() {
        if (((TestableStorageManager)StorageManagerFactory.get().getStorageManager()).isRemote()) {
            LOG.info("Starting InfinispanContainer");
            this.container = (InfinispanContainer)((InfinispanContainer)new InfinispanContainer().withFileSystemBind("infinispan-remote-config", "/user-config")).withCommand("-c /user-config/infinispan-local.xml");
            this.container.start();
            LOG.info("InfinispanContainer started");
            InfinispanStorageManager cacheManager = (InfinispanStorageManager)StorageManagerFactory.get().getStorageManager();
            RemoteCacheManager remoteCacheManager = this.container.getRemoteCacheManager(cacheManager.provideAdditionalRemoteConfigurationBuilder());
            cacheManager.setRemoteCacheManager(remoteCacheManager);
        }
    }

    @AfterEach
    public void tearDown() {
        if (((TestableStorageManager)StorageManagerFactory.get().getStorageManager()).isRemote()) {
            StorageManagerFactory.get().getStorageManager().removeAllSessionStorages();
            StorageManagerFactory.get().getStorageManager().close();
            this.container.stop();
        } else {
            ((TestableStorageManager)StorageManagerFactory.get().getStorageManager()).restartWithCleanUp();
        }
        ReliableRuntimeComponentFactoryImpl.resetCounter();
    }

    public void failover() {
        if (this.safepointStrategy == PersistedSessionOption.SafepointStrategy.EXPLICIT) {
            this.sessions.stream().map(ReliableKieSession.class::cast).forEach(ReliableKieSession::safepoint);
        }
        this.sessions.clear();
        if (((TestableStorageManager)StorageManagerFactory.get().getStorageManager()).isRemote()) {
            StorageManagerFactory.get().getStorageManager().close();
            InfinispanStorageManager cacheManager = (InfinispanStorageManager)StorageManagerFactory.get().getStorageManager();
            RemoteCacheManager remoteCacheManager = this.container.getRemoteCacheManager(cacheManager.provideAdditionalRemoteConfigurationBuilder());
            cacheManager.setRemoteCacheManager(remoteCacheManager);
        } else {
            ((TestableStorageManager)StorageManagerFactory.get().getStorageManager()).restart();
        }
        ReliableRuntimeComponentFactoryImpl.refreshCounterUsingStorage();
    }

    protected FactHandle insert(Object obj) {
        return this.insert(this.sessions.get(0), obj);
    }

    protected FactHandle insert(KieSession session, Object obj) {
        return session.insert(obj);
    }

    protected void update(FactHandle fh, Object obj) {
        this.update(this.sessions.get(0), fh, obj);
    }

    protected void update(KieSession session, FactHandle fh, Object obj) {
        session.update(fh, obj);
    }

    protected void delete(FactHandle fh) {
        this.delete(this.sessions.get(0), fh);
    }

    protected void delete(KieSession session, FactHandle fh) {
        session.delete(fh);
    }

    protected FactHandle insertMatchingPerson(String name, Integer age) {
        return this.insertMatchingPerson(this.sessions.get(0), name, age);
    }

    protected FactHandle insertMatchingPerson(KieSession session, String name, Integer age) {
        return session.insert((Object)new Person(name, age));
    }

    protected void updateWithMatchingPerson(FactHandle nonMatching, Object matching) {
        this.updateWithMatchingPerson(this.sessions.get(0), nonMatching, matching);
    }

    protected void updateWithMatchingPerson(KieSession session, FactHandle nonMatching, Object matching) {
        session.update(nonMatching, matching);
    }

    protected void updateWithNonMatchingPerson(FactHandle matching, Object nonMatching) {
        this.updateWithNonMatchingPerson(this.sessions.get(0), matching, nonMatching);
    }

    protected void updateWithNonMatchingPerson(KieSession session, FactHandle matching, Object nonMatching) {
        session.update(matching, nonMatching);
    }

    protected FactHandle insertNonMatchingPerson(String name, Integer age) {
        return this.insertNonMatchingPerson(this.sessions.get(0), name, age);
    }

    protected FactHandle insertNonMatchingPerson(KieSession session, String name, Integer age) {
        return session.insert((Object)new Person(name, age));
    }

    protected List<Object> getResults() {
        return this.getResults(this.sessions.get(0));
    }

    protected List<Object> getResults(KieSession session) {
        return (List)session.getGlobal("results");
    }

    protected void clearResults() {
        this.clearResults(this.sessions.get(0));
    }

    protected void clearResults(KieSession session) {
        ((List)session.getGlobal("results")).clear();
    }

    protected KieSession createSession(String drl, PersistedSessionOption.PersistenceStrategy persistenceStrategy, Option ... options) {
        return this.createSession(drl, persistenceStrategy, PersistedSessionOption.SafepointStrategy.ALWAYS, options);
    }

    protected KieSession createSession(String drl, PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy, Option ... options) {
        return this.getKieSession(drl, persistenceStrategy != null ? PersistedSessionOption.newSession().withPersistenceStrategy(persistenceStrategy).withSafepointStrategy(safepointStrategy) : null, options);
    }

    protected KieSession createSession(Model ruleModel, PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy, Option ... options) {
        return this.getKieSession(ruleModel, persistenceStrategy != null ? PersistedSessionOption.newSession().withPersistenceStrategy(persistenceStrategy).withSafepointStrategy(safepointStrategy) : null, options);
    }

    protected KieSession restoreSession(String drl, PersistedSessionOption.PersistenceStrategy persistenceStrategy, Option ... options) {
        return this.restoreSession(drl, persistenceStrategy, PersistedSessionOption.SafepointStrategy.ALWAYS, options);
    }

    protected KieSession restoreSession(String drl, PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy, Option ... options) {
        return this.restoreSession(this.persistedSessionId, drl, persistenceStrategy, safepointStrategy, options);
    }

    protected KieSession restoreSession(Long sessionId, String drl, PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy, Option ... options) {
        return this.getKieSession(drl, PersistedSessionOption.fromSession((long)sessionId).withPersistenceStrategy(persistenceStrategy).withSafepointStrategy(safepointStrategy), options);
    }

    protected int fireAllRules() {
        return this.fireAllRules(this.sessions.get(0));
    }

    protected int fireAllRules(KieSession session) {
        return session.fireAllRules();
    }

    protected KieSession restoreSession(Model ruleModel, PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy, Option ... options) {
        return this.getKieSession(ruleModel, PersistedSessionOption.fromSession((long)this.persistedSessionId).withPersistenceStrategy(persistenceStrategy).withSafepointStrategy(safepointStrategy), options);
    }

    protected void disposeSession() {
        this.disposeSession(this.sessions.get(0));
    }

    protected void disposeSession(KieSession session) {
        session.dispose();
    }

    protected SessionPseudoClock getSessionClock() {
        return this.getSessionClock(this.sessions.get(0));
    }

    protected SessionPseudoClock getSessionClock(KieSession session) {
        return (SessionPseudoClock)session.getSessionClock();
    }

    protected Collection<FactHandle> getFactHandles() {
        return this.getFactHandles(this.sessions.get(0));
    }

    protected Collection<FactHandle> getFactHandles(KieSession session) {
        return session.getFactHandles();
    }

    protected void safepoint() {
        this.safepoint(this.sessions.get(0));
    }

    protected void safepoint(KieSession session) {
        ((ReliableKieSession)session).safepoint();
    }

    protected long getSessionIdentifier() {
        return this.sessions.get(0).getIdentifier();
    }

    protected KieSession getKieSession(String drl, PersistedSessionOption persistedSessionOption, Option ... options) {
        OptionsFilter optionsFilter = new OptionsFilter(options);
        KieBase kbase = new KieHelper().addContent(drl, ResourceType.DRL).build(ExecutableModelProject.class, optionsFilter.getKieBaseOptions());
        return this.getKieSessionFromKieBase(kbase, persistedSessionOption, optionsFilter);
    }

    protected KieSession getKieSession(Model ruleModel, PersistedSessionOption persistedSessionOption, Option ... options) {
        OptionsFilter optionsFilter = new OptionsFilter(options);
        InternalKnowledgeBase kbase = KieBaseBuilder.createKieBaseFromModel((Model)ruleModel, (KieBaseOption[])optionsFilter.getKieBaseOptions());
        return this.getKieSessionFromKieBase((KieBase)kbase, persistedSessionOption, optionsFilter);
    }

    private KieSession getKieSessionFromKieBase(KieBase kbase, PersistedSessionOption persistedSessionOption, OptionsFilter optionsFilter) {
        KieSessionConfiguration conf = KieServices.get().newKieSessionConfiguration();
        if (persistedSessionOption != null) {
            conf.setOption((Option)persistedSessionOption);
            this.safepointStrategy = persistedSessionOption.getSafepointStrategy();
        }
        Stream.of(optionsFilter.getKieSessionOption()).forEach(arg_0 -> ((KieSessionConfiguration)conf).setOption(arg_0));
        KieSession session = kbase.newKieSession(conf, null);
        this.sessions.add(session);
        if (persistedSessionOption == null || persistedSessionOption.isNewSession()) {
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            this.persistedSessionId = session.getIdentifier();
        }
        return session;
    }

    protected Optional<Person> getPersonByName(String name) {
        return this.getPersonByName(this.sessions.get(0), name);
    }

    protected Optional<Person> getPersonByName(KieSession kieSession, String name) {
        return kieSession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)).stream().map(Person.class::cast).filter(p -> p.getName().equals(name)).findFirst();
    }

    protected void advanceTime(long amount, TimeUnit unit) {
        ((SessionPseudoClock)this.sessions.get(0).getSessionClock()).advanceTime(amount, unit);
    }

    protected void advanceTimeAndFire(long amount, TimeUnit unit) {
        ((SessionPseudoClock)this.sessions.get(0).getSessionClock()).advanceTime(amount, unit);
        this.sessions.get(0).fireAllRules();
    }

    protected void insertMatchingSensuEvent(String host, String type) {
        this.insertSensuEvent(host, type);
    }

    protected void insertNonMatchingSensuEvent(String host, String type) {
        this.insertSensuEvent(host, type);
    }

    private void insertSensuEvent(String host, String type) {
        Event sensu = PrototypeUtils.createEvent();
        sensu.set("sensu.host", (Object)host);
        sensu.set("sensu.process.type", (Object)type);
        this.sessions.get(0).insert((Object)sensu);
    }

    protected void insertMatchingSensuProcessStatusEvent(String status) {
        Event sensu = PrototypeUtils.createEvent();
        sensu.set("sensu.process.status", (Object)status);
        this.sessions.get(0).insert((Object)sensu);
    }

    protected void insertMatchingPingTimeoutEvent(boolean timeout) {
        Event ping = PrototypeUtils.createEvent();
        ping.set("ping.timeout", (Object)timeout);
        this.sessions.get(0).insert((Object)ping);
    }

    protected void insertMatchingSensuStoragePercentEvent(int percent) {
        Event sensu = PrototypeUtils.createEvent();
        sensu.set("sensu.storage.percent", (Object)percent);
        this.sessions.get(0).insert((Object)sensu);
    }

    private static class OptionsFilter {
        private final Option[] options;

        OptionsFilter(Option[] options) {
            this.options = options;
        }

        KieBaseOption[] getKieBaseOptions() {
            return this.options == null ? new KieBaseOption[]{} : (KieBaseOption[])Stream.of(this.options).filter(KieBaseOption.class::isInstance).toArray(KieBaseOption[]::new);
        }

        KieSessionOption[] getKieSessionOption() {
            return this.options == null ? new KieSessionOption[]{} : (KieSessionOption[])Stream.of(this.options).filter(KieSessionOption.class::isInstance).toArray(KieSessionOption[]::new);
        }
    }
}

