/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan.smoke;

import org.assertj.core.api.Assertions;
import org.drools.reliability.infinispan.BeforeAllMethodExtension;
import org.drools.reliability.infinispan.ReliabilityTestBasics;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.conf.Option;
import org.kie.api.runtime.conf.PersistedSessionOption;
import org.test.domain.Person;

@ExtendWith(value={BeforeAllMethodExtension.class})
public class BaseSmokeTest
extends ReliabilityTestBasics {
    private static final String BASIC_RULE = "import " + Person.class.getCanonicalName() + ";global java.util.List results;rule X when\n  $s: String()\n  $p: Person( getName().startsWith($s) )\nthen\n  results.add( $p.getName() );\nend";

    @ParameterizedTest
    @MethodSource(value={"strategyProviderStoresOnlyWithExplicitSafepoints"})
    void insertFailoverInsertFire_shouldRecoverFromFailover(PersistedSessionOption.PersistenceStrategy persistenceStrategy, PersistedSessionOption.SafepointStrategy safepointStrategy) {
        this.createSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insert("M");
        this.insertMatchingPerson("Matching Person One", 37);
        this.failover();
        this.restoreSession(BASIC_RULE, persistenceStrategy, safepointStrategy, new Option[0]);
        this.insertNonMatchingPerson("Toshiya", 35);
        this.insertMatchingPerson("Matching Person Two", 40);
        this.fireAllRules();
        Assertions.assertThat(this.getResults()).containsExactlyInAnyOrder(new Object[]{"Matching Person One", "Matching Person Two"});
    }
}

