/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.base.facttemplates.Event;
import org.drools.model.Prototype;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeFact;
import org.drools.modelcompiler.facttemplate.FactFactory;

public class PrototypeUtils {
    public static final String DEFAULT_PROTOTYPE_NAME = "DROOLS_PROTOTYPE";
    public static final String SYNTHETIC_PROTOTYPE_NAME = "DROOLS_SYNTHETIC_PROTOTYPE";
    private static final Map<String, Prototype> prototypes = new HashMap<String, Prototype>();

    private PrototypeUtils() {
    }

    public static Event createControlEvent() {
        return FactFactory.createMapBasedEvent((Prototype)PrototypeUtils.getPrototype(SYNTHETIC_PROTOTYPE_NAME));
    }

    public static Prototype getPrototype(String name) {
        return prototypes.computeIfAbsent(name, PrototypeDSL::prototype);
    }

    public static void processResults(List<Object> globalResults, List<Event> controlResults) {
        List events = controlResults.stream().map(r -> ((PrototypeFact)r).get("event")).collect(Collectors.toList());
        globalResults.addAll(events);
    }

    public static Event createEvent() {
        return FactFactory.createMapBasedEvent((Prototype)PrototypeUtils.getPrototype(DEFAULT_PROTOTYPE_NAME));
    }
}

