/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan.util;

import java.util.concurrent.TimeUnit;

public class TimeAmount {
    private final int amount;
    private final TimeUnit timeUnit;

    public TimeAmount(int amount, TimeUnit timeUnit) {
        this.amount = amount;
        this.timeUnit = timeUnit;
    }

    public int getAmount() {
        return this.amount;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String toString() {
        return this.amount + " " + this.timeUnit;
    }

    public static TimeAmount parseTimeAmount(String timeAmount) {
        int sepPos = timeAmount.indexOf(32);
        if (sepPos <= 0) {
            throw new IllegalArgumentException("Invalid time amount definition: " + timeAmount);
        }
        int value = Integer.parseInt(timeAmount.substring(0, sepPos).trim());
        TimeUnit timeUnit = TimeAmount.parseTimeUnit(timeAmount.substring(sepPos + 1).trim());
        return new TimeAmount(value, timeUnit);
    }

    private static TimeUnit parseTimeUnit(String unit) {
        if (unit.equalsIgnoreCase("millisecond") || unit.equalsIgnoreCase("milliseconds")) {
            return TimeUnit.MILLISECONDS;
        }
        if (unit.equalsIgnoreCase("second") || unit.equalsIgnoreCase("seconds")) {
            return TimeUnit.SECONDS;
        }
        if (unit.equalsIgnoreCase("minute") || unit.equalsIgnoreCase("minutes")) {
            return TimeUnit.MINUTES;
        }
        if (unit.equalsIgnoreCase("hour") || unit.equalsIgnoreCase("hours")) {
            return TimeUnit.HOURS;
        }
        if (unit.equalsIgnoreCase("day") || unit.equalsIgnoreCase("days")) {
            return TimeUnit.DAYS;
        }
        throw new IllegalArgumentException("Unknown time unit: " + unit);
    }

    public long toMillis() {
        return this.timeUnit.toMillis(this.amount);
    }
}

