/*
 * Decompiled with CFR 0.152.
 */
package org.drools.retediagram;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.drools.core.reteoo.ReteDumper;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.retediagram.ReteDiagram;
import org.drools.retediagram.model.Measurement;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.utils.KieHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class RuleTest
extends CommonTestMethodBase {
    static final Logger LOG = LoggerFactory.getLogger(RuleTest.class);

    @BeforeClass
    public static void init() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        java.util.logging.Logger.getLogger("").setLevel(Level.FINEST);
    }

    @Test
    public void test() {
        KieBase kieBase = new KieHelper().addFromClassPath("/rules.drl").build(new KieBaseOption[0]);
        LOG.info("Creating kieSession");
        KieSession session = kieBase.newKieSession();
        LOG.info("Populating globals");
        HashSet check = new HashSet();
        session.setGlobal("controlSet", check);
        LOG.info("Now running data");
        Measurement mRed = new Measurement("color", "red");
        session.insert((Object)mRed);
        session.fireAllRules();
        Measurement mGreen = new Measurement("color", "green");
        session.insert((Object)mGreen);
        session.fireAllRules();
        Measurement mBlue = new Measurement("color", "blue");
        session.insert((Object)mBlue);
        session.fireAllRules();
        LOG.info("Final checks");
        Assert.assertEquals((String)"Size of object in Working Memory is 3", (long)3L, (long)session.getObjects().size());
        Assert.assertTrue((String)"contains red", (boolean)check.contains("red"));
        Assert.assertTrue((String)"contains green", (boolean)check.contains("green"));
        Assert.assertTrue((String)"contains blue", (boolean)check.contains("blue"));
        ReteDumper.dumpRete((KieSession)session);
        System.out.println("---");
        ReteDiagram.newInstance().configLayout(ReteDiagram.Layout.VLEVEL).diagramRete(session.getKieBase());
    }

    @Test
    public void testVeryBasic() {
        String drl = "import org.drools.retediagram.model.*;\nrule R1\nwhen\n  $p : Person( age > 18 )\nthen\n  System.out.println(\"Person can drive \"+$p);\nend";
        KieSession kieSession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ReteDiagram.newInstance().diagramRete(kieSession);
    }

    @Test
    public void testManyAccumulatesWithSubnetworks() {
        String drl = "package org.drools.compiler.tests; \ndeclare FunctionResult\n    father  : Applied\nend\n\ndeclare Field\n    applied : Applied\nend\n\ndeclare Applied\nend\n\n\nrule \"Seed\"\nwhen\nthen\n    Applied app = new Applied();\n    Field fld = new Field();\n\n    insert( app );\n    insert( fld );\nend\n\n\n\n\nrule \"complexSubNetworks\"\nwhen\n    $fld : Field( $app : applied )\n    $a : Applied( this == $app )\n    accumulate (\n        $res : FunctionResult( father == $a ),\n        $args : collectList( $res )\n    )\n    accumulate (\n        $res : FunctionResult( father == $a ),\n        $deps : collectList( $res )\n    )\n    accumulate (\n        $x : String()\n        and\n        not String( this == $x ),\n        $exprFieldList : collectList( $x )\n    )\nthen\nend\n\n";
        KnowledgeBuilderConfiguration kbConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        KieBase kbase = this.loadKnowledgeBaseFromString(kbConf, new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        int num = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)num);
        ReteDiagram.newInstance().configLayout(ReteDiagram.Layout.PARTITION).diagramRete(ksession);
    }

    @Test
    public void testLinkRiaNodesWithSubSubNetworks() {
        String drl = "package org.drools.compiler.tests; \nimport java.util.*; \nglobal List list; \ndeclare MyNode\nend\nrule Init\nwhen\nthen\n    insert( new MyNode() );\n    insert( new MyNode() );\nend\nrule \"Init tree nodes\"\nsalience -10\nwhen\n    accumulate (\n                 MyNode(),\n                 $x : count( 1 )\n               )\n    accumulate (\n                 $n : MyNode()\n                 and\n                 accumulate (\n                    $val : Double( ) from Arrays.asList( 1.0, 2.0, 3.0 ),\n                    $rc : count( $val );\n                    $rc == 3 \n                 ),\n                 $y : count( $n )\n               )\nthen\n  list.add( $x ); \n  list.add( $y ); \n  System.out.println( $x ); \n  System.out.println( $y ); \nend\n";
        KnowledgeBuilderConfiguration kbConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        KieBase kbase = this.loadKnowledgeBaseFromString(kbConf, new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Long)list.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Long)list.get(1)).intValue());
        ReteDiagram.newInstance().configLayout(ReteDiagram.Layout.PARTITION).diagramRete(ksession);
    }

    @Test
    public void testMArio() {
        String drl = "rule R1y ruleflow-group \"Y\" when\n    Integer() \n    Number() from accumulate ( Integer( ) and $s : String( ) ; count($s) )\nthen\n    System.out.println(\"R1\");end\n\nrule R1x ruleflow-group \"X\" when\n    Integer() \n    Number() from accumulate ( Integer( ) and $s : String( ) ; count($s) )\nthen\n    System.out.println(\"R1\");end\nrule R2 ruleflow-group \"X\" when\n    $i : Integer()\nthen\n    System.out.println(\"R2\");    update($i);end\n";
        KieSession kieSession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ReteDiagram.newInstance().diagramRete(kieSession);
    }

    @Test
    public void testMario20161021() {
        String drl = "import java.util.Set;\ndeclare Notification end\ndeclare Fall end\ndeclare NetworkElement end\nrule R1 when\n        $notification : Notification()\n        $epcs : Set() from collect( Fall() )\n    then\nend\n\nrule R2 when\n        $notification : Notification()\n        not Fall()\n        $epcs : Set() from collect(Fall())\n\n    then\nend\n\nrule R3 when\n        $ne : NetworkElement()\n    then\nend";
        KieSession kieSession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ReteDumper.dumpRete((KieSession)kieSession);
        ReteDiagram.newInstance().diagramRete(kieSession);
    }

    @Test
    public void testTzimani20161021() {
        String drl = "import java.util.Set;\ndeclare Person end\ndeclare FactWithCheese end\ndeclare Cheese end\nrule \"R1\"\n    when\n        $person : Person()\n        $aFacts : Set() from collect( FactWithCheese() )\n    then\nend\n\nrule \"R2\"\n    when\n        $person : Person()\n        not FactWithCheese()\n        $aFacts : Set() from collect( FactWithCheese() )\n\n    then\nend\n\nrule \"R3\"\n    when\n        $cheese : Cheese()\n    then\nend";
        KieSession kieSession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ReteDumper.dumpRete((KieSession)kieSession);
        ReteDiagram.newInstance().diagramRete(kieSession);
    }

    @Test
    public void testDROOLS1360() {
        String drl = "import " + AtomicInteger.class.getCanonicalName() + ";\nglobal java.util.List list;\n\nrule R2 when\n    $i : AtomicInteger( get() < 3 )\nthen\n    $i.incrementAndGet();    insert(\"test\" + $i.get());    update($i);end\n\nrule R1x when\n    AtomicInteger() \n    $c : Number() from accumulate ( AtomicInteger( ) and $s : String( ) ; count($s) )\n    eval(true)\nthen\n    list.add($c);end\n";
        KieSession kieSession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ReteDumper.dumpRete((KieSession)kieSession);
        ReteDiagram.newInstance().diagramRete(kieSession);
    }

    @Test
    public void testDROOLS_1326_simple() {
        String drl = "package " + ((Object)((Object)this)).getClass().getPackage().getName() + ";\nimport " + MyPojo.class.getCanonicalName() + "\nglobal java.util.Set controlSet;\nrule R1\nwhen\n    $my: MyPojo(\n        vBoolean == true,\n        $s : vString, vString != null,\n        $l : vLong\n    )\n    not MyPojo(\n        vBoolean == true,\n        vString == $s,\n        vLong > $l\n    )\nthen\n    System.out.println($my);\n    System.out.println($l);\n    controlSet.add($l);\nend";
        System.out.println(drl);
        KieSession session = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ReteDumper.dumpRete((KieSession)session);
        ReteDiagram.newInstance().diagramRete(session);
    }

    @Test
    public void testDROOLS_1326_simple_again() {
        String drl = "package " + ((Object)((Object)this)).getClass().getPackage().getName() + ";\nimport " + MyPojo.class.getCanonicalName() + "\nglobal java.util.Set controlSet;\nrule R1\nwhen\n    $my: MyPojo(\n        vBoolean == true,\n        $s : vString, vString != null,\n        $l : vLong\n    )\n    not MyPojo(\n        vBoolean == true,\n        vString.equals($s),\n        vLong > $l\n    )\nthen\n    System.out.println(\"->> firing with \"+ kcontext.getKieRuntime().getFactHandle($my) );\n    System.out.println(\"->> firing with \"+$l);\n    controlSet.add($l);\nend";
        System.out.println(drl);
        KieSession session = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ReteDumper.dumpRete((KieSession)session);
        ReteDiagram.newInstance().diagramRete(session);
    }

    @Test
    public void testCheck() {
        String drl = "package i.p;\nimport " + LongHolder.class.getCanonicalName() + "\nimport " + WeirdObject.class.getCanonicalName() + "\nimport " + TestObjectEnum.class.getCanonicalName() + "\nrule fileArule1 when\n  $t : LongHolder()\n  WeirdObject(added == $t.value, status == TestObjectEnum.ONE.getValue() )\nthen\nend\nrule fileArule2 when\n  $t : LongHolder()\n  WeirdObject(nested.id == $t.value, status == 0 )\nthen\nend\n";
        String drl2 = "package c.t.p;\nimport " + WeirdObject.class.getCanonicalName() + "\nimport " + TestObjectEnum.class.getCanonicalName() + "\nrule fileBrule1 when\n  WeirdObject(status == 1)\nthen\nend\n";
        KieSession kieSession = new KieHelper().addContent(drl2, ResourceType.DRL).addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ReteDiagram.newInstance().diagramRete(kieSession);
        kieSession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        kieSession.insert((Object)new LongHolder(12345L));
        kieSession.insert((Object)new WeirdObject(1, new WeirdNested(12345L)));
        kieSession.fireAllRules();
    }

    @Test
    public void test20180111() {
        String drl = "global java.util.List list;\nrule R0 when\n    $i : Integer( intValue == 0 )\n    String( toString == $i.toString )\nthen\n    list.add($i);\nend\nrule R1 when\n    $i : Integer( intValue == 1 )\n    String( toString == $i.toString )\nthen\n    list.add($i);\nend\nrule R2 when\n    $i : Integer( intValue == 2 )\n    String( toString == $i.toString )\nthen\n    list.add($i);\nend\nrule R3 when\n    $i : Integer( intValue == 2 )\n    String( length == $i )\nthen\n    list.add($i);\nend";
        KnowledgeBuilderConfiguration kbConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        KieBase kbase = this.loadKnowledgeBaseFromString(kbConf, new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ReteDiagram.newInstance().configLayout(ReteDiagram.Layout.PARTITION).diagramRete(ksession);
    }

    public static enum TestObjectEnum {
        ZERO(0),
        ONE(1);

        private int value;

        private TestObjectEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class TestObjectFunction {
        public static int return1() {
            return 1;
        }
    }

    public static class WeirdNested {
        private Long id;

        public WeirdNested(Long id) {
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }
    }

    public static class WeirdObject {
        private Integer status;
        private WeirdNested nested;

        public WeirdObject(Integer status, WeirdNested nested) {
            this.status = status;
            this.nested = nested;
        }

        public Integer getStatus() {
            return this.status;
        }

        public Long added() {
            return this.nested.getId();
        }

        public WeirdNested getNested() {
            return this.nested;
        }
    }

    public static class LongHolder {
        private final Long value;

        public LongHolder(Long value) {
            this.value = value;
        }

        public Long getValue() {
            return this.value;
        }
    }

    public static class MyPojo {
        private boolean vBoolean;
        private String vString;
        private long vLong;

        public MyPojo(boolean vBoolean, String vString, long vLong) {
            this.vBoolean = vBoolean;
            this.vString = vString;
            this.vLong = vLong;
        }

        public boolean isvBoolean() {
            return this.vBoolean;
        }

        public boolean getvBoolean() {
            return this.vBoolean;
        }

        public String getvString() {
            return this.vString;
        }

        public long getvLong() {
            return this.vLong;
        }

        public void setvBoolean(boolean vBoolean) {
            this.vBoolean = vBoolean;
        }

        public void setvString(String vString) {
            this.vString = vString;
        }

        public void setvLong(long vLong) {
            this.vLong = vLong;
        }
    }
}

