/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import org.drools.core.FactException;
import org.drools.core.RuleBaseFactory;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockEvalCondition;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EvalCondition;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.DroolsTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class EvalConditionNodeTest
extends DroolsTestCase {
    private PropagationContext context;
    private AbstractWorkingMemory workingMemory;
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;

    @Before
    public void setUp() {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        PropagationContextFactory pctxFactory = this.ruleBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        this.context = pctxFactory.createPropagationContext(0L, 0, null, null, null);
        this.workingMemory = (AbstractWorkingMemory)this.ruleBase.newStatefulSession();
    }

    @Test
    public void testAttach() throws Exception {
        MockTupleSource source = new MockTupleSource(12);
        EvalConditionNode node = new EvalConditionNode(18, (LeftTupleSource)source, (EvalCondition)new MockEvalCondition(true), this.buildContext);
        Assert.assertEquals((long)18L, (long)node.getId());
        Assert.assertEquals((long)0L, (long)source.getAttached());
        node.attach(this.buildContext);
        Assert.assertEquals((long)1L, (long)source.getAttached());
    }

    @Test
    public void testMemory() {
        AbstractWorkingMemory workingMemory = new AbstractWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        MockTupleSource source = new MockTupleSource(12);
        EvalConditionNode node = new EvalConditionNode(18, (LeftTupleSource)source, (EvalCondition)new MockEvalCondition(true), this.buildContext);
        EvalConditionNode.EvalMemory memory = (EvalConditionNode.EvalMemory)workingMemory.getNodeMemory((MemoryFactory)node);
        Assert.assertNotNull((Object)memory);
    }

    @Test
    public void testAssertedAllowed() throws FactException {
        MockEvalCondition eval = new MockEvalCondition(true);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)sink.getAsserted().size());
    }

    @Test
    public void testAssertedAllowedThenRetract() throws FactException {
        MockEvalCondition eval = new MockEvalCondition(true);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)sink.getAsserted().size());
        node.retractLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)sink.getRetracted().size());
        node.retractLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)sink.getRetracted().size());
    }

    @Test
    public void testAssertedNotAllowed() throws FactException {
        MockEvalCondition eval = new MockEvalCondition(false);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.workingMemory.getNodeMemory((MemoryFactory)node);
        Assert.assertEquals((long)0L, (long)sink.getAsserted().size());
        Assert.assertEquals((long)0L, (long)sink.getRetracted().size());
    }

    @Test
    public void testDoRemove() throws FactException {
        MockEvalCondition eval = new MockEvalCondition(true);
        EvalConditionNode parent = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        EvalConditionNode node = new EvalConditionNode(2, (LeftTupleSource)parent, (EvalCondition)eval, this.buildContext);
        parent.addTupleSink((LeftTupleSink)node);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl parentTuple = new LeftTupleImpl((InternalFactHandle)f0, null, true);
        LeftTuple tuple0 = sink.createLeftTuple((LeftTuple)parentTuple, (LeftTupleSink)sink, null, true);
        node.assertLeftTuple(tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)sink.getAsserted().size());
    }
}

