/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import java.util.List;
import java.util.Map;
import org.drools.core.FactException;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.RuleBaseFactory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PhreakPropagationContext;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.core.test.model.Person;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.rule.FactHandle;

@Ignore
public class ObjectTypeNodeTest
extends DroolsTestCase {
    private PropagationContextFactory pctxFactory;
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;

    @Before
    public void setUp() throws Exception {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.entryPoint = new EntryPointNode(0, (ObjectSource)this.ruleBase.getRete(), this.buildContext);
        this.entryPoint.attach(this.buildContext);
        this.pctxFactory = this.ruleBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
    }

    @Test
    public void testAttach() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete source = this.ruleBase.getRete();
        ClassObjectType objectType = new ClassObjectType(String.class);
        int id = idGenerator.getNextId();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(id, this.entryPoint, (ObjectType)objectType, this.buildContext);
        Assert.assertEquals((long)id, (long)objectTypeNode.getId());
        Map map = source.getObjectTypeNodes(EntryPointId.DEFAULT);
        Assert.assertEquals((long)0L, (long)map.size());
        objectTypeNode.attach(this.buildContext);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertSame((Object)objectTypeNode, map.get(objectType));
    }

    @Test
    public void testAssertObject() throws Exception {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)ruleBase.newStatefulSession();
        Rete source = ruleBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach(this.buildContext);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        String string1 = "cheese";
        InternalFactHandle handle1 = (InternalFactHandle)workingMemory.insert((Object)string1);
        objectTypeNode.assertObject(handle1, context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertSame((Object)string1, (Object)workingMemory.getObject((FactHandle)((DefaultFactHandle)((Object[])asserted.get(0))[0])));
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        Assert.assertTrue((boolean)memory.memory.contains((Object)handle1));
    }

    @Test
    public void testAssertObjectSequentialMode() {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setPhreakEnabled(false);
        conf.setSequential(true);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        this.buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        this.buildContext.setObjectTypeNodeMemoryEnabled(false);
        AbstractWorkingMemory workingMemory = new AbstractWorkingMemory(1, (InternalRuleBase)ruleBase);
        Rete source = ruleBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach(this.buildContext);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        String string1 = "cheese";
        InternalFactHandle handle1 = (InternalFactHandle)workingMemory.insert((Object)string1);
        objectTypeNode.assertObject(handle1, context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertSame((Object)string1, (Object)workingMemory.getObject((FactHandle)((DefaultFactHandle)((Object[])asserted.get(0))[0])));
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertEquals((long)0L, (long)memory.memory.size());
    }

    @Test
    public void testMemory() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)ruleBase.newStatefulSession();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertNotNull((Object)memory);
    }

    @Test
    public void testIsAssignableFrom() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        Rete source = new Rete((InternalRuleBase)ruleBase);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        Assert.assertFalse((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Object().getClass())));
        Assert.assertFalse((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Integer(5).getClass())));
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType("string".getClass())));
        objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(Object.class), this.buildContext);
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Object().getClass())));
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Integer(5).getClass())));
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType("string".getClass())));
    }

    @Test
    public void testRetractObject() throws Exception {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)ruleBase.newStatefulSession();
        Rete source = new Rete((InternalRuleBase)ruleBase);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        String string1 = "cheese";
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)string1);
        objectTypeNode.assertObject((InternalFactHandle)handle1, context, (InternalWorkingMemory)workingMemory);
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        objectTypeNode.retractObject((InternalFactHandle)handle1, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)memory.memory.size());
        List retracted = sink.getRetracted();
        this.assertLength(1, retracted);
        Assert.assertSame((Object)handle1, (Object)((Object[])retracted.get(0))[0]);
    }

    @Test
    public void testUpdateSink() throws FactException {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        AbstractWorkingMemory workingMemory = new AbstractWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)ruleBase));
        Rete source = new Rete((InternalRuleBase)ruleBase);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink1);
        String string1 = "cheese";
        String string2 = "bread";
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)string1);
        DefaultFactHandle handle2 = new DefaultFactHandle(2, (Object)string2);
        objectTypeNode.assertObject((InternalFactHandle)handle1, context, (InternalWorkingMemory)workingMemory);
        objectTypeNode.assertObject((InternalFactHandle)handle2, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)sink1.getAsserted().size());
        MockObjectSink sink2 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink2);
        Assert.assertEquals((long)0L, (long)sink2.getAsserted().size());
        objectTypeNode.updateSink((ObjectSink)sink2, (PropagationContext)new PhreakPropagationContext(), (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)sink2.getAsserted().size());
        String string3 = "water";
        DefaultFactHandle handle3 = new DefaultFactHandle(3, (Object)string3);
        objectTypeNode.assertObject((InternalFactHandle)handle3, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)3L, (long)sink1.getAsserted().size());
        Assert.assertEquals((long)3L, (long)sink2.getAsserted().size());
    }

    @Test
    public void testAssertObjectWithShadowEnabled() throws Exception {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        AbstractWorkingMemory workingMemory = new AbstractWorkingMemory(1, (InternalRuleBase)ruleBase);
        Rete source = ruleBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach(this.buildContext);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(Cheese.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        entryPoint.addObjectSink((ObjectSink)objectTypeNode);
        Cheese cheese = new Cheese("muzzarela", 5);
        InternalFactHandle handle1 = (InternalFactHandle)workingMemory.insert((Object)cheese);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertEquals((Object)cheese, (Object)((InternalFactHandle)((Object[])asserted.get(0))[0]).getObject());
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        Assert.assertTrue((boolean)memory.memory.contains((Object)handle1));
    }

    @Test
    public void testAssertObjectWithShadowEnabledNoDefaultConstr() throws Exception {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)ruleBase.newStatefulSession();
        Rete source = ruleBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach(this.buildContext);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), entryPoint, (ObjectType)new ClassObjectType(Person.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        Person person = new Person("bob", 25);
        InternalFactHandle handle1 = (InternalFactHandle)workingMemory.insert((Object)person);
        objectTypeNode.assertObject(handle1, context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertEquals((Object)((InternalFactHandle)((Object[])asserted.get(0))[0]).getObject(), (Object)person);
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        Assert.assertTrue((boolean)memory.memory.contains((Object)handle1));
    }
}

