/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.base.DefaultKnowledgeHelper;
import org.drools.core.common.ActivationGroupImpl;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationsFilter;
import org.drools.core.common.AgendaGroupFactory;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.EventSupport;
import org.drools.core.common.GarbageCollector;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ScheduledAgendaItem;
import org.drools.core.common.Scheduler;
import org.drools.core.common.TruthMaintenanceSystemHelper;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.Activation;
import org.drools.core.spi.AgendaGroup;
import org.drools.core.spi.ConsequenceException;
import org.drools.core.spi.ConsequenceExceptionHandler;
import org.drools.core.spi.InternalActivationGroup;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.RuleFlowGroup;
import org.drools.core.time.impl.ExpressionIntervalTimer;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.drools.core.util.StringUtils;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReteAgenda
implements Externalizable,
InternalAgenda {
    protected static final transient Logger log = LoggerFactory.getLogger(ReteAgenda.class);
    private static final long serialVersionUID = 510L;
    protected InternalWorkingMemory workingMemory;
    private LinkedList<ScheduledAgendaItem> scheduledActivations;
    private Map<String, InternalAgendaGroup> agendaGroups;
    private Map<String, InternalActivationGroup> activationGroups;
    private java.util.LinkedList<AgendaGroup> focusStack;
    private InternalAgendaGroup currentModule;
    private InternalAgendaGroup main;
    private java.util.LinkedList<RuleAgendaItem> eager;
    private AgendaGroupFactory agendaGroupFactory;
    protected KnowledgeHelper knowledgeHelper;
    private ConsequenceExceptionHandler legacyConsequenceExceptionHandler;
    private org.kie.api.runtime.rule.ConsequenceExceptionHandler consequenceExceptionHandler;
    protected volatile AtomicBoolean halt = new AtomicBoolean(false);
    protected int activationCounter;
    private boolean declarativeAgenda;
    private ObjectTypeConf activationObjectTypeConf;
    private ActivationsFilter activationsFilter;
    private volatile boolean isFiringActivation = false;
    private volatile boolean mustNotifyHalt = false;
    private volatile boolean fireUntilHalt = false;
    private InternalActivationGroup stagedActivations;
    private static final GarbageCollector DUMMY_GARBAGE_COLLECTOR = new DummyGarbageCollector();

    public ReteAgenda() {
    }

    public ReteAgenda(InternalKnowledgeBase kBase) {
        this(kBase, true);
    }

    public ReteAgenda(InternalKnowledgeBase kBase, boolean initMain) {
        this.agendaGroups = new HashMap<String, InternalAgendaGroup>();
        this.activationGroups = new HashMap<String, InternalActivationGroup>();
        this.focusStack = new java.util.LinkedList();
        this.scheduledActivations = new LinkedList();
        this.agendaGroupFactory = kBase.getConfiguration().getAgendaGroupFactory();
        if (initMain) {
            this.main = this.agendaGroupFactory.createAgendaGroup("MAIN", kBase);
            this.agendaGroups.put("MAIN", this.main);
            this.focusStack.add((AgendaGroup)this.main);
        }
        this.eager = new java.util.LinkedList();
        Object object = ClassUtils.instantiateObject((String)kBase.getConfiguration().getConsequenceExceptionHandler(), (ClassLoader)kBase.getConfiguration().getClassLoader());
        if (object instanceof ConsequenceExceptionHandler) {
            this.legacyConsequenceExceptionHandler = (ConsequenceExceptionHandler)object;
        } else {
            this.consequenceExceptionHandler = (org.kie.api.runtime.rule.ConsequenceExceptionHandler)object;
        }
        this.declarativeAgenda = kBase.getConfiguration().isDeclarativeAgenda();
    }

    public RuleAgendaItem createRuleAgendaItem(int salience, PathMemory rs, TerminalNode rtn) {
        String agendaGroupName = rtn.getRule().getAgendaGroup();
        String ruleFlowGroupName = rtn.getRule().getRuleFlowGroup();
        RuleAgendaItem lazyAgendaItem = !StringUtils.isEmpty((CharSequence)ruleFlowGroupName) ? new RuleAgendaItem((long)this.activationCounter++, null, salience, null, rs, rtn, this.isDeclarativeAgenda(), (InternalAgendaGroup)this.getAgendaGroup(ruleFlowGroupName)) : new RuleAgendaItem((long)this.activationCounter++, null, salience, null, rs, rtn, this.isDeclarativeAgenda(), (InternalAgendaGroup)this.getRuleFlowGroup(agendaGroupName));
        return lazyAgendaItem;
    }

    public long getNextActivationCounter() {
        return this.activationCounter++;
    }

    public AgendaItem createAgendaItem(LeftTuple tuple, int salience, PropagationContext context, TerminalNode rtn, RuleAgendaItem ruleAgendaItem, InternalAgendaGroup agendaGroup) {
        RuleTerminalNodeLeftTuple rtnLeftTuple = (RuleTerminalNodeLeftTuple)tuple;
        rtnLeftTuple.init((long)this.activationCounter++, salience, context, ruleAgendaItem, agendaGroup);
        rtnLeftTuple.setObject((Object)rtnLeftTuple);
        return rtnLeftTuple;
    }

    public ScheduledAgendaItem createScheduledAgendaItem(LeftTuple tuple, PropagationContext context, TerminalNode rtn, InternalAgendaGroup agendaGroup) {
        RuleTerminalNodeLeftTuple rtnLeftTuple = (RuleTerminalNodeLeftTuple)tuple;
        rtnLeftTuple.init((long)this.activationCounter++, 0, context, null, agendaGroup);
        ScheduledAgendaItem item = new ScheduledAgendaItem((AgendaItem)rtnLeftTuple, (InternalAgenda)this);
        tuple.setObject((Object)item);
        return item;
    }

    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        RuleBaseConfiguration rbc = this.workingMemory.getKnowledgeBase().getConfiguration();
        this.knowledgeHelper = rbc.isSequential() ? rbc.getComponentFactory().getKnowledgeHelperFactory().newSequentialKnowledgeHelper((WorkingMemory)this.workingMemory) : rbc.getComponentFactory().getKnowledgeHelperFactory().newStatefulKnowledgeHelper((WorkingMemory)this.workingMemory);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemory)in.readObject();
        this.scheduledActivations = (LinkedList)in.readObject();
        this.agendaGroups = (Map)in.readObject();
        this.activationGroups = (Map)in.readObject();
        this.focusStack = (java.util.LinkedList)in.readObject();
        this.currentModule = (InternalAgendaGroup)in.readObject();
        this.main = (InternalAgendaGroup)in.readObject();
        this.agendaGroupFactory = (AgendaGroupFactory)in.readObject();
        this.knowledgeHelper = (KnowledgeHelper)in.readObject();
        this.legacyConsequenceExceptionHandler = (ConsequenceExceptionHandler)in.readObject();
        this.declarativeAgenda = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeObject(this.scheduledActivations);
        out.writeObject(this.agendaGroups);
        out.writeObject(this.activationGroups);
        out.writeObject(this.focusStack);
        out.writeObject(this.currentModule);
        out.writeObject(this.main);
        out.writeObject(this.agendaGroupFactory);
        out.writeObject(this.knowledgeHelper);
        out.writeObject(this.legacyConsequenceExceptionHandler);
        out.writeBoolean(this.declarativeAgenda);
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public void addEagerRuleAgendaItem(RuleAgendaItem item) {
        if (item.isInList()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Added {} to eager evaluation list.", (Object)item.getRule().getName());
        }
        this.eager.add(item);
    }

    public void removeEagerRuleAgendaItem(RuleAgendaItem item) {
        if (!item.isInList()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Removed {} from eager evaluation list.", (Object)item.getRule().getName());
        }
        this.eager.remove(item);
    }

    public void scheduleItem(ScheduledAgendaItem item, InternalWorkingMemory wm) {
        this.scheduledActivations.add((LinkedListNode)item);
        item.setEnqueued(true);
        if (item.getPropagationContext().getReaderContext() == null) {
            Scheduler.scheduleAgendaItem((ScheduledAgendaItem)item, (InternalAgenda)this, (InternalWorkingMemory)wm);
        }
    }

    public void addItemToActivationGroup(AgendaItem item) {
        String group = item.getRule().getActivationGroup();
        if (group != null && group.length() > 0) {
            InternalActivationGroup actgroup = this.getActivationGroup(group);
            actgroup.addActivation((Activation)item);
        }
    }

    public InternalActivationGroup getStageActivationsGroup() {
        if (this.stagedActivations == null) {
            this.stagedActivations = new ActivationGroupImpl((InternalAgenda)this, "staged activations");
        }
        return this.stagedActivations;
    }

    public void insertAndStageActivation(AgendaItem activation) {
        if (this.activationObjectTypeConf == null) {
            EntryPointId ep = this.workingMemory.getEntryPoint();
            this.activationObjectTypeConf = ((InternalWorkingMemoryEntryPoint)this.workingMemory.getWorkingMemoryEntryPoint(ep.getEntryPointId())).getObjectTypeConfigurationRegistry().getObjectTypeConf(ep, (Object)activation);
        }
        InternalFactHandle factHandle = this.workingMemory.getFactHandleFactory().newFactHandle((Object)activation, this.activationObjectTypeConf, this.workingMemory, (EntryPoint)this.workingMemory);
        this.workingMemory.getEntryPointNode().assertActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
        activation.setFactHandle(factHandle);
        if (!activation.isCanceled() && (activation.getBlockers() == null || activation.getBlockers().isEmpty())) {
            this.getStageActivationsGroup().addActivation((Activation)activation);
        }
    }

    public boolean addActivation(AgendaItem activation) {
        if (this.declarativeAgenda) {
            this.insertAndStageActivation(activation);
            return true;
        }
        this.addActivation(activation, true);
        return true;
    }

    public boolean isDeclarativeAgenda() {
        return this.declarativeAgenda;
    }

    public void removeActivation(AgendaItem activation) {
        if (this.declarativeAgenda) {
            this.workingMemory.getEntryPointNode().retractActivation(activation.getFactHandle(), activation.getPropagationContext(), this.workingMemory);
            if (activation.getActivationGroupNode() != null) {
                activation.getActivationGroupNode().getActivationGroup().removeActivation((Activation)activation);
            }
        }
        if (activation instanceof ScheduledAgendaItem) {
            this.removeScheduleItem((ScheduledAgendaItem)activation);
        }
    }

    public void modifyActivation(AgendaItem activation, boolean previouslyActive) {
        if (this.declarativeAgenda) {
            InternalFactHandle factHandle = activation.getFactHandle();
            this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
            if (previouslyActive) {
                return;
            }
            if (activation.isCanceled() || activation.getBlockers() != null && activation.getBlockers().size() > 0) {
                return;
            }
            InternalActivationGroup activationGroup = this.getStageActivationsGroup();
            if (activation.getActivationGroupNode() != null && activation.getActivationGroupNode().getActivationGroup() == activationGroup) {
                return;
            }
            activationGroup.addActivation((Activation)activation);
        } else if (!previouslyActive) {
            this.addActivation(activation, true);
        } else {
            Timer timer = activation.getRule().getTimer();
            if (timer != null && timer instanceof ExpressionIntervalTimer) {
                ScheduledAgendaItem schItem = (ScheduledAgendaItem)activation;
                this.removeScheduleItem(schItem);
                this.scheduleItem(schItem, this.workingMemory);
            }
        }
    }

    public void clearAndCancelStagedActivations() {
        if (this.getStageActivationsGroup().isEmpty()) {
            return;
        }
        LinkedList list = this.getStageActivationsGroup().getList();
        EventSupport eventsupport = (EventSupport)this.workingMemory;
        ActivationGroupNode node = (ActivationGroupNode)list.removeFirst();
        while (node != null) {
            AgendaItem item = (AgendaItem)node.getActivation();
            item.setQueued(false);
            eventsupport.getAgendaEventSupport().fireActivationCancelled((Activation)item, (WorkingMemory)this.workingMemory, MatchCancelledCause.CLEAR);
            node = (ActivationGroupNode)list.removeFirst();
        }
    }

    public int unstageActivations() {
        if (!this.declarativeAgenda || this.getStageActivationsGroup().isEmpty()) {
            return 0;
        }
        LinkedList list = this.getStageActivationsGroup().getList();
        int i = 0;
        ActivationGroupNode node = (ActivationGroupNode)list.removeFirst();
        while (node != null) {
            AgendaItem item = (AgendaItem)node.getActivation();
            item.setActivationGroupNode(null);
            this.addActivation(item, false);
            ++i;
            node = (ActivationGroupNode)list.removeFirst();
        }
        this.notifyHalt();
        return i;
    }

    public void addActivation(AgendaItem item, boolean notify) {
        RuleImpl rule = item.getRule();
        item.setQueued(true);
        if (rule.getAutoFocus()) {
            this.setFocus(item.getPropagationContext(), rule.getAgendaGroup());
        }
        this.addItemToActivationGroup(item);
        Timer timer = rule.getTimer();
        if (timer != null && item instanceof ScheduledAgendaItem) {
            ScheduledAgendaItem sitem = (ScheduledAgendaItem)item;
            if (sitem.isEnqueued()) {
                this.scheduledActivations.remove((LinkedListNode)sitem);
            }
            this.scheduleItem(sitem, this.workingMemory);
        } else {
            this.addAgendaItemToGroup(item);
        }
        if (notify) {
            if (this.isFiringActivation) {
                this.mustNotifyHalt = true;
            } else {
                this.notifyHalt();
            }
        }
    }

    public void addAgendaItemToGroup(AgendaItem item) {
        InternalAgendaGroup agendaGroup = (InternalAgendaGroup)this.getAgendaGroup(item.getRule().getAgendaGroup());
        agendaGroup.add((Activation)item);
    }

    public void removeScheduleItem(ScheduledAgendaItem item) {
        if (item.isEnqueued()) {
            this.scheduledActivations.remove((LinkedListNode)item);
            item.setEnqueued(false);
            Scheduler.removeAgendaItem((ScheduledAgendaItem)item, (InternalAgenda)this);
        }
    }

    public void addAgendaGroup(AgendaGroup agendaGroup) {
        this.agendaGroups.put(agendaGroup.getName(), (InternalAgendaGroup)agendaGroup);
    }

    public boolean createActivation(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, TerminalNode rtn) {
        ScheduledAgendaItem item;
        if (rtn.isFireDirect()) {
            AgendaItem item2 = this.createAgendaItem(tuple, 0, context, rtn, null, null);
            tuple.setObject((Object)item2);
            if (this.activationsFilter != null && !this.activationsFilter.accept((Activation)item2, workingMemory, rtn)) {
                return false;
            }
            item2.setQueued(true);
            tuple.increaseActivationCountForEvents();
            this.fireActivation((Activation)item2);
            return true;
        }
        RuleImpl rule = rtn.getRule();
        Timer timer = rule.getTimer();
        InternalAgendaGroup agendaGroup = (InternalAgendaGroup)this.getAgendaGroup(rule.getAgendaGroup());
        if (timer != null) {
            item = this.createScheduledAgendaItem(tuple, context, rtn, agendaGroup);
        } else {
            if (rule.getCalendars() != null) {
                long timestamp = workingMemory.getSessionClock().getCurrentTime();
                for (String cal : rule.getCalendars()) {
                    if (workingMemory.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                    return false;
                }
            }
            if (rule.isLockOnActive() && agendaGroup.isActive() && agendaGroup.getAutoFocusActivator() != context) {
                if (tuple.getObject() == null) {
                    tuple.setObject((Object)Boolean.TRUE);
                }
                return false;
            }
            item = this.createAgendaItem(tuple, 0, context, rtn, null, agendaGroup);
            item.setSalience(rule.getSalience().getValue((KnowledgeHelper)new DefaultKnowledgeHelper((Activation)item, (WorkingMemory)workingMemory), (Rule)rule, (WorkingMemory)workingMemory));
        }
        if (this.activationsFilter != null && !this.activationsFilter.accept((Activation)item, workingMemory, rtn)) {
            return false;
        }
        item.setQueued(true);
        tuple.increaseActivationCountForEvents();
        ((EventSupport)workingMemory).getAgendaEventSupport().fireActivationCreated((Activation)item, (WorkingMemory)workingMemory);
        return true;
    }

    public boolean createPostponedActivation(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, TerminalNode rtn) {
        RuleImpl rule = rtn.getRule();
        if (rule.getCalendars() != null) {
            long timestamp = workingMemory.getSessionClock().getCurrentTime();
            for (String cal : rule.getCalendars()) {
                if (workingMemory.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                return false;
            }
        }
        InternalAgendaGroup agendaGroup = (InternalAgendaGroup)this.getAgendaGroup(rule.getAgendaGroup());
        if (rule.isLockOnActive() && agendaGroup.isActive() && agendaGroup.getAutoFocusActivator() != context) {
            return false;
        }
        AgendaItem item = this.createAgendaItem(tuple, 0, context, rtn, null, agendaGroup);
        item.setSalience(rule.getSalience().getValue((KnowledgeHelper)new DefaultKnowledgeHelper((Activation)item, (WorkingMemory)workingMemory), (Rule)rule, (WorkingMemory)workingMemory));
        if (this.activationsFilter != null && !this.activationsFilter.accept((Activation)item, workingMemory, rtn)) {
            return false;
        }
        item.setQueued(true);
        tuple.increaseActivationCountForEvents();
        ((EventSupport)workingMemory).getAgendaEventSupport().fireActivationCreated((Activation)item, (WorkingMemory)workingMemory);
        return true;
    }

    public boolean isRuleActiveInRuleFlowGroup(String ruleflowGroupName, String ruleName, long processInstanceId) {
        return this.isRuleInstanceAgendaItem(ruleflowGroupName, ruleName, processInstanceId);
    }

    public void cancelActivation(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, Activation activation, TerminalNode rtn) {
        AgendaItem item = (AgendaItem)activation;
        item.removeAllBlockersAndBlocked((InternalAgenda)this);
        if (this.isDeclarativeAgenda() && activation.getFactHandle() == null) {
            return;
        }
        this.removeActivation(item);
        if (activation.isQueued() && (context.getType() != 5 || context.getFactHandleOrigin() == null)) {
            activation.remove();
            if (activation.getActivationGroupNode() != null) {
                activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
            }
            leftTuple.decreaseActivationCountForEvents();
            ((EventSupport)workingMemory).getAgendaEventSupport().fireActivationCancelled(activation, (WorkingMemory)workingMemory, MatchCancelledCause.WME_MODIFY);
        }
        if (item.getActivationUnMatchListener() != null) {
            item.getActivationUnMatchListener().unMatch((RuleRuntime)workingMemory.getKnowledgeRuntime(), (Match)item);
        }
        TruthMaintenanceSystemHelper.removeLogicalDependencies((Activation)activation, (PropagationContext)context, (RuleImpl)rtn.getRule());
    }

    public boolean setFocus(AgendaGroup agendaGroup) {
        if (this.focusStack.getLast() != agendaGroup) {
            ((InternalAgendaGroup)this.focusStack.getLast()).setActive(false);
            this.focusStack.add(agendaGroup);
            InternalAgendaGroup igroup = (InternalAgendaGroup)agendaGroup;
            igroup.setActive(true);
            igroup.setActivatedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            EventSupport eventsupport = (EventSupport)this.workingMemory;
            eventsupport.getAgendaEventSupport().fireAgendaGroupPushed(agendaGroup, this.workingMemory);
            return true;
        }
        return false;
    }

    public void setFocus(String name) {
        this.setFocus(null, name);
    }

    public void setFocus(PropagationContext ctx, String name) {
        AgendaGroup agendaGroup = this.getAgendaGroup(name);
        agendaGroup.setAutoFocusActivator(ctx);
        this.setFocus(agendaGroup);
    }

    public AgendaGroup getFocus() {
        return this.focusStack.getLast();
    }

    public InternalAgendaGroup getNextFocus() {
        InternalAgendaGroup agendaGroup;
        while ((agendaGroup = (InternalAgendaGroup)this.focusStack.getLast()).isAutoDeactivate()) {
            boolean empty = agendaGroup.isEmpty();
            if (empty && this.focusStack.size() > 1) {
                agendaGroup.setActive(false);
                this.focusStack.removeLast();
                if (agendaGroup.isAutoDeactivate() && !agendaGroup.getNodeInstances().isEmpty()) {
                    this.innerDeactiveRuleFlowGroup((InternalRuleFlowGroup)agendaGroup);
                }
                EventSupport eventsupport = (EventSupport)this.workingMemory;
                eventsupport.getAgendaEventSupport().fireAgendaGroupPopped((AgendaGroup)agendaGroup, this.workingMemory);
                continue;
            }
            agendaGroup = empty ? null : agendaGroup;
            break;
        }
        if (agendaGroup != null && !agendaGroup.isActive()) {
            agendaGroup.setActivatedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            agendaGroup.setActive(true);
        }
        return agendaGroup;
    }

    public RuleAgendaItem peekNextRule() {
        return (RuleAgendaItem)((InternalAgendaGroup)this.focusStack.peek()).peek();
    }

    public void setCurrentAgendaGroup(InternalAgendaGroup agendaGroup) {
        this.currentModule = agendaGroup;
    }

    public AgendaGroup getCurrentAgendaGroup() {
        return this.currentModule;
    }

    public AgendaGroup getAgendaGroup(String name) {
        return this.getAgendaGroup(name, this.workingMemory == null ? null : this.workingMemory.getKnowledgeBase());
    }

    public AgendaGroup getAgendaGroup(String name, InternalKnowledgeBase kBase) {
        String groupName = name == null || name.length() == 0 ? "MAIN" : name;
        InternalAgendaGroup agendaGroup = this.agendaGroups.get(groupName);
        if (agendaGroup == null) {
            agendaGroup = this.agendaGroupFactory.createAgendaGroup(name, kBase);
            this.addAgendaGroup((AgendaGroup)agendaGroup);
        }
        agendaGroup.setWorkingMemory((InternalWorkingMemory)this.getWorkingMemory());
        return agendaGroup;
    }

    public AgendaGroup[] getAgendaGroups() {
        return this.agendaGroups.values().toArray(new AgendaGroup[this.agendaGroups.size()]);
    }

    public Map<String, InternalAgendaGroup> getAgendaGroupsMap() {
        return this.agendaGroups;
    }

    public InternalAgendaGroup getMainAgendaGroup() {
        if (this.main == null) {
            this.main = (InternalAgendaGroup)this.getAgendaGroup("MAIN");
        }
        return this.main;
    }

    public AgendaGroup[] getStack() {
        return this.focusStack.toArray(new AgendaGroup[this.focusStack.size()]);
    }

    public java.util.LinkedList<AgendaGroup> getStackList() {
        return this.focusStack;
    }

    public void addAgendaGroupOnStack(AgendaGroup agendaGroup) {
        if (this.focusStack.isEmpty() || this.focusStack.getLast() != agendaGroup) {
            this.focusStack.add(agendaGroup);
        }
    }

    public Map<String, InternalActivationGroup> getActivationGroupsMap() {
        return this.activationGroups;
    }

    public InternalActivationGroup getActivationGroup(String name) {
        ActivationGroupImpl activationGroup = (ActivationGroupImpl)this.activationGroups.get(name);
        if (activationGroup == null) {
            activationGroup = new ActivationGroupImpl((InternalAgenda)this, name);
            this.activationGroups.put(name, (InternalActivationGroup)activationGroup);
        }
        return activationGroup;
    }

    public RuleFlowGroup getRuleFlowGroup(String name) {
        return (RuleFlowGroup)this.getAgendaGroup(name);
    }

    public void activateRuleFlowGroup(String name) {
        InternalRuleFlowGroup group = (InternalRuleFlowGroup)this.getRuleFlowGroup(name);
        this.activateRuleFlowGroup(group, -1L, null);
    }

    public void activateRuleFlowGroup(String name, long processInstanceId, String nodeInstanceId) {
        InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)this.getRuleFlowGroup(name);
        this.activateRuleFlowGroup(ruleFlowGroup, processInstanceId, nodeInstanceId);
    }

    public void activateRuleFlowGroup(InternalRuleFlowGroup group, long processInstanceId, String nodeInstanceId) {
        ((EventSupport)this.workingMemory).getAgendaEventSupport().fireBeforeRuleFlowGroupActivated((RuleFlowGroup)group, this.workingMemory);
        group.setActive(true);
        group.hasRuleFlowListener(true);
        if (!StringUtils.isEmpty((CharSequence)nodeInstanceId)) {
            group.addNodeInstance(Long.valueOf(processInstanceId), nodeInstanceId);
            group.setActive(true);
        }
        this.setFocus((AgendaGroup)group);
        ((EventSupport)this.workingMemory).getAgendaEventSupport().fireAfterRuleFlowGroupActivated((RuleFlowGroup)group, this.workingMemory);
    }

    public void deactivateRuleFlowGroup(String name) {
        this.deactivateRuleFlowGroup((InternalRuleFlowGroup)this.getRuleFlowGroup(name));
    }

    public void deactivateRuleFlowGroup(InternalRuleFlowGroup group) {
        if (!group.isRuleFlowListener()) {
            return;
        }
        ((EventSupport)this.workingMemory).getAgendaEventSupport().fireBeforeRuleFlowGroupDeactivated((RuleFlowGroup)group, this.workingMemory);
        while (this.focusStack.remove(group)) {
        }
        group.setActive(false);
        this.innerDeactiveRuleFlowGroup(group);
    }

    private void innerDeactiveRuleFlowGroup(InternalRuleFlowGroup group) {
        group.hasRuleFlowListener(false);
        group.getNodeInstances().clear();
        ((EventSupport)this.workingMemory).getAgendaEventSupport().fireAfterRuleFlowGroupDeactivated((RuleFlowGroup)group, this.workingMemory);
    }

    public int focusStackSize() {
        int size = 0;
        for (AgendaGroup group : this.focusStack) {
            size += group.size();
        }
        return size;
    }

    public int agendaSize() {
        int size = 0;
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            size += internalAgendaGroup.size();
        }
        return size;
    }

    public Activation[] getActivations() {
        ArrayList<Activation> list = new ArrayList<Activation>();
        for (AgendaGroup agendaGroup : this.agendaGroups.values()) {
            for (Match activation : agendaGroup.getActivations()) {
                list.add((Activation)activation);
            }
        }
        return list.toArray(new Activation[list.size()]);
    }

    public Activation[] getScheduledActivations() {
        Activation[] scheduledActivations = new Activation[this.scheduledActivations.size()];
        int i = 0;
        for (ScheduledAgendaItem node = (ScheduledAgendaItem)this.scheduledActivations.getFirst(); node != null; node = node.getNext()) {
            scheduledActivations[i++] = node;
        }
        return scheduledActivations;
    }

    public LinkedList<ScheduledAgendaItem> getScheduledActivationsLinkedList() {
        return this.scheduledActivations;
    }

    public void clear() {
        this.focusStack.clear();
        this.focusStack.add((AgendaGroup)this.getMainAgendaGroup());
        if (!this.scheduledActivations.isEmpty()) {
            ScheduledAgendaItem item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            while (item != null) {
                item.setEnqueued(false);
                Scheduler.removeAgendaItem((ScheduledAgendaItem)item, (InternalAgenda)this);
                item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            }
        }
        this.getStageActivationsGroup().clear();
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            internalAgendaGroup.reset();
        }
        for (InternalActivationGroup internalActivationGroup : this.activationGroups.values()) {
            internalActivationGroup.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            internalActivationGroup.reset();
        }
    }

    public void clearAndCancel() {
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            this.clearAndCancelAgendaGroup((AgendaGroup)internalAgendaGroup);
        }
        EventSupport eventsupport = (EventSupport)this.workingMemory;
        if (!this.scheduledActivations.isEmpty()) {
            ScheduledAgendaItem item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            while (item != null) {
                item.setEnqueued(false);
                Scheduler.removeAgendaItem((ScheduledAgendaItem)item, (InternalAgenda)this);
                eventsupport.getAgendaEventSupport().fireActivationCancelled((Activation)item, (WorkingMemory)this.workingMemory, MatchCancelledCause.CLEAR);
                item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            }
        }
        this.clearAndCancelStagedActivations();
        for (InternalActivationGroup group : this.activationGroups.values()) {
            this.clearAndCancelActivationGroup(group);
        }
    }

    public void clearAndCancelAgendaGroup(String name) {
        AgendaGroup agendaGroup = (AgendaGroup)this.agendaGroups.get(name);
        if (agendaGroup != null) {
            this.clearAndCancelAgendaGroup(agendaGroup);
        }
    }

    public void clearAndCancelAgendaGroup(AgendaGroup agendaGroup) {
        EventSupport eventsupport = (EventSupport)this.workingMemory;
        ((InternalAgendaGroup)agendaGroup).setClearedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
        for (Activation aQueueable : ((InternalAgendaGroup)agendaGroup).getAndClear()) {
            AgendaItem item = (AgendaItem)aQueueable;
            if (item == null) continue;
            item.setQueued(false);
            if (item.getActivationGroupNode() != null) {
                item.getActivationGroupNode().getActivationGroup().removeActivation((Activation)item);
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled((Activation)item, (WorkingMemory)this.workingMemory, MatchCancelledCause.CLEAR);
        }
    }

    public void clearAndCancelActivationGroup(String name) {
        InternalActivationGroup activationGroup = this.activationGroups.get(name);
        if (activationGroup != null) {
            this.clearAndCancelActivationGroup(activationGroup);
        }
    }

    public void clearAndCancelActivationGroup(InternalActivationGroup activationGroup) {
        EventSupport eventsupport = (EventSupport)this.workingMemory;
        activationGroup.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
        for (ActivationGroupNode node : activationGroup) {
            Activation activation = node.getActivation();
            activation.setActivationGroupNode(null);
            if (!activation.isQueued()) continue;
            activation.setQueued(false);
            activation.remove();
            eventsupport.getAgendaEventSupport().fireActivationCancelled(activation, (WorkingMemory)this.workingMemory, MatchCancelledCause.CLEAR);
        }
        activationGroup.reset();
    }

    public void clearAndCancelRuleFlowGroup(String name) {
        this.clearAndCancelAgendaGroup((AgendaGroup)this.agendaGroups.get(name));
    }

    public void clearAndCancelAndCancel(RuleFlowGroup ruleFlowGroup) {
        this.clearAndCancelAgendaGroup((AgendaGroup)((InternalAgendaGroup)ruleFlowGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fireNextItem(AgendaFilter filter, int fireCount, int fireLimit) throws ConsequenceException {
        int localFireCount = 0;
        try {
            boolean tryagain;
            do {
                this.evaluateEagerList();
                this.workingMemory.prepareToFireActivation();
                tryagain = false;
                InternalAgendaGroup group = this.getNextFocus();
                if (group == null) continue;
                AgendaItem item = (AgendaItem)group.remove();
                if (item != null) {
                    if (filter == null || filter.accept((Match)item)) {
                        this.fireActivation((Activation)item);
                        ++localFireCount;
                    } else {
                        this.workingMemory.executeQueuedActions();
                        EventSupport eventsupport = (EventSupport)this.workingMemory;
                        eventsupport.getAgendaEventSupport().fireActivationCancelled((Activation)item, (WorkingMemory)this.workingMemory, MatchCancelledCause.FILTER);
                        tryagain = true;
                    }
                }
                if ((AgendaItem)group.peek() != null && ((AgendaItem)group.peek()).getTerminalNode().isFireDirect()) continue;
                this.unstageActivations();
            } while (tryagain);
        }
        finally {
            this.workingMemory.activationFired();
        }
        return localFireCount;
    }

    public void evaluateEagerList() {
        while (!this.eager.isEmpty()) {
            RuleAgendaItem item = this.eager.removeFirst();
            item.getRuleExecutor().evaluateNetwork(this.workingMemory);
        }
    }

    public int sizeOfRuleFlowGroup(String name) {
        InternalAgendaGroup group = this.agendaGroups.get(name);
        if (group == null) {
            return 0;
        }
        int count = 0;
        for (Activation item : group.getActivations()) {
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireActivation(Activation activation) throws ConsequenceException {
        this.workingMemory.startOperation();
        this.isFiringActivation = true;
        try {
            EventSupport eventsupport = (EventSupport)this.workingMemory;
            eventsupport.getAgendaEventSupport().fireBeforeActivationFired(activation, (WorkingMemory)this.workingMemory);
            if (activation.getActivationGroupNode() != null) {
                InternalActivationGroup activationGroup = activation.getActivationGroupNode().getActivationGroup();
                activationGroup.removeActivation(activation);
                this.clearAndCancelActivationGroup(activationGroup);
            }
            activation.setQueued(false);
            try {
                this.knowledgeHelper.setActivation(activation);
                if (log.isTraceEnabled()) {
                    log.trace("Fire \"{}\" \n{}", (Object)activation.getRule().getName(), (Object)activation.getTuple());
                }
                activation.getConsequence().evaluate(this.knowledgeHelper, (WorkingMemory)this.workingMemory);
                this.knowledgeHelper.cancelRemainingPreviousLogicalDependencies();
                this.knowledgeHelper.reset();
            }
            catch (Exception e) {
                if (this.legacyConsequenceExceptionHandler != null) {
                    this.legacyConsequenceExceptionHandler.handleException(activation, (WorkingMemory)this.workingMemory, e);
                }
                if (this.consequenceExceptionHandler != null) {
                    this.consequenceExceptionHandler.handleException((Match)activation, (RuleRuntime)this.workingMemory.getKnowledgeRuntime(), e);
                }
                throw new RuntimeException(e);
            }
            finally {
                if (activation.getFactHandle() != null) {
                    InternalFactHandle factHandle = activation.getFactHandle();
                    this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
                    activation.getPropagationContext().evaluateActionQueue(this.workingMemory);
                }
                for (LeftTuple tuple = activation.getTuple(); tuple != null; tuple = tuple.getParent()) {
                    if (tuple.getLastHandle() == null || !tuple.getLastHandle().isEvent()) continue;
                    EventFactHandle handle = (EventFactHandle)tuple.getLastHandle();
                    handle.decreaseActivationsCount();
                    if (!handle.isExpired() || handle.getActivationsCount() > 0L) continue;
                    handle.getEntryPoint().retract((FactHandle)handle);
                }
            }
            eventsupport.getAgendaEventSupport().fireAfterActivationFired(activation, this.workingMemory);
            this.unstageActivations();
        }
        finally {
            this.isFiringActivation = false;
            if (this.mustNotifyHalt) {
                this.mustNotifyHalt = false;
                this.notifyHalt();
            }
            this.workingMemory.endOperation();
        }
    }

    public synchronized boolean fireTimedActivation(Activation activation, boolean saveForLater) throws ConsequenceException {
        if (!this.halt.get()) {
            this.fireActivation(activation);
            return !this.halt.get();
        }
        return false;
    }

    public boolean isRuleInstanceAgendaItem(String ruleflowGroupName, String ruleName, long processInstanceId) {
        Activation[] matches;
        RuleFlowGroup systemRuleFlowGroup = this.getRuleFlowGroup(ruleflowGroupName);
        for (Activation match : matches = ((InternalAgendaGroup)systemRuleFlowGroup).getActivations()) {
            Activation act = match;
            if (!ruleName.equals(act.getRule().getName()) || !this.checkProcessInstance(act, processInstanceId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkProcessInstance(Activation activation, long processInstanceId) {
        Map declarations = activation.getSubRule().getOuterDeclarations();
        for (Declaration declaration : declarations.values()) {
            Object value;
            if (!"processInstance".equals(declaration.getIdentifier()) || !((value = declaration.getValue(this.workingMemory, activation.getTuple().get(declaration).getObject())) instanceof ProcessInstance)) continue;
            return ((ProcessInstance)value).getId() == processInstanceId;
        }
        return true;
    }

    public String getFocusName() {
        return this.getFocus().getName();
    }

    public boolean isFireUntilHalt() {
        return this.fireUntilHalt;
    }

    public void stageLeftTuple(RuleAgendaItem ruleAgendaItem, AgendaItem justified) {
        this.getStageActivationsGroup().addActivation((Activation)justified);
    }

    public void fireUntilHalt() {
        this.fireUntilHalt = true;
        this.fireUntilHalt(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        this.unstageActivations();
        this.halt.set(false);
        if (log.isTraceEnabled()) {
            log.trace("Starting fireUntilHalt");
        }
        while (this.continueFiring(-1)) {
            boolean fired = this.fireNextItem(agendaFilter, 0, -1) >= 0 || !((StatefulKnowledgeSessionImpl)this.workingMemory).getActionQueue().isEmpty();
            this.workingMemory.executeQueuedActions();
            if (!fired) {
                try {
                    AtomicBoolean atomicBoolean = this.halt;
                    synchronized (atomicBoolean) {
                        if (!this.halt.get()) {
                            this.halt.wait();
                        }
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    this.halt.set(true);
                    continue;
                }
            }
            this.workingMemory.executeQueuedActions();
        }
        if (log.isTraceEnabled()) {
            log.trace("Ending fireUntilHalt");
        }
        this.fireUntilHalt = false;
    }

    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        this.unstageActivations();
        this.halt.set(false);
        int fireCount = 0;
        int returnedFireCount = 0;
        do {
            returnedFireCount = this.fireNextItem(agendaFilter, fireCount, fireLimit);
            this.workingMemory.executeQueuedActions();
        } while (this.continueFiring(0) && returnedFireCount != 0 && (fireLimit == -1 || (fireCount += returnedFireCount) < fireLimit));
        if (this.focusStack.size() == 1 && this.getMainAgendaGroup().isEmpty()) {
            this.getMainAgendaGroup().setActive(false);
        }
        return fireCount;
    }

    public boolean continueFiring(int fireLimit) {
        return !this.halt.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyHalt() {
        AtomicBoolean atomicBoolean = this.halt;
        synchronized (atomicBoolean) {
            this.halt.notifyAll();
        }
    }

    public void halt() {
        this.halt.set(true);
        this.notifyHalt();
    }

    public ConsequenceExceptionHandler getConsequenceExceptionHandler() {
        return this.legacyConsequenceExceptionHandler;
    }

    public void setActivationsFilter(ActivationsFilter filter) {
        this.activationsFilter = filter;
    }

    public ActivationsFilter getActivationsFilter() {
        return this.activationsFilter;
    }

    public GarbageCollector getGarbageCollector() {
        return DUMMY_GARBAGE_COLLECTOR;
    }

    public static class DummyGarbageCollector
    implements GarbageCollector {
        public void increaseDeleteCounter() {
        }

        public void gcUnlinkedRules() {
        }

        public void forceGcUnlinkedRules() {
        }

        public void remove(RuleAgendaItem item) {
        }

        public void add(RuleAgendaItem item) {
        }

        public int getDeleteCounter() {
            return 0;
        }
    }
}

