/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.util.Collection;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.integrationtests.SerializationHelper;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.common.InternalAgenda;
import org.drools.core.impl.InternalKnowledgeBase;
import org.junit.Assert;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.RuleEngineOption;
import org.kie.internal.definition.KnowledgeDescr;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.StatelessKnowledgeSession;

public class CommonTestMethodBase
extends Assert {
    public static RuleEngineOption phreak = RuleEngineOption.RETEOO;

    protected StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase) {
        return kbase.newStatefulKnowledgeSession();
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase, KieSessionOption option) {
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption(option);
        return kbase.newStatefulKnowledgeSession(ksconf, null);
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase, KieSessionConfiguration ksconf) {
        return kbase.newStatefulKnowledgeSession(ksconf, null);
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase, KieSessionConfiguration ksconf, Environment env) {
        return kbase.newStatefulKnowledgeSession(ksconf, env);
    }

    protected StatelessKnowledgeSession createStatelessKnowledgeSession(KnowledgeBase kbase) {
        return kbase.newStatelessKnowledgeSession();
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString(null, null, phreak, drlContentStrings);
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(RuleEngineOption phreak, String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString(null, null, phreak, drlContentStrings);
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(KnowledgeBuilderConfiguration config, String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString(config, null, phreak, drlContentStrings);
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(KieBaseConfiguration kBaseConfig, String ... drlContentStrings) {
        return this.loadKnowledgeBaseFromString(null, kBaseConfig, phreak, drlContentStrings);
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(KnowledgeBuilderConfiguration config, KieBaseConfiguration kBaseConfig, RuleEngineOption phreak, String ... drlContentStrings) {
        KnowledgeBuilder kbuilder = config == null ? KnowledgeBuilderFactory.newKnowledgeBuilder() : KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)config);
        for (String drlContentString : drlContentStrings) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drlContentString.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            CommonTestMethodBase.fail((String)kbuilder.getErrors().toString());
        }
        if (kBaseConfig == null) {
            kBaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        }
        kBaseConfig.setOption((KieBaseOption)phreak);
        KnowledgeBase kbase = kBaseConfig == null ? KnowledgeBaseFactory.newKnowledgeBase() : KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kBaseConfig);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    protected KnowledgeBase loadKnowledgeBase(KnowledgeBuilderConfiguration kbuilderConf, KieBaseConfiguration kbaseConf, String ... classPathResources) {
        Collection<KnowledgePackage> knowledgePackages = this.loadKnowledgePackages(kbuilderConf, classPathResources);
        if (kbaseConf == null) {
            kbaseConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        }
        kbaseConf.setOption((KieBaseOption)phreak);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kbaseConf);
        kbase.addKnowledgePackages(knowledgePackages);
        try {
            kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return kbase;
    }

    protected KnowledgeBase loadKnowledgeBase(PackageDescr descr) {
        return this.loadKnowledgeBase(null, null, descr);
    }

    protected KnowledgeBase loadKnowledgeBase(KnowledgeBuilderConfiguration kbuilderConf, KieBaseConfiguration kbaseConf, PackageDescr descr) {
        Collection<KnowledgePackage> knowledgePackages = this.loadKnowledgePackages(kbuilderConf, descr);
        if (kbaseConf == null) {
            kbaseConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        }
        kbaseConf.setOption((KieBaseOption)phreak);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kbaseConf);
        kbase.addKnowledgePackages(knowledgePackages);
        try {
            kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return kbase;
    }

    public Collection<KnowledgePackage> loadKnowledgePackages(String ... classPathResources) {
        return this.loadKnowledgePackages((KnowledgeBuilderConfiguration)null, classPathResources);
    }

    public Collection<KnowledgePackage> loadKnowledgePackages(PackageDescr descr) {
        return this.loadKnowledgePackages(null, descr);
    }

    public Collection<KnowledgePackage> loadKnowledgePackages(KnowledgeBuilderConfiguration kbuilderConf, PackageDescr descr) {
        if (kbuilderConf == null) {
            kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConf);
        kbuilder.add(ResourceFactory.newDescrResource((KnowledgeDescr)descr), ResourceType.DESCR);
        if (kbuilder.hasErrors()) {
            CommonTestMethodBase.fail((String)kbuilder.getErrors().toString());
        }
        Collection knowledgePackages = kbuilder.getKnowledgePackages();
        return knowledgePackages;
    }

    public Collection<KnowledgePackage> loadKnowledgePackages(KnowledgeBuilderConfiguration kbuilderConf, String ... classPathResources) {
        return this.loadKnowledgePackages(kbuilderConf, true, classPathResources);
    }

    public Collection<KnowledgePackage> loadKnowledgePackages(KnowledgeBuilderConfiguration kbuilderConf, boolean serialize, String ... classPathResources) {
        if (kbuilderConf == null) {
            kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConf);
        for (String classPathResource : classPathResources) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)classPathResource, ((Object)((Object)this)).getClass()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            CommonTestMethodBase.fail((String)kbuilder.getErrors().toString());
        }
        Collection knowledgePackages = null;
        if (serialize) {
            try {
                knowledgePackages = (Collection)SerializationHelper.serializeObject((Object)kbuilder.getKnowledgePackages(), (ClassLoader)((KnowledgeBuilderConfigurationImpl)kbuilderConf).getClassLoader());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            knowledgePackages = kbuilder.getKnowledgePackages();
        }
        return knowledgePackages;
    }

    public Collection<KnowledgePackage> loadKnowledgePackagesFromString(String ... content) {
        return this.loadKnowledgePackagesFromString((KnowledgeBuilderConfiguration)null, content);
    }

    public Collection<KnowledgePackage> loadKnowledgePackagesFromString(KnowledgeBuilderConfiguration kbuilderConf, String ... content) {
        if (kbuilderConf == null) {
            kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConf);
        for (String r : content) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])r.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            CommonTestMethodBase.fail((String)kbuilder.getErrors().toString());
        }
        Collection knowledgePackages = kbuilder.getKnowledgePackages();
        return knowledgePackages;
    }

    protected KnowledgeBase loadKnowledgeBase(KnowledgeBuilderConfiguration kbuilderConf, String ... classPathResources) {
        return this.loadKnowledgeBase(kbuilderConf, (KieBaseConfiguration)null, classPathResources);
    }

    protected KnowledgeBase loadKnowledgeBase(KieBaseConfiguration kbaseConf, String ... classPathResources) {
        return this.loadKnowledgeBase(null, kbaseConf, classPathResources);
    }

    protected KnowledgeBase getKnowledgeBase() {
        KieBaseConfiguration kBaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kBaseConfig.setOption((KieBaseOption)phreak);
        return this.getKnowledgeBase(kBaseConfig);
    }

    protected KnowledgeBase getKnowledgeBase(KieBaseConfiguration kBaseConfig) {
        kBaseConfig.setOption((KieBaseOption)phreak);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kBaseConfig);
        try {
            kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase, (ClassLoader)((InternalKnowledgeBase)kbase).getRootClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return kbase;
    }

    protected KnowledgeBase loadKnowledgeBase(String ... classPathResources) {
        return this.loadKnowledgeBase((KnowledgeBuilderConfiguration)null, (KieBaseConfiguration)null, classPathResources);
    }

    protected InternalAgenda getInternalAgenda(StatefulKnowledgeSession session) {
        return (InternalAgenda)session.getAgenda();
    }

    public static byte[] createJar(KieServices ks, ReleaseId releaseId, String ... drls) {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId);
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/r" + i + ".drl", drls[i]);
        }
        ks.newKieBuilder(kfs).buildAll();
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        return jar;
    }

    public static KieModule createAndDeployJar(KieServices ks, ReleaseId releaseId, String ... drls) {
        byte[] jar = CommonTestMethodBase.createJar(ks, releaseId, drls);
        KieModule km = CommonTestMethodBase.deployJarIntoRepository(ks, jar);
        return km;
    }

    public static KieModule createAndDeployJar(KieServices ks, String kmoduleContent, ReleaseId releaseId, Resource ... resources) {
        byte[] jar = CommonTestMethodBase.createJar(ks, kmoduleContent, releaseId, resources);
        KieModule km = CommonTestMethodBase.deployJarIntoRepository(ks, jar);
        return km;
    }

    public static byte[] createJar(KieServices ks, String kmoduleContent, ReleaseId releaseId, Resource ... resources) {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).writeKModuleXML(kmoduleContent);
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            kfs.write(resources[i]);
        }
        ks.newKieBuilder(kfs).buildAll();
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        return jar;
    }

    private static KieModule deployJarIntoRepository(KieServices ks, byte[] jar) {
        Resource jarRes = ks.getResources().newByteArrayResource(jar);
        KieModule km = ks.getRepository().addKieModule(jarRes, new Resource[0]);
        return km;
    }

    public static byte[] createKJar(KieServices ks, ReleaseId releaseId, Resource pom, Resource ... resources) {
        KieFileSystem kfs = ks.newKieFileSystem();
        if (pom != null) {
            kfs.write(pom);
        } else {
            kfs.generateAndWritePomXML(releaseId);
        }
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            kfs.write(resources[i]);
        }
        ks.newKieBuilder(kfs).buildAll();
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        return jar;
    }

    public static byte[] createKJar(KieServices ks, ReleaseId releaseId, String pom, String ... drls) {
        KieFileSystem kfs = ks.newKieFileSystem();
        if (pom != null) {
            kfs.write("pom.xml", pom);
        } else {
            kfs.generateAndWritePomXML(releaseId);
        }
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/r" + i + ".drl", drls[i]);
        }
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            for (Message result : kb.getResults().getMessages()) {
                System.out.println(result.getText());
            }
            return null;
        }
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        return jar;
    }

    public static KieModule deployJar(KieServices ks, byte[] jar) {
        Resource jarRes = ks.getResources().newByteArrayResource(jar);
        KieModule km = ks.getRepository().addKieModule(jarRes, new Resource[0]);
        return km;
    }
}

