/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.compiler.Address;
import org.drools.compiler.Cheese;
import org.drools.compiler.DomainObject;
import org.drools.compiler.InsertedObject;
import org.drools.compiler.Interval;
import org.drools.compiler.Person;
import org.drools.compiler.Worker;
import org.drools.compiler.integrationtests.SerializationHelper;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.MemoryFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.runtime.rule.impl.FlatQueryResults;
import org.drools.reteoo.integrationtests.CommonTestMethodBase;
import org.junit.Test;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.QueryListenerOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Row;
import org.kie.api.runtime.rule.Variable;
import org.kie.api.runtime.rule.ViewChangedEventListener;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.conf.RuleEngineOption;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class QueryTest
extends CommonTestMethodBase {
    @Test
    public void testQuery() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("simple_query_test.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        Cheese stilton = new Cheese("stinky", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        QueryResults results = session.getQueryResults("simple query", new Object[0]);
        QueryTest.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testQueryRemoval() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("simple_query_test.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        Cheese stilton = new Cheese("stinky", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        QueryResults results = session.getQueryResults("simple query", new Object[0]);
        QueryTest.assertEquals((long)1L, (long)results.size());
        Rule rule = (Rule)kbase.getKnowledgePackage("org.drools.compiler.test").getRules().iterator().next();
        QueryTest.assertEquals((Object)"simple query", (Object)rule.getName());
        kbase.removeQuery("org.drools.compiler.test", "simple query");
        QueryTest.assertTrue((boolean)kbase.getKnowledgePackage("org.drools.compiler.test").getRules().isEmpty());
        try {
            results = session.getQueryResults("simple query", new Object[0]);
        }
        catch (Exception e) {
            QueryTest.assertTrue((boolean)e.getMessage().endsWith("does not exist"));
        }
    }

    @Test
    public void testQuery2() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_Query.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.fireAllRules();
        QueryResults results = session.getQueryResults("assertedobjquery", new Object[0]);
        QueryTest.assertEquals((long)1L, (long)results.size());
        QueryTest.assertEquals((Object)new InsertedObject("value1"), (Object)((InternalFactHandle)((QueryResultsRow)results.iterator().next()).getFactHandle("assertedobj")).getObject());
    }

    @Test
    public void testQueryWithParams() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_QueryWithParams.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.fireAllRules();
        QueryResults results = session.getQueryResults("assertedobjquery", (Object[])new String[]{"value1"});
        QueryTest.assertEquals((long)1L, (long)results.size());
        QueryTest.assertEquals((Object)new InsertedObject("value1"), (Object)((InternalFactHandle)((QueryResultsRow)results.iterator().next()).getFactHandle("assertedobj")).getObject());
        results = session.getQueryResults("assertedobjquery", (Object[])new String[]{"value3"});
        QueryTest.assertEquals((long)0L, (long)results.size());
        results = session.getQueryResults("assertedobjquery2", (Object[])new String[]{null, "value2"});
        QueryTest.assertEquals((long)1L, (long)results.size());
        QueryTest.assertEquals((Object)new InsertedObject("value2"), (Object)((InternalFactHandle)((QueryResultsRow)results.iterator().next()).getFactHandle("assertedobj")).getObject());
        results = session.getQueryResults("assertedobjquery2", (Object[])new String[]{"value3", "value2"});
        QueryTest.assertEquals((long)1L, (long)results.size());
        QueryTest.assertEquals((Object)new InsertedObject("value2"), (Object)((InternalFactHandle)((QueryResultsRow)results.iterator().next()).getFactHandle("assertedobj")).getObject());
    }

    @Test
    public void testQueryWithMultipleResultsOnKnowledgeApi() throws Exception {
        String str = "";
        str = str + "package org.drools.compiler.test  \n";
        str = str + "import org.drools.compiler.Cheese \n";
        str = str + "query cheeses \n";
        str = str + "    stilton : Cheese(type == 'stilton') \n";
        str = str + "    cheddar : Cheese(type == 'cheddar', price == stilton.price) \n";
        str = str + "end\n";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(str));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        HashSet set = new HashSet();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(stilton1);
        list.add(cheddar1);
        set.add(list);
        list = new ArrayList();
        list.add(stilton2);
        list.add(cheddar2);
        set.add(list);
        list = new ArrayList();
        list.add(stilton3);
        list.add(cheddar3);
        set.add(list);
        session.insert((Object)stilton1);
        session.insert((Object)stilton2);
        session.insert((Object)stilton3);
        session.insert((Object)cheddar1);
        session.insert((Object)cheddar2);
        session.insert((Object)cheddar3);
        QueryResults results = session.getQueryResults("cheeses", new Object[0]);
        QueryTest.assertEquals((long)3L, (long)results.size());
        QueryTest.assertEquals((long)2L, (long)results.getIdentifiers().length);
        HashSet<ArrayList<Object>> newSet = new HashSet<ArrayList<Object>>();
        for (QueryResultsRow result : results) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        QueryTest.assertEquals(set, newSet);
        FlatQueryResults flatResults = new FlatQueryResults(((StatefulKnowledgeSessionImpl)session).getQueryResults("cheeses", new Object[0]));
        QueryTest.assertEquals((long)3L, (long)flatResults.size());
        QueryTest.assertEquals((long)2L, (long)flatResults.getIdentifiers().length);
        newSet = new HashSet();
        for (QueryResultsRow result : flatResults) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        QueryTest.assertEquals(set, newSet);
    }

    @Test
    public void testTwoQuerries() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_TwoQuerries.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        Cheese stilton = new Cheese("stinky", 5);
        session.insert((Object)stilton);
        Person per1 = new Person("stinker", "smelly feet", 70);
        Person per2 = new Person("skunky", "smelly armpits", 40);
        session.insert((Object)per1);
        session.insert((Object)per2);
        QueryResults results = session.getQueryResults("find stinky cheeses", new Object[0]);
        QueryTest.assertEquals((long)1L, (long)results.size());
        results = session.getQueryResults("find pensioners", new Object[0]);
        QueryTest.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testDoubleQueryWithExists() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_DoubleQueryWithExists.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        Person p1 = new Person("p1", "stilton", 20);
        p1.setStatus("europe");
        FactHandle c1FactHandle = session.insert((Object)p1);
        Person p2 = new Person("p2", "stilton", 30);
        p2.setStatus("europe");
        FactHandle c2FactHandle = session.insert((Object)p2);
        Person p3 = new Person("p3", "stilton", 40);
        p3.setStatus("europe");
        FactHandle c3FactHandle = session.insert((Object)p3);
        session.fireAllRules();
        QueryResults results = session.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((long)2L, (long)results.size());
        p3.setStatus("america");
        session.update(c3FactHandle, (Object)p3);
        session.fireAllRules();
        results = session.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((long)1L, (long)results.size());
        p2.setStatus("america");
        session.update(c2FactHandle, (Object)p2);
        session.fireAllRules();
        results = session.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((long)1L, (long)results.size());
        p1.setStatus("america");
        session.update(c1FactHandle, (Object)p1);
        session.fireAllRules();
        results = session.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((long)2L, (long)results.size());
        p2.setStatus("europe");
        session.update(c2FactHandle, (Object)p2);
        session.fireAllRules();
        results = session.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((long)1L, (long)results.size());
        p1.setStatus("europe");
        session.update(c1FactHandle, (Object)p1);
        session.fireAllRules();
        results = session.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((long)1L, (long)results.size());
        p3.setStatus("europe");
        session.update(c3FactHandle, (Object)p3);
        session.fireAllRules();
        results = session.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testQueryWithCollect() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_Query.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.fireAllRules();
        QueryResults results = session.getQueryResults("collect objects", new Object[0]);
        QueryTest.assertEquals((long)1L, (long)results.size());
        QueryResultsRow row = (QueryResultsRow)results.iterator().next();
        List list = (List)row.get("$list");
        QueryTest.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testDroolsQueryCleanup() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_QueryMemoryLeak.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        String workerId = "B1234";
        Worker worker = new Worker();
        worker.setId(workerId);
        FactHandle handle = ksession.insert((Object)worker);
        ksession.fireAllRules();
        QueryTest.assertNotNull((Object)handle);
        QueryResults retractedWorker = null;
        for (int i = 0; i < 100; ++i) {
            retractedWorker = ksession.getQueryResults("getWorker", new Object[]{workerId});
        }
        QueryTest.assertNotNull(retractedWorker);
        StatefulKnowledgeSessionImpl sessionImpl = (StatefulKnowledgeSessionImpl)ksession;
        Collection entryPointNodes = sessionImpl.getKnowledgeBase().getRete().getEntryPointNodes().values();
        EntryPointNode defaultEntryPointNode = null;
        for (EntryPointNode epNode : entryPointNodes) {
            if (!epNode.getEntryPoint().getEntryPointId().equals("DEFAULT")) continue;
            defaultEntryPointNode = epNode;
            break;
        }
        QueryTest.assertNotNull(defaultEntryPointNode);
        Map obnodes = defaultEntryPointNode.getObjectTypeNodes();
        ClassObjectType key = new ClassObjectType(DroolsQuery.class);
        ObjectTypeNode droolsQueryNode = (ObjectTypeNode)obnodes.get(key);
        Iterator it = ((ObjectTypeNode.ObjectTypeNodeMemory)sessionImpl.getNodeMemory((MemoryFactory)droolsQueryNode)).iterator();
        QueryTest.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testQueriesWithVariableUnification() throws Exception {
        String str = "";
        str = str + "package org.drools.compiler.test  \n";
        str = str + "import org.drools.compiler.Person \n";
        str = str + "query peeps( String $name, String $likes, int $age ) \n";
        str = str + "    $p : Person( $name := name, $likes := likes, $age := age ) \n";
        str = str + "end\n";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(str));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 300);
        Person p3 = new Person("luke", "brie", 300);
        Person p4 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        QueryResults results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, Variable.v});
        QueryTest.assertEquals((long)4L, (long)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((long)4L, (long)names.size());
        QueryTest.assertTrue((boolean)names.contains("luke"));
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        QueryTest.assertTrue((boolean)names.contains("bobba"));
        QueryTest.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, 300});
        QueryTest.assertEquals((long)3L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((long)3L, (long)names.size());
        QueryTest.assertTrue((boolean)names.contains("luke"));
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        QueryTest.assertTrue((boolean)names.contains("bobba"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, "stilton", 300});
        QueryTest.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((long)1L, (long)names.size());
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, "stilton", Variable.v});
        QueryTest.assertEquals((long)2L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((long)2L, (long)names.size());
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        QueryTest.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{"darth", Variable.v, Variable.v});
        QueryTest.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((long)1L, (long)names.size());
        QueryTest.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testQueriesWithVariableUnificationOnPatterns() throws Exception {
        String str = "";
        str = str + "package org.drools.compiler.test  \n";
        str = str + "import org.drools.compiler.Person \n";
        str = str + "query peeps( Person $p, String $name, String $likes, int $age ) \n";
        str = str + "    $p := Person( $name := name, $likes := likes, $age := age ) \n";
        str = str + "end\n";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(str));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 300);
        Person p3 = new Person("luke", "brie", 300);
        Person p4 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        QueryResults results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, Variable.v, Variable.v});
        QueryTest.assertEquals((long)4L, (long)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((long)4L, (long)names.size());
        QueryTest.assertTrue((boolean)names.contains("luke"));
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        QueryTest.assertTrue((boolean)names.contains("bobba"));
        QueryTest.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{p1, Variable.v, Variable.v, Variable.v});
        QueryTest.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((long)1L, (long)names.size());
        QueryTest.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testQueriesWithVariableUnificationOnNestedFields() throws Exception {
        String str = "";
        str = str + "package org.drools.compiler.test  \n";
        str = str + "import org.drools.compiler.Person \n";
        str = str + "query peeps( String $name, String $likes, String $street) \n";
        str = str + "    $p : Person( $name := name, $likes := likes, $street := address.street ) \n";
        str = str + "end\n";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(str));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Person p1 = new Person("darth", "stilton", 100);
        p1.setAddress(new Address("s1"));
        Person p2 = new Person("yoda", "stilton", 300);
        p2.setAddress(new Address("s2"));
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        QueryResults results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, Variable.v});
        QueryTest.assertEquals((long)2L, (long)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        QueryTest.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, "s1"});
        QueryTest.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testOpenQuery() throws Exception {
        if (CommonTestMethodBase.phreak == RuleEngineOption.RETEOO) {
            return;
        }
        String str = "";
        str = str + "package org.drools.compiler.test  \n";
        str = str + "import org.drools.compiler.Cheese \n";
        str = str + "query cheeses(String $type1, String $type2) \n";
        str = str + "    stilton : Cheese(type == $type1, $sprice : price) \n";
        str = str + "    cheddar : Cheese(type == $type2, $cprice : price == stilton.price) \n";
        str = str + "end\n";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(str));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        FactHandle s1Fh = ksession.insert((Object)stilton1);
        ksession.insert((Object)stilton2);
        ksession.insert((Object)stilton3);
        ksession.insert((Object)cheddar1);
        ksession.insert((Object)cheddar2);
        FactHandle c3Fh = ksession.insert((Object)cheddar3);
        final ArrayList updated = new ArrayList();
        final ArrayList removed = new ArrayList();
        final ArrayList added = new ArrayList();
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                updated.add(array);
            }

            public void rowDeleted(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                removed.add(array);
            }

            public void rowInserted(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                added.add(array);
            }
        };
        LiveQuery query = ksession.openLiveQuery("cheeses", new Object[]{"stilton", "cheddar"}, listener);
        ksession.fireAllRules();
        QueryTest.assertEquals((long)3L, (long)added.size());
        QueryTest.assertEquals((long)0L, (long)removed.size());
        QueryTest.assertEquals((long)0L, (long)updated.size());
        QueryTest.assertSame((Object)stilton1, (Object)((Object[])added.get(2))[0]);
        QueryTest.assertSame((Object)cheddar1, (Object)((Object[])added.get(2))[1]);
        QueryTest.assertEquals((Object)1, (Object)((Object[])added.get(2))[2]);
        QueryTest.assertEquals((Object)1, (Object)((Object[])added.get(2))[3]);
        QueryTest.assertEquals((Object)"stilton", (Object)((Object[])added.get(2))[4]);
        QueryTest.assertEquals((Object)"cheddar", (Object)((Object[])added.get(2))[5]);
        QueryTest.assertEquals((Object)3, (Object)((Object[])added.get(0))[3]);
        QueryTest.assertEquals((Object)2, (Object)((Object[])added.get(1))[3]);
        QueryTest.assertEquals((Object)1, (Object)((Object[])added.get(2))[3]);
        cheddar3.setPrice(4);
        ksession.update(c3Fh, (Object)cheddar3);
        ksession.fireAllRules();
        QueryTest.assertEquals((long)3L, (long)added.size());
        QueryTest.assertEquals((long)1L, (long)removed.size());
        QueryTest.assertEquals((long)0L, (long)updated.size());
        QueryTest.assertEquals((Object)4, (Object)((Object[])removed.get(0))[3]);
        cheddar3.setPrice(3);
        ksession.update(c3Fh, (Object)cheddar3);
        ksession.fireAllRules();
        QueryTest.assertEquals((long)4L, (long)added.size());
        QueryTest.assertEquals((long)1L, (long)removed.size());
        QueryTest.assertEquals((long)0L, (long)updated.size());
        QueryTest.assertEquals((Object)3, (Object)((Object[])added.get(3))[3]);
        cheddar3.setOldPrice(0);
        ksession.update(c3Fh, (Object)cheddar3);
        ksession.fireAllRules();
        QueryTest.assertEquals((long)4L, (long)added.size());
        QueryTest.assertEquals((long)1L, (long)removed.size());
        QueryTest.assertEquals((long)1L, (long)updated.size());
        QueryTest.assertEquals((Object)3, (Object)((Object[])updated.get(0))[3]);
        ksession.retract(s1Fh);
        ksession.fireAllRules();
        QueryTest.assertEquals((long)4L, (long)added.size());
        QueryTest.assertEquals((long)2L, (long)removed.size());
        QueryTest.assertEquals((long)1L, (long)updated.size());
        QueryTest.assertEquals((Object)1, (Object)((Object[])removed.get(1))[3]);
        query.close();
        ksession.fireAllRules();
        QueryTest.assertEquals((long)4L, (long)added.size());
        QueryTest.assertEquals((long)4L, (long)removed.size());
        QueryTest.assertEquals((long)1L, (long)updated.size());
        QueryTest.assertEquals((Object)2, (Object)((Object[])removed.get(3))[3]);
        QueryTest.assertEquals((Object)3, (Object)((Object[])removed.get(2))[3]);
        ksession.update(c3Fh, (Object)cheddar3);
        QueryTest.assertEquals((long)4L, (long)added.size());
        QueryTest.assertEquals((long)4L, (long)removed.size());
        QueryTest.assertEquals((long)1L, (long)updated.size());
    }

    @Test
    public void testStandardQueryListener() throws IOException, ClassNotFoundException {
        this.runQueryListenerTest(QueryListenerOption.STANDARD);
    }

    @Test
    public void testNonCloningQueryListener() throws IOException, ClassNotFoundException {
        this.runQueryListenerTest(QueryListenerOption.LIGHTWEIGHT);
    }

    public void runQueryListenerTest(QueryListenerOption option) throws IOException, ClassNotFoundException {
        String str = "";
        str = str + "package org.drools.compiler.integrationtests\n";
        str = str + "import " + Cheese.class.getCanonicalName() + " \n";
        str = str + "query cheeses(String $type) \n";
        str = str + "    $cheese : Cheese(type == $type) \n";
        str = str + "end\n";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(str));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase, (KieSessionOption)option);
        for (int i = 0; i < 10000; ++i) {
            ksession.insert((Object)new Cheese(i % 2 == 0 ? "stilton" : "brie"));
        }
        for (int i = 0; i < 100; ++i) {
            QueryResults queryResults = ksession.getQueryResults("cheeses", new Object[]{"stilton"});
            ArrayList<Cheese> cheeses = new ArrayList<Cheese>();
            for (QueryResultsRow row : queryResults) {
                cheeses.add((Cheese)row.get("$cheese"));
            }
            QueryTest.assertEquals((long)5000L, (long)cheeses.size());
        }
    }

    @Test
    public void testQueryWithEval() throws IOException, ClassNotFoundException {
        String str = "package org.drools.compiler.integrationtests\nimport " + DomainObject.class.getCanonicalName() + " \nquery queryWithEval \n    $do: DomainObject()\n    not DomainObject( id == $do.id, eval(interval.isAfter($do.getInterval())))\nend";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(str));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        DomainObject do1 = new DomainObject();
        do1.setId(1L);
        do1.setInterval(new Interval(10L, 5L));
        DomainObject do2 = new DomainObject();
        do2.setId(1L);
        do2.setInterval(new Interval(20L, 5L));
        ksession.insert((Object)do1);
        ksession.insert((Object)do2);
        QueryResults results = ksession.getQueryResults("queryWithEval", new Object[0]);
        QueryTest.assertEquals((long)1L, (long)results.size());
        QueryTest.assertEquals((Object)do2, (Object)((QueryResultsRow)results.iterator().next()).get("$do"));
        ksession.dispose();
    }
}

