/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import org.drools.compiler.integrationtests.SerializationHelper;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.reteoo.integrationtests.CommonTestMethodBase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class MarshallingIssuesTest
extends CommonTestMethodBase {
    @Test
    public void testJBRULES_1946() {
        KnowledgeBase kbase = this.loadKnowledgeBase("../Sample.drl");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            ObjectInputStream ois = new ObjectInputStream(bais);
            KnowledgeBase knowledgeBase = (KnowledgeBase)ois.readObject();
        }
        catch (OptionalDataException ode) {
            ode.printStackTrace();
            MarshallingIssuesTest.fail((String)("EOF? " + ode.eof));
        }
        catch (Exception e) {
            e.printStackTrace();
            MarshallingIssuesTest.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_1946_2() {
        KnowledgeBase kbase = this.loadKnowledgeBase("../Sample.drl");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream((OutputStream)baos);
            oos.writeObject((Object)kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            DroolsObjectInputStream ois = new DroolsObjectInputStream((InputStream)bais);
            KnowledgeBase knowledgeBase = (KnowledgeBase)ois.readObject();
        }
        catch (OptionalDataException ode) {
            ode.printStackTrace();
            MarshallingIssuesTest.fail((String)("EOF? " + ode.eof));
        }
        catch (Exception e) {
            e.printStackTrace();
            MarshallingIssuesTest.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_1946_3() {
        KnowledgeBase kbase = this.loadKnowledgeBase("../Sample.drl");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream((OutputStream)baos);
            oos.writeObject((Object)kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            ObjectInputStream ois = new ObjectInputStream(bais);
            KnowledgeBase kb2 = (KnowledgeBase)ois.readObject();
            MarshallingIssuesTest.fail((String)"Should have raised an IllegalArgumentException since the kbase was serialized with a Drools Stream but deserialized with a regular stream");
        }
        catch (IllegalArgumentException baos) {
        }
        catch (Exception e) {
            e.printStackTrace();
            MarshallingIssuesTest.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_2331() throws Exception {
        String source = "package test.drl\n";
        source = source + "rule dummy_rule\n";
        source = source + "when\n";
        source = source + "eval( false )\n";
        source = source + "then\n";
        source = source + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(source);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        MarshallingIssuesTest.assertNotNull((Object)ksession);
        ksession.dispose();
    }
}

